/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.commons.security.exceptions.BadHttpStatusCodeException;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class DownloadPanel
extends JPanel
implements Observer {
    private static final Logger LOG = Logger.getLogger(DownloadPanel.class);
    private Download download;
    private boolean small;
    private JButton btnCancel;
    private JXHyperlink jxlOpenFile;
    private JLabel lblIcon;
    private JLabel lblMessage;
    private JLabel lblTime;
    private JLabel lblTitle;
    private JMenuItem mniOpenDirectory;
    private JMenuItem mniOpenFile;
    private JMenuItem mniRemove;
    private JPopupMenu popContextMenu;
    private JProgressBar prbProgress;
    private JPopupMenu.Separator sepContextMenuOpenRemove;
    private JSeparator sepDownloadPanels;

    public DownloadPanel(Download download) {
        this(download, false, false);
    }

    public DownloadPanel(Download download, boolean small, boolean hideSeparator) {
        this.download = download;
        this.small = small;
        this.initComponents();
        this.prbProgress.setMinimum(0);
        this.prbProgress.setMaximum(100);
        if (this.small) {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 44));
            this.setMinimumSize(new Dimension(135, 44));
            this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/documenttypes/fallback_single_16.png")));
            this.remove(this.lblTitle);
            this.remove(this.lblTime);
            this.remove(this.lblMessage);
            this.remove((Component)this.jxlOpenFile);
            this.remove(this.prbProgress);
            this.popContextMenu.remove(this.sepContextMenuOpenRemove);
            this.popContextMenu.remove(this.mniRemove);
            this.lblTitle.setFont(new Font("Tahoma", 0, 12));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.lblTitle, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 22;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.lblTime, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            this.add((Component)this.lblMessage, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            this.add((Component)this.jxlOpenFile, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            this.add((Component)this.prbProgress, gridBagConstraints);
        }
        this.sepDownloadPanels.setVisible(!hideSeparator);
        this.updateComponents();
    }

    private void initComponents() {
        this.popContextMenu = new JPopupMenu();
        this.mniOpenFile = new JMenuItem();
        this.mniOpenDirectory = new JMenuItem();
        this.sepContextMenuOpenRemove = new JPopupMenu.Separator();
        this.mniRemove = new JMenuItem();
        this.lblIcon = new JLabel();
        this.lblTitle = new JLabel();
        this.lblMessage = new JLabel();
        this.sepDownloadPanels = new JSeparator();
        this.prbProgress = new JProgressBar();
        this.lblTime = new JLabel();
        this.jxlOpenFile = new JXHyperlink();
        this.btnCancel = new JButton();
        this.mniOpenFile.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.mniOpenFile.text"));
        this.mniOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.mniOpenFileActionPerformed(evt);
            }
        });
        this.popContextMenu.add(this.mniOpenFile);
        this.mniOpenDirectory.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.mniOpenDirectory.text"));
        this.mniOpenDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.mniOpenDirectoryActionPerformed(evt);
            }
        });
        this.popContextMenu.add(this.mniOpenDirectory);
        this.popContextMenu.add(this.sepContextMenuOpenRemove);
        this.mniRemove.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.mniRemove.text"));
        this.mniRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.mniRemoveActionPerformed(evt);
            }
        });
        this.popContextMenu.add(this.mniRemove);
        this.setComponentPopupMenu(this.popContextMenu);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 54));
        this.setMinimumSize(new Dimension(135, 54));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DownloadPanel.this.formMouseClicked(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/documenttypes/fallback_single_32.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblIcon, gridBagConstraints);
        this.lblTitle.setFont(new Font("Tahoma", 0, 14));
        this.lblTitle.setText(this.download.getTitle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.lblMessage.setBackground(new Color(255, 102, 0));
        this.lblMessage.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.lblMessage.text"));
        this.lblMessage.setMaximumSize(new Dimension(Short.MAX_VALUE, 15));
        this.lblMessage.setMinimumSize(new Dimension(10, 15));
        this.lblMessage.setPreferredSize(new Dimension(8, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblMessage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.sepDownloadPanels, gridBagConstraints);
        this.prbProgress.setBorderPainted(false);
        this.prbProgress.setIndeterminate(true);
        this.prbProgress.setMaximumSize(new Dimension(Short.MAX_VALUE, 15));
        this.prbProgress.setMinimumSize(new Dimension(10, 15));
        this.prbProgress.setPreferredSize(new Dimension(146, 15));
        this.prbProgress.setString(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.prbProgress.string"));
        this.prbProgress.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.prbProgress, gridBagConstraints);
        this.lblTime.setText(DateFormat.getTimeInstance(3).format(new Date()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblTime, gridBagConstraints);
        this.jxlOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.jxlOpenFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jxlOpenFile, gridBagConstraints);
        if (this.download instanceof Cancellable) {
            this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/res/cross-circle.png_16x16.png")));
            this.btnCancel.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.btnCancel.text"));
            this.btnCancel.setToolTipText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.btnCancel.toolTipText"));
            this.btnCancel.setBorderPainted(false);
            this.btnCancel.setContentAreaFilled(false);
            this.btnCancel.setFocusPainted(false);
            this.btnCancel.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/res/cross-circle-frame.png_16x16.png")));
        }
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadPanel.this.btnCancelActionPerformed(evt);
            }
        });
        if (this.download instanceof Cancellable) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 15;
            this.add((Component)this.btnCancel, gridBagConstraints);
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.download.getCaughtException() != null) {
                DownloadManagerDialog.getInstance().showTheExceptionDialog(this.download);
            } else if (this.download.getStatus() == Download.State.COMPLETED && this.download.getFileToSaveTo() != null) {
                BrowserLauncher.openURLorFile((String)this.download.getFileToSaveTo().getParentFile().getAbsolutePath());
            }
        }
    }

    private void jxlOpenFileActionPerformed(ActionEvent evt) {
        BrowserLauncher.openURLorFile((String)this.download.getFileToSaveTo().getAbsolutePath());
    }

    private void mniOpenFileActionPerformed(ActionEvent evt) {
        BrowserLauncher.openURLorFile((String)this.download.getFileToSaveTo().getAbsolutePath());
    }

    private void mniOpenDirectoryActionPerformed(ActionEvent evt) {
        BrowserLauncher.openURLorFile((String)this.download.getFileToSaveTo().getParentFile().getAbsolutePath());
    }

    private void mniRemoveActionPerformed(ActionEvent evt) {
        DownloadManager.instance().removeDownload(this.download);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.download instanceof Cancellable) {
            ((Cancellable)this.download).cancel();
        }
    }

    private void initIcon() {
        String extensionOfIcon;
        if (this.download.getFileToSaveTo() == null) {
            return;
        }
        String extensionOfDownload = this.download.getFileToSaveTo().getName().trim();
        String string = extensionOfIcon = this.small ? "_16.png" : "_32.png";
        if (extensionOfDownload == null || extensionOfDownload.lastIndexOf(46) < 0) {
            return;
        }
        extensionOfDownload = extensionOfDownload.substring(extensionOfDownload.lastIndexOf(46) + 1, extensionOfDownload.length()).toLowerCase();
        URL iconURL = this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/documenttypes/" + extensionOfDownload + extensionOfIcon);
        if (iconURL != null) {
            this.lblIcon.setIcon(new ImageIcon(iconURL));
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == null || !o.equals(this.download)) {
            return;
        }
        this.updateComponents();
        this.revalidate();
        this.repaint();
    }

    private void updateComponents() {
        this.initIcon();
        switch (this.download.getStatus()) {
            case WAITING: {
                this.prbProgress.setVisible(false);
                this.lblTitle.setText(this.download.getTitle());
                this.lblMessage.setVisible(true);
                this.jxlOpenFile.setVisible(false);
                this.mniOpenFile.setEnabled(false);
                this.mniOpenDirectory.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniRemove.setEnabled(true);
                break;
            }
            case RUNNING: {
                this.prbProgress.setVisible(true);
                this.prbProgress.setIndeterminate(true);
                this.lblTitle.setText(this.download.getTitle());
                this.lblMessage.setVisible(false);
                this.jxlOpenFile.setVisible(false);
                this.mniOpenFile.setEnabled(false);
                this.mniOpenDirectory.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniRemove.setEnabled(false);
                this.lblTitle.setForeground(SystemColor.textText);
                break;
            }
            case RUNNING_WITH_PROGRESS: {
                this.prbProgress.setVisible(true);
                this.prbProgress.setIndeterminate(false);
                this.prbProgress.setValue(this.download.getProgress());
                this.lblTitle.setText(this.download.getTitle());
                this.lblMessage.setVisible(false);
                this.jxlOpenFile.setVisible(false);
                this.mniOpenFile.setEnabled(false);
                this.mniOpenDirectory.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniRemove.setEnabled(false);
                this.lblTitle.setForeground(SystemColor.textText);
                break;
            }
            case COMPLETED: {
                this.prbProgress.setVisible(false);
                this.lblTitle.setText(this.download.getTitle());
                this.lblMessage.setVisible(false);
                this.btnCancel.setVisible(false);
                this.jxlOpenFile.setText(this.download.getFileToSaveTo() != null ? this.download.getFileToSaveTo().getAbsolutePath() : "");
                this.jxlOpenFile.setVisible(this.download.getFileToSaveTo() != null);
                this.mniOpenFile.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniOpenDirectory.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniRemove.setEnabled(true);
                this.lblTitle.setForeground(SystemColor.textInactiveText);
                this.download.deleteObserver(this);
                break;
            }
            case COMPLETED_WITH_ERROR: {
                this.prbProgress.setVisible(false);
                this.lblTitle.setText(this.download.getTitle());
                this.jxlOpenFile.setVisible(false);
                this.mniOpenFile.setEnabled(false);
                this.mniOpenDirectory.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniRemove.setEnabled(true);
                this.btnCancel.setVisible(false);
                this.lblTitle.setForeground(SystemColor.textInactiveText);
                this.setBackground(Color.pink);
                this.download.deleteObserver(this);
                this.lblMessage.setVisible(true);
                this.lblMessage.setForeground(Color.red);
                if (this.download.getCaughtException() instanceof BadHttpStatusCodeException) {
                    BadHttpStatusCodeException exception = (BadHttpStatusCodeException)this.download.getCaughtException();
                    if (exception.getStatuscode() == 204) {
                        this.lblMessage.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.lblMessage.noData", (Object)this.download.getTitle()));
                        break;
                    }
                    this.lblMessage.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.lblMessage.error"));
                    break;
                }
                this.lblMessage.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.lblMessage.error"));
                break;
            }
            case ABORTED: {
                this.prbProgress.setVisible(false);
                this.lblTitle.setText(this.download.getTitle());
                this.jxlOpenFile.setVisible(false);
                this.mniOpenFile.setEnabled(false);
                this.mniOpenDirectory.setEnabled(this.download.getFileToSaveTo() != null);
                this.mniRemove.setEnabled(true);
                this.btnCancel.setVisible(false);
                this.lblTitle.setForeground(SystemColor.textInactiveText);
                this.download.deleteObserver(this);
                this.lblMessage.setVisible(true);
                this.lblMessage.setText(NbBundle.getMessage(DownloadPanel.class, (String)"DownloadPanel.lblMessage.aborted", (Object)this.download.getTitle()));
            }
        }
    }
}

