/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.exceptions.BadHttpStatusCodeException;
import de.cismet.security.WebAccessManager;
import de.cismet.security.exceptions.AccessMethodIsNotSupportedException;
import de.cismet.security.exceptions.MissingArgumentException;
import de.cismet.security.exceptions.NoHandlerForURLException;
import de.cismet.security.exceptions.RequestFailedException;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.BadHttpStatusCodeExceptionPanel;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class HttpDownload
extends AbstractCancellableDownload {
    private static final Logger LOG = Logger.getLogger(HttpDownload.class);
    private static final int MAX_BUFFER_SIZE = 1024;
    private URL url;
    private String request;
    private HashMap<String, String> headers;

    public HttpDownload() {
    }

    public HttpDownload(URL url, String request, String directory, String title, String filename, String extension) {
        this(url, request, new HashMap<String, String>(), directory, title, filename, extension);
    }

    public HttpDownload(URL url, String request, HashMap<String, String> headers, String directory, String title, String filename, String extension) {
        this.url = url;
        this.request = request;
        this.directory = directory;
        this.title = title;
        this.headers = headers;
        this.status = Download.State.WAITING;
        if (url != null) {
            LOG.info((Object)("inited HttpDownload on: " + url.toString() + "<br>and request=" + request + "<br>and title=" + title + "<br>and filename=" + filename + "<br>and extension=" + extension + "<br>with these headers:" + headers));
        }
        try {
            filename = URLDecoder.decode(filename, "utf8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.determineDestinationFile(filename, extension);
    }

    protected void downloadStream(InputStream src, OutputStream dest) throws IOException {
        boolean downloading = true;
        while (downloading) {
            if (Thread.interrupted()) {
                log.info((Object)"Download was interuppted");
                dest.close();
                src.close();
                this.deleteFile();
                return;
            }
            byte[] buffer = new byte[1024];
            int read = src.read(buffer);
            if (read == -1) {
                downloading = false;
                continue;
            }
            dest.write(buffer, 0, read);
        }
    }

    protected InputStream getUrlInputStreamWithWebAcessManager(URL url) throws URISyntaxException, FileNotFoundException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        InputStream resp = null;
        if ("file".equals(url.getProtocol())) {
            resp = new FileInputStream(new File(url.toURI()));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending request \n" + this.request + "\n to '" + url.toExternalForm() + "'."));
            }
            resp = this.request == null || this.request.trim().length() <= 0 ? WebAccessManager.getInstance().doRequest(url) : WebAccessManager.getInstance().doRequest(url, new StringReader(this.request), AccessHandler.ACCESS_METHODS.POST_REQUEST, this.headers);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadStream() {
        FileOutputStream out = null;
        InputStream resp = null;
        try {
            resp = this.getUrlInputStreamWithWebAcessManager(this.url);
            if (Thread.interrupted()) {
                log.info((Object)"Download was interuppted");
                this.deleteFile();
                return;
            }
            out = new FileOutputStream(this.fileToSaveTo);
            this.downloadStream(resp, out);
        }
        catch (MissingArgumentException ex) {
            this.error(ex);
        }
        catch (AccessMethodIsNotSupportedException ex) {
            this.error(ex);
        }
        catch (RequestFailedException ex) {
            this.error(ex);
        }
        catch (NoHandlerForURLException ex) {
            this.error(ex);
        }
        catch (Exception ex) {
            this.error(ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception occured while closing file.", (Throwable)e);
                }
            }
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception occured while closing response stream.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        this.downloadStream();
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    @Override
    public JPanel getExceptionPanel(Exception exception) {
        if (exception instanceof BadHttpStatusCodeException) {
            return new BadHttpStatusCodeExceptionPanel((BadHttpStatusCodeException)exception);
        }
        return super.getExceptionPanel(exception);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HttpDownload)) {
            return false;
        }
        HttpDownload other = (HttpDownload)obj;
        boolean result = true;
        if (!(this.url == other.url || this.url != null && this.url.equals(other.url))) {
            result &= false;
        }
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            result &= false;
        }
        if (this.fileToSaveTo == null ? other.fileToSaveTo != null : !this.fileToSaveTo.equals(other.fileToSaveTo)) {
            result &= false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 43 * hash + (this.request != null ? this.request.hashCode() : 0);
        hash = 43 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        return hash;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }
}

