/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.commons.security.AccessHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.security.exceptions.AccessMethodIsNotSupportedException;
import de.cismet.security.exceptions.NoHandlerForURLException;
import de.cismet.security.exceptions.RequestFailedException;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;

public class HttpOrFtpDownload
extends HttpDownload {
    public HttpOrFtpDownload() {
    }

    public HttpOrFtpDownload(URL url, String request, String directory, String title, String filename, String extension) {
        super(url, request, directory, title, filename, extension);
    }

    public HttpOrFtpDownload(URL url, String request, HashMap<String, String> headers, String directory, String title, String filename, String extension) {
        super(url, request, headers, directory, title, filename, extension);
    }

    @Override
    protected InputStream getUrlInputStreamWithWebAcessManager(URL url) throws URISyntaxException, FileNotFoundException, AccessMethodIsNotSupportedException, RequestFailedException, NoHandlerForURLException, Exception {
        InputStream inputStream = null;
        if ("ftp".equalsIgnoreCase(url.getProtocol())) {
            WebAccessManager.getInstance().registerAccessHandler(url, AccessHandler.ACCESS_HANDLER_TYPES.FTP);
        }
        try {
            inputStream = super.getUrlInputStreamWithWebAcessManager(url);
        }
        finally {
            if ("ftp".equalsIgnoreCase(url.getProtocol())) {
                WebAccessManager.getInstance().deregisterAccessHandler(url);
            }
        }
        return inputStream;
    }
}

