/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MultipleDownload
extends Observable
implements Download,
Observer {
    private static final Logger LOG = Logger.getLogger(MultipleDownload.class);
    private Collection<? extends Download> downloads;
    private String title;
    private Download.State status;
    private int downloadsCompleted;
    private int downloadsErroneous;
    private File fileToSaveTo;

    public MultipleDownload(Collection<? extends Download> downloads, String title) {
        this.downloads = downloads == null ? new ArrayList<Download>() : downloads;
        this.title = title;
        for (Download download : this.downloads) {
            if (download.getFileToSaveTo() == null) continue;
            if (this.fileToSaveTo == null) {
                this.fileToSaveTo = download.getFileToSaveTo().getParentFile();
                continue;
            }
            if (this.fileToSaveTo.equals(download.getFileToSaveTo().getParentFile())) continue;
            this.fileToSaveTo = null;
            break;
        }
        this.status = Download.State.WAITING;
    }

    @Override
    public void startDownload() {
    }

    @Override
    public Download.State getStatus() {
        return this.status;
    }

    public void setStatus(Download.State status) {
        this.status = status;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public int getDownloadsTotal() {
        return this.downloads.size();
    }

    @Override
    public int getDownloadsCompleted() {
        return this.downloadsCompleted;
    }

    @Override
    public int getDownloadsErroneous() {
        return this.downloadsErroneous;
    }

    @Override
    public File getFileToSaveTo() {
        return this.fileToSaveTo;
    }

    @Override
    public Exception getCaughtException() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JPanel getExceptionPanel(Exception exception) {
        return null;
    }

    public Collection<? extends Download> getDownloads() {
        return this.downloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof AbstractDownload)) {
            return;
        }
        AbstractDownload download = (AbstractDownload)o;
        MultipleDownload multipleDownload = this;
        synchronized (multipleDownload) {
            if (download.getStatus() == Download.State.RUNNING && this.status == Download.State.WAITING) {
                this.status = Download.State.RUNNING;
            } else if (download.getStatus() == Download.State.COMPLETED) {
                ++this.downloadsCompleted;
            } else if (download.getStatus() == Download.State.COMPLETED_WITH_ERROR) {
                ++this.downloadsCompleted;
                ++this.downloadsErroneous;
                this.status = Download.State.RUNNING_WITH_ERROR;
            } else if (download.getStatus() == Download.State.ABORTED) {
                ++this.downloadsCompleted;
            }
            if (this.downloadsCompleted == this.downloads.size()) {
                this.status = this.status == Download.State.RUNNING ? Download.State.COMPLETED : Download.State.COMPLETED_WITH_ERROR;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipleDownload other = (MultipleDownload)obj;
        if (this.downloads == null ? other.downloads != null : !this.downloads.containsAll(other.downloads)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.downloads != null ? this.downloads.hashCode() : 0);
        hash = 37 * hash + (this.title != null ? this.title.hashCode() : 0);
        return hash;
    }
}

