/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.downloadmanager;

import de.cismet.tools.gui.downloadmanager.BackgroundTaskMultipleDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.DownloadPanel;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MultipleDownloadPanel
extends JPanel
implements Observer {
    private static final Logger LOG = Logger.getLogger(MultipleDownloadPanel.class);
    private Map<Download, JPanel> downloadsInSingleDownloadsPanel = new HashMap<Download, JPanel>();
    private MultipleDownload download;
    private JPanel pnlSingleDownloads;
    private boolean isSingleDownloadsPanelShown;
    private JLabel lblIcon;
    private JLabel lblMessage;
    private JLabel lblTitle;
    private JMenuItem mniRemove;
    private JPopupMenu popContextMenu;
    private JProgressBar prbProgress;
    private JSeparator sepDownloadPanels;
    private JSeparator sepSingleDownloadsPanel;
    private JToggleButton tbtDownloads;

    public MultipleDownloadPanel(MultipleDownload download) {
        this.download = download;
        this.initComponents();
        this.updateComponents();
        this.initSingleDownloadsPanel();
    }

    private void initComponents() {
        this.sepSingleDownloadsPanel = new JSeparator();
        this.popContextMenu = new JPopupMenu();
        this.mniRemove = new JMenuItem();
        this.lblIcon = new JLabel();
        this.lblTitle = new JLabel();
        this.lblMessage = new JLabel();
        this.prbProgress = new JProgressBar();
        this.sepDownloadPanels = new JSeparator();
        this.tbtDownloads = new JToggleButton();
        this.mniRemove.setText(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.mniRemove.text"));
        this.mniRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleDownloadPanel.this.mniRemoveActionPerformed(evt);
            }
        });
        this.popContextMenu.add(this.mniRemove);
        this.setComponentPopupMenu(this.popContextMenu);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 54));
        this.setMinimumSize(new Dimension(193, 54));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MultipleDownloadPanel.this.formMouseClicked(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/documenttypes/multiple_closed.png")));
        this.lblIcon.setText(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.lblIcon.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblIcon, gridBagConstraints);
        this.lblTitle.setFont(new Font("Tahoma", 0, 14));
        this.lblTitle.setText(this.download.getTitle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblTitle, gridBagConstraints);
        this.lblMessage.setBackground(new Color(255, 102, 0));
        this.lblMessage.setText(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.lblMessage.text"));
        this.lblMessage.setMaximumSize(new Dimension(Short.MAX_VALUE, 15));
        this.lblMessage.setMinimumSize(new Dimension(10, 15));
        this.lblMessage.setPreferredSize(new Dimension(8, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblMessage, gridBagConstraints);
        this.prbProgress.setMaximum(this.download.getDownloadsTotal());
        this.prbProgress.setBorderPainted(false);
        this.prbProgress.setMaximumSize(new Dimension(Short.MAX_VALUE, 15));
        this.prbProgress.setMinimumSize(new Dimension(10, 15));
        this.prbProgress.setPreferredSize(new Dimension(146, 15));
        this.prbProgress.setString(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.prbProgress.string"));
        this.prbProgress.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.prbProgress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.sepDownloadPanels, gridBagConstraints);
        this.tbtDownloads.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/res/listDownloads.png")));
        this.tbtDownloads.setText(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.tbtDownloads.text"));
        this.tbtDownloads.setBorderPainted(false);
        this.tbtDownloads.setContentAreaFilled(false);
        this.tbtDownloads.setFocusPainted(false);
        this.tbtDownloads.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/res/listDownloads_selected.png")));
        this.tbtDownloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleDownloadPanel.this.tbtDownloadsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.tbtDownloads, gridBagConstraints);
    }

    private void tbtDownloadsActionPerformed(ActionEvent evt) {
        if (this.isSingleDownloadsPanelShown) {
            this.hideSingleDownloads();
        } else {
            this.showSingleDownloads();
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.download.getCaughtException() != null) {
                DownloadManagerDialog.getInstance().showTheExceptionDialog(this.download);
            } else if (this.download.getDownloadsTotal() > 0) {
                if (this.isSingleDownloadsPanelShown) {
                    this.hideSingleDownloads();
                } else {
                    this.showSingleDownloads();
                }
            }
        }
    }

    private void mniRemoveActionPerformed(ActionEvent evt) {
        DownloadManager.instance().removeDownload(this.download);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == null || !o.equals(this.download)) {
            return;
        }
        this.updateComponents();
        this.revalidate();
        this.repaint();
    }

    private void updateComponents() {
        switch (this.download.getStatus()) {
            case WAITING: {
                if (this.download instanceof BackgroundTaskMultipleDownload) {
                    this.lblMessage.setVisible(false);
                    this.prbProgress.setIndeterminate(true);
                    this.prbProgress.setString(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.prbProgress.string.waiting.BackgroundTaskMultipleDownload"));
                    this.prbProgress.setVisible(true);
                    break;
                }
                this.mniRemove.setEnabled(true);
                this.prbProgress.setVisible(false);
                this.lblMessage.setVisible(true);
                break;
            }
            case RUNNING: {
                this.lblMessage.setVisible(false);
                this.mniRemove.setEnabled(false);
                this.lblTitle.setForeground(SystemColor.textText);
                this.prbProgress.setVisible(true);
                this.prbProgress.setMaximum(this.download.getDownloadsTotal());
                if (this.download.getDownloadsCompleted() == 0) {
                    this.prbProgress.setIndeterminate(true);
                    this.prbProgress.setString(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.prbProgress.string.running.allRunning"));
                    break;
                }
                this.prbProgress.setIndeterminate(false);
                this.prbProgress.setString(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.prbProgress.string.running", (Object)this.download.getDownloadsCompleted(), (Object)this.download.getDownloadsTotal()));
                this.prbProgress.setValue(this.download.getDownloadsCompleted());
                break;
            }
            case RUNNING_WITH_ERROR: {
                this.lblMessage.setVisible(false);
                this.mniRemove.setEnabled(false);
                this.lblTitle.setForeground(SystemColor.textText);
                this.prbProgress.setVisible(true);
                this.prbProgress.setString(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.prbProgress.string.running_with_error", (Object)this.download.getDownloadsCompleted(), (Object)this.download.getDownloadsTotal(), (Object)this.download.getDownloadsErroneous()));
                this.prbProgress.setValue(this.download.getDownloadsCompleted());
                this.prbProgress.setBackground(Color.pink);
                this.setBackground(Color.pink);
                break;
            }
            case COMPLETED: {
                this.prbProgress.setVisible(false);
                this.mniRemove.setEnabled(true);
                this.lblTitle.setForeground(SystemColor.textInactiveText);
                this.download.deleteObserver(this);
                this.lblMessage.setVisible(true);
                this.lblMessage.setText(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.lblMessage.text.completed", (Object)this.download.getDownloadsCompleted()));
                break;
            }
            case COMPLETED_WITH_ERROR: {
                this.prbProgress.setVisible(false);
                this.mniRemove.setEnabled(true);
                this.lblTitle.setForeground(SystemColor.textInactiveText);
                this.setBackground(Color.pink);
                this.download.deleteObserver(this);
                this.lblMessage.setVisible(true);
                this.lblMessage.setText(NbBundle.getMessage(MultipleDownloadPanel.class, (String)"MultipleDownloadPanel.lblMessage.text.completed_with_error", (Object)this.download.getDownloadsCompleted(), (Object)this.download.getDownloadsErroneous()));
            }
        }
    }

    private void initSingleDownloadsPanel() {
        if (this.pnlSingleDownloads != null) {
            return;
        }
        this.pnlSingleDownloads = new JPanel();
        this.pnlSingleDownloads.setLayout(new BoxLayout(this.pnlSingleDownloads, 3));
        this.addDownloadsToPnlSingleDownloads(this.download.getDownloads());
    }

    private void showSingleDownloads() {
        if (this.isSingleDownloadsPanelShown) {
            return;
        }
        this.tbtDownloads.setSelected(true);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/documenttypes/fallback_multiple.png")));
        this.remove(this.sepDownloadPanels);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.sepDownloadPanels, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 3;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)this.pnlSingleDownloads, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.sepSingleDownloadsPanel, constraints);
        int width = this.getMaximumSize().width;
        int height = this.getMaximumSize().height;
        this.setMaximumSize(new Dimension(width, height + this.download.getDownloadsTotal() * 44));
        this.isSingleDownloadsPanelShown = true;
        this.revalidate();
        this.repaint();
    }

    private void hideSingleDownloads() {
        if (!this.isSingleDownloadsPanelShown) {
            return;
        }
        this.tbtDownloads.setSelected(false);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/downloadmanager/documenttypes/multiple_closed.png")));
        this.remove(this.sepDownloadPanels);
        this.remove(this.sepSingleDownloadsPanel);
        this.remove(this.pnlSingleDownloads);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.sepDownloadPanels, constraints);
        int width = this.getMaximumSize().width;
        this.setMaximumSize(new Dimension(width, 54));
        this.isSingleDownloadsPanelShown = false;
        this.revalidate();
        this.repaint();
    }

    public void redrawEncapsulatedDownloads() {
        this.addDownloadsToPnlSingleDownloads(this.download.getDownloads());
    }

    private void addDownloadsToPnlSingleDownloads(Collection<? extends Download> downloads) {
        Iterator<? extends Download> iterDownloads = downloads.iterator();
        Branch.Position position = null;
        int i = 0;
        while (iterDownloads.hasNext()) {
            Download singleDownload = iterDownloads.next();
            if (!this.downloadsInSingleDownloadsPanel.containsKey(singleDownload)) {
                DownloadPanel pnlSingleDownloadPanel = new DownloadPanel(singleDownload, true, !iterDownloads.hasNext());
                singleDownload.addObserver(pnlSingleDownloadPanel);
                position = i == this.download.getDownloads().size() - 1 ? Branch.Position.LAST : (i == 0 ? Branch.Position.FIRST : Branch.Position.NORMAL);
                Branch braBranch = new Branch(pnlSingleDownloadPanel, position);
                JPanel pnlSingleDownload = new JPanel();
                pnlSingleDownload.setLayout(new BoxLayout(pnlSingleDownload, 2));
                pnlSingleDownload.add(braBranch);
                pnlSingleDownload.add(pnlSingleDownloadPanel);
                this.downloadsInSingleDownloadsPanel.put(singleDownload, pnlSingleDownload);
                this.pnlSingleDownloads.add(pnlSingleDownload);
            }
            ++i;
        }
        this.tbtDownloads.setVisible(!downloads.isEmpty());
    }

    private static class Branch
    extends JComponent {
        private static final int INSET = 4;
        private Position position;
        private JComponent parent;

        public Branch(JComponent parent) {
            this(parent, Position.NORMAL);
        }

        public Branch(JComponent parent, Position position) {
            this.parent = parent;
            this.position = position;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.parent.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(SystemColor.textInactiveText);
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, 1.0f}, 0.0f));
            Path2D.Float shape = new Path2D.Float();
            if (this.position == Position.FIRST) {
                ((Path2D)shape).moveTo(this.getWidth() / 2, 4.0);
            } else {
                ((Path2D)shape).moveTo(this.getWidth() / 2, 0.0);
            }
            if (this.position == Position.LAST) {
                ((Path2D)shape).lineTo(this.getWidth() / 2, this.getHeight() / 2);
            } else {
                ((Path2D)shape).lineTo(this.getWidth() / 2, this.getHeight());
            }
            ((Path2D)shape).moveTo(this.getWidth() / 2, this.getHeight() / 2);
            ((Path2D)shape).lineTo(this.getWidth() - 4, this.getHeight() / 2);
            g2d.draw(shape);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(42, 44);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(42, 44);
        }

        static enum Position {
            FIRST,
            NORMAL,
            LAST;

        }
    }
}

