/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.exceptionnotification;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.exceptionnotification.DefaultExceptionHandlerListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ExceptionNotificationStatusPanel
extends JPanel
implements DefaultExceptionHandlerListener {
    private static final Logger LOG = Logger.getLogger(ExceptionNotificationStatusPanel.class);
    private static int FLASH_TIME;
    private static int FLASH_PAUSE;
    private static int STEADY_TIME;
    private Throwable uncaughtException;
    private final Timer flashTimer;
    private final Timer steadyTimer;
    private JXHyperlink hlErrorIcon;
    private JPanel pnlDisabled;
    private JPanel pnlIcon;

    public ExceptionNotificationStatusPanel() {
        this.initComponents();
        this.setVisible(false);
        int repetitions = (int)Math.floor((double)FLASH_TIME * 1000.0 / (double)FLASH_PAUSE);
        this.flashTimer = new Timer(FLASH_PAUSE, new FlashHandler(repetitions));
        this.flashTimer.setRepeats(true);
        this.flashTimer.setInitialDelay(0);
        this.steadyTimer = new Timer(STEADY_TIME * 1000, new SteadyHandler());
        this.steadyTimer.setRepeats(false);
    }

    private void initComponents() {
        this.pnlDisabled = new JPanel();
        this.pnlIcon = new JPanel();
        this.hlErrorIcon = new JXHyperlink();
        this.setLayout(new CardLayout());
        this.pnlDisabled.setLayout(new GridLayout(1, 0));
        this.add((Component)this.pnlDisabled, "DISABLED");
        this.pnlIcon.setCursor(new Cursor(12));
        this.pnlIcon.setMaximumSize(new Dimension(17, 16));
        this.pnlIcon.setMinimumSize(new Dimension(17, 16));
        this.pnlIcon.setPreferredSize(new Dimension(17, 16));
        this.pnlIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExceptionNotificationStatusPanel.this.pnlIconMouseClicked(evt);
            }
        });
        this.pnlIcon.setLayout(new GridLayout(1, 0));
        this.hlErrorIcon.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/exceptionnotification/exclamation.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.hlErrorIcon, (String)NbBundle.getMessage(ExceptionNotificationStatusPanel.class, (String)"ExceptionNotificationStatusPanel.hlErrorIcon.text"));
        this.hlErrorIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionNotificationStatusPanel.this.hlErrorIconActionPerformed(evt);
            }
        });
        this.pnlIcon.add((Component)this.hlErrorIcon);
        this.add((Component)this.pnlIcon, "ICON");
        this.pnlIcon.addMouseListener(new MouseAdapter(){});
        this.pnlIcon.addMouseMotionListener(new MouseMotionAdapter(){});
    }

    private void hlErrorIconActionPerformed(ActionEvent evt) {
        this.showErrorPanel();
    }

    private void pnlIconMouseClicked(MouseEvent evt) {
        this.showErrorPanel();
    }

    private void showErrorPanel() {
        Throwable shownException = this.uncaughtException;
        String basicMessage = NbBundle.getMessage(ExceptionNotificationStatusPanel.class, (String)"ExceptionNotificationStatusPanel.hlErrorIconActionPerformed().error.basicMessage");
        ErrorInfo ei = new ErrorInfo(NbBundle.getMessage(ExceptionNotificationStatusPanel.class, (String)"ExceptionNotificationStatusPanel.hlErrorIconActionPerformed().error.title"), basicMessage, null, null, this.uncaughtException, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrameIfNotNull(this), (ErrorInfo)ei);
        if (shownException == this.uncaughtException) {
            this.flashTimer.stop();
            this.steadyTimer.stop();
            this.letIconFlashOrShowAnEmptyPanel(null);
            this.setVisible(false);
        }
    }

    private void letIconFlashOrShowAnEmptyPanel(Boolean card) {
        String cardStr = "DISABLED";
        if (card != null) {
            cardStr = "ICON";
            this.hlErrorIcon.setVisible(card.booleanValue());
        }
        ((CardLayout)this.getLayout()).show(this, cardStr);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable error) {
        this.uncaughtException = error;
        this.setVisible(true);
        this.flashTimer.restart();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(50, 50);
        ExceptionNotificationStatusPanel panel = new ExceptionNotificationStatusPanel();
        frame.add(panel);
        frame.setVisible(true);
        panel.uncaughtException(null, new NullPointerException("Some error message."));
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(ExceptionNotificationStatusPanel.class.getResourceAsStream("exceptionNotificationStatusPanel.properties"));
            FLASH_TIME = Math.abs(Integer.parseInt(prop.getProperty("flashTime")));
            FLASH_PAUSE = Math.abs(Integer.parseInt(prop.getProperty("flashPause")));
            STEADY_TIME = Math.abs(Integer.parseInt(prop.getProperty("steadyTime")));
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not load the properties for the ExceptionNotificationStatusPanel", (Throwable)ex);
            FLASH_TIME = 5;
            FLASH_PAUSE = 500;
            STEADY_TIME = 30;
        }
    }

    public class SteadyHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            ExceptionNotificationStatusPanel.this.letIconFlashOrShowAnEmptyPanel(null);
            ExceptionNotificationStatusPanel.this.setVisible(false);
        }
    }

    public class FlashHandler
    implements ActionListener {
        private int counter;
        private final int repetitions;

        public FlashHandler(int repetitions) {
            this.repetitions = repetitions;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ExceptionNotificationStatusPanel.this.flashTimer.isRunning()) {
                ExceptionNotificationStatusPanel.this.letIconFlashOrShowAnEmptyPanel(this.counter % 2 == 0);
                ++this.counter;
                if (this.counter >= this.repetitions) {
                    this.counter = 0;
                    ExceptionNotificationStatusPanel.this.letIconFlashOrShowAnEmptyPanel(true);
                    ((Timer)ae.getSource()).stop();
                    ExceptionNotificationStatusPanel.this.steadyTimer.restart();
                }
            }
        }
    }
}

