/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.historybutton;

import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import java.util.Stack;
import java.util.Vector;

public class DefaultHistoryModel
implements HistoryModel {
    Vector modelListeners = new Vector();
    Stack backHistory = new Stack();
    Stack forwardHistory = new Stack();
    Object currentElement = null;
    int maximumPossibilities = -1;

    @Override
    public void addToHistory(Object o) {
        boolean tmpFw = this.isForwardPossible();
        if (o != null) {
            if (this.currentElement != null) {
                if (this.currentElement.equals(o)) {
                    return;
                }
                this.backHistory.push(this.currentElement);
            }
            this.currentElement = o;
            if (tmpFw != this.isForwardPossible()) {
                this.fireForwardStatusChanged();
            }
            this.forwardHistory.removeAllElements();
            this.fireBackStatusChanged();
            this.fireHistoryChanged();
            this.fireForwardStatusChanged();
        }
    }

    @Override
    public void setMaximumPossibilities(int max) {
        this.maximumPossibilities = max;
    }

    @Override
    public boolean isForwardPossible() {
        return !this.forwardHistory.empty();
    }

    @Override
    public boolean isBackPossible() {
        return !this.backHistory.empty();
    }

    @Override
    public Vector getForwardPossibilities() {
        return this.forwardHistory;
    }

    @Override
    public Vector getBackPossibilities() {
        return this.backHistory;
    }

    @Override
    public Object forward(boolean external) {
        if (this.isForwardPossible()) {
            this.backHistory.push(this.currentElement);
            this.currentElement = this.forwardHistory.pop();
            this.fireForwardStatusChanged();
            this.fireBackStatusChanged();
            if (external) {
                this.fireHistoryChanged();
            }
            return this.currentElement;
        }
        return null;
    }

    @Override
    public Object back(boolean external) {
        if (this.isBackPossible()) {
            this.forwardHistory.push(this.currentElement);
            this.currentElement = this.backHistory.pop();
            this.fireBackStatusChanged();
            this.fireForwardStatusChanged();
            if (external) {
                this.fireHistoryChanged();
            }
            return this.currentElement;
        }
        return null;
    }

    @Override
    public Object getCurrentElement() {
        return this.currentElement;
    }

    @Override
    public void addHistoryModelListener(HistoryModelListener hml) {
        this.modelListeners.add(hml);
        hml.historyChanged();
    }

    @Override
    public void removeHistoryModelListener(HistoryModelListener hml) {
        this.modelListeners.remove(hml);
    }

    private void fireForwardStatusChanged() {
        for (Object o : this.modelListeners) {
            if (!(o instanceof HistoryModelListener)) continue;
            ((HistoryModelListener)o).forwardStatusChanged();
        }
    }

    private void fireBackStatusChanged() {
        for (Object o : this.modelListeners) {
            if (!(o instanceof HistoryModelListener)) continue;
            ((HistoryModelListener)o).backStatusChanged();
        }
    }

    private void fireHistoryChanged() {
        for (Object o : this.modelListeners) {
            if (!(o instanceof HistoryModelListener)) continue;
            ((HistoryModelListener)o).historyChanged();
        }
    }

    private void fireHistoryActionPerformed() {
    }
}

