/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jbands;

import de.cismet.tools.gui.jbands.BandModelEvent;
import de.cismet.tools.gui.jbands.DefaultBand;
import de.cismet.tools.gui.jbands.EmptyAbsoluteHeightedBand;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.MinimumHeightBand;
import de.cismet.tools.gui.jbands.SimpleBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.SimpleModifiableBand;
import de.cismet.tools.gui.jbands.SimpleModifiableBandMember;
import de.cismet.tools.gui.jbands.SimpleSection;
import de.cismet.tools.gui.jbands.SimpleSpot;
import de.cismet.tools.gui.jbands.SimpleTextSection;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandAbsoluteHeightProvider;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberActionProvider;
import de.cismet.tools.gui.jbands.interfaces.BandMemberMouseListeningComponent;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import de.cismet.tools.gui.jbands.interfaces.BandModelListener;
import de.cismet.tools.gui.jbands.interfaces.BandModificationProvider;
import de.cismet.tools.gui.jbands.interfaces.BandPostfixProvider;
import de.cismet.tools.gui.jbands.interfaces.BandPrefixProvider;
import de.cismet.tools.gui.jbands.interfaces.BandSnappingPointProvider;
import de.cismet.tools.gui.jbands.interfaces.BandWeightProvider;
import de.cismet.tools.gui.jbands.interfaces.DisposableBand;
import de.cismet.tools.gui.jbands.interfaces.Section;
import de.cismet.tools.gui.jbands.interfaces.Spot;
import de.cismet.tools.gui.jbands.interfaces.StationaryBandMemberMouseListeningComponent;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class JBand
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
BandModelListener,
KeyListener {
    public static final Dimension MINDIM = new Dimension(0, 0);
    HashMap<JComponent, BandMember> bandMembersViaComponents = new HashMap();
    HashMap<BandMember, JComponent> componentsViaBandMembers = new HashMap();
    JBandsPanel bandsPanel = new JBandsPanel();
    JLegendPanel legendPanel = new JLegendPanel();
    JLegendPanel postfixPanel = new JLegendPanel();
    ArrayList<ActionListener> actionListeners = new ArrayList();
    List<BandMemberSelectable> selectedBandMember = new ArrayList<BandMemberSelectable>();
    int count = 0;
    private int maxPreferredPrefixWidth = 0;
    private int maxPreferredPostfixWidth = 0;
    private final transient Logger log = Logger.getLogger(this.getClass());
    private BandModel model;
    private double zoomFactor = 1.0;
    private JScrollPane scrollPane = new JScrollPane(this.bandsPanel);
    private float[] heightWeights;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    private double additionalZoomFactor = 1.0;
    private float heightsWeightSum = 0.0f;
    private double realWidth = 0.0;
    private List<JBandYDimension> bandPosY = new ArrayList<JBandYDimension>();
    private Map<Band, ArrayList<ArrayList<BandMember>>> subBandMap = new HashMap<Band, ArrayList<ArrayList<BandMember>>>();
    private List<SnappingPoint> snappingPoints = new ArrayList<SnappingPoint>();
    private boolean readOnly = false;
    private boolean refreshAvoided = false;
    private Component lastPressedComponent = null;
    private boolean dragged = false;
    private SelectionMode selectionMode = SelectionMode.SINGLE_SELECTION;
    private boolean hideEmptyPrePostfix = false;

    public JBand() {
        this(false);
    }

    public JBand(boolean readOnly) {
        this.readOnly = readOnly;
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.setOpaque(false);
        this.bandsPanel.setOpaque(false);
        this.bandsPanel.addMouseMotionListener(this);
        this.bandsPanel.addMouseListener(this);
        this.setFocusable(true);
        this.bandsPanel.setFocusable(true);
        this.legendPanel.setFocusable(true);
        this.postfixPanel.setFocusable(true);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setHorizontalScrollBarPolicy(32);
    }

    public JBand(BandModel model) {
        this();
        this.setModel(model);
    }

    public boolean isHideEmptyPrePostfix() {
        return this.hideEmptyPrePostfix;
    }

    public void setHideEmptyPrePostfix(boolean hideEmptyPrePostfix) {
        this.hideEmptyPrePostfix = hideEmptyPrePostfix;
        if (this.model != null) {
            this.init();
        }
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if ((e.getModifiers() & 0x80) != 0 && e.getKeyChar() == 'a') {
            for (int bandIndex = 0; bandIndex < this.model.getNumberOfBands(); ++bandIndex) {
                Band b = this.model.getBand(bandIndex);
                for (int memberIndex = 0; memberIndex < b.getNumberOfMembers(); ++memberIndex) {
                    BandMemberSelectable bms;
                    BandMember member = b.getMember(memberIndex);
                    if (!(member instanceof BandMemberSelectable) || this.selectedBandMember.contains(bms = (BandMemberSelectable)((Object)member))) continue;
                    bms.setSelected(true);
                    this.selectedBandMember.add(bms);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public BandMember getSelectedBandMember() {
        if (this.selectedBandMember.size() > 0) {
            return this.selectedBandMember.get(0).getBandMember();
        }
        return null;
    }

    public List<BandMemberSelectable> getSelectedBandMemberList() {
        return this.selectedBandMember;
    }

    public void setHorizontalScrollBarPolicy(int horizontalScrollBarPolicy) {
        this.scrollPane.setHorizontalScrollBarPolicy(horizontalScrollBarPolicy);
    }

    public void setModel(BandModel model) {
        if (this.model != null) {
            this.model.removeBandModelListener(this);
        }
        this.model = model;
        model.addBandModelListener(this);
        this.init();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private void init() {
        double prefWidth = this.legendPanel.getPreferredSize().getWidth();
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        this.bandsPanel.removeAll();
        this.legendPanel.removeAll();
        for (int row = 0; row < this.model.getNumberOfBands(); ++row) {
            int cols = this.model.getBand(row).getNumberOfMembers();
            Band rowBand = this.model.getBand(row);
            JComponent prefix = null;
            if (rowBand instanceof BandPrefixProvider) {
                prefix = ((BandPrefixProvider)((Object)rowBand)).getPrefixComponent();
                this.legendPanel.add(prefix);
                this.maxPreferredPrefixWidth = this.maxPreferredPrefixWidth < prefix.getPreferredSize().width ? prefix.getPreferredSize().width : this.maxPreferredPrefixWidth;
            }
            for (int col = 0; col < cols; ++col) {
                BandMember member = rowBand.getMember(col);
                JComponent comp = member.getBandMemberComponent();
                if (member instanceof BandMemberActionProvider) {
                    ((BandMemberActionProvider)((Object)member)).addActionListener(this);
                }
                this.bandsPanel.add(comp);
                this.bandMembersViaComponents.put(comp, member);
                this.componentsViaBandMembers.put(member, comp);
                if (!Arrays.asList(comp.getMouseListeners()).contains(this)) {
                    comp.addMouseListener(this);
                }
                if (Arrays.asList(comp.getMouseMotionListeners()).contains(this)) continue;
                comp.addMouseMotionListener(this);
            }
            if (!(rowBand instanceof BandPostfixProvider)) continue;
            JComponent postfix = ((BandPostfixProvider)((Object)rowBand)).getPostfixComponent();
            this.postfixPanel.add(postfix);
            int pWidth = postfix.getPreferredSize().width;
            if (this.maxPreferredPostfixWidth >= pWidth) continue;
            this.maxPreferredPostfixWidth = pWidth;
        }
        this.heightWeights = new float[this.model.getNumberOfBands()];
        for (int zeile = 0; zeile < this.model.getNumberOfBands(); ++zeile) {
            Band b = this.model.getBand(zeile);
            this.heightWeights[zeile] = b instanceof BandWeightProvider ? ((BandWeightProvider)((Object)b)).getBandWeight() : (b instanceof BandAbsoluteHeightProvider ? 0.0f : 1.0f);
            if (b.getMax() > this.getMaxValue()) {
                this.setMaxValue(b.getMax());
            }
            if (!(b.getMin() < this.getMinValue())) continue;
            this.setMinValue(b.getMin());
        }
        if (this.isHideEmptyPrePostfix()) {
            if (!Arrays.asList(this.getComponents()).contains(this.legendPanel) && this.legendPanel.getComponentCount() > 0) {
                this.add((Component)this.legendPanel, "Before");
            } else if (Arrays.asList(this.getComponents()).contains(this.legendPanel) && this.legendPanel.getComponentCount() == 0) {
                this.remove(this.legendPanel);
            }
            if (!Arrays.asList(this.getComponents()).contains(this.postfixPanel) && this.postfixPanel.getComponentCount() > 0) {
                this.add((Component)this.postfixPanel, "After");
            } else if (Arrays.asList(this.getComponents()).contains(this.postfixPanel) && this.postfixPanel.getComponentCount() == 0) {
                this.remove(this.postfixPanel);
            }
        } else {
            if (!Arrays.asList(this.getComponents()).contains(this.legendPanel)) {
                this.add((Component)this.legendPanel, "Before");
            }
            if (!Arrays.asList(this.getComponents()).contains(this.postfixPanel)) {
                this.add((Component)this.postfixPanel, "After");
            }
        }
        this.realWidth = this.getMaxValue() - this.getMinValue();
        this.layoutBandMemberComponents();
        if (this.legendPanel.getPreferredSize().getWidth() != prefWidth) {
            this.updateUI();
        }
    }

    private void layoutBandMemberComponents() {
        int zeile;
        this.heightsWeightSum = 0.0f;
        this.bandPosY.clear();
        this.snappingPoints.clear();
        if (this.model == null || this.model.getNumberOfBands() == 0 || this.bandsPanel.getWidth() <= 0) {
            return;
        }
        int remainingBandsPanelHeight = this.bandsPanel.getHeight();
        for (int zeile2 = 0; zeile2 < this.model.getNumberOfBands(); ++zeile2) {
            Band rowBand = this.model.getBand(zeile2);
            if (!rowBand.isEnabled()) continue;
            this.heightsWeightSum += this.heightWeights[zeile2];
            if (rowBand instanceof BandAbsoluteHeightProvider) {
                remainingBandsPanelHeight -= ((BandAbsoluteHeightProvider)((Object)rowBand)).getAbsoluteHeight();
            }
            if (rowBand instanceof BandSnappingPointProvider) {
                for (int i = 0; i < rowBand.getNumberOfMembers(); ++i) {
                    BandMember m = rowBand.getMember(i);
                    this.snappingPoints.add(new SnappingPoint(m.getMin(), m.getBandMemberComponent()));
                    this.snappingPoints.add(new SnappingPoint(m.getMax(), m.getBandMemberComponent()));
                }
            }
            if (remainingBandsPanelHeight >= 0) continue;
        }
        int posy = 0;
        for (zeile = 0; zeile < this.model.getNumberOfBands(); ++zeile) {
            int memberHeight;
            Band rowBand = this.model.getBand(zeile);
            if (!rowBand.isEnabled()) {
                memberHeight = 0;
            } else if (this.heightWeights[zeile] == 0.0f && rowBand instanceof BandAbsoluteHeightProvider) {
                int subCount;
                memberHeight = ((BandAbsoluteHeightProvider)((Object)rowBand)).getAbsoluteHeight();
                if (memberHeight < (subCount = this.getSubbandCount(rowBand))) {
                    memberHeight = subCount;
                }
            } else {
                memberHeight = (int)((double)remainingBandsPanelHeight * (double)this.heightWeights[zeile] / (double)this.heightsWeightSum);
                int subCount = this.getSubbandCount(rowBand);
                if (memberHeight < subCount) {
                    memberHeight = subCount;
                }
            }
            if (rowBand instanceof BandPrefixProvider) {
                JComponent prefix = ((BandPrefixProvider)((Object)rowBand)).getPrefixComponent();
                prefix.setBounds(0, posy, this.maxPreferredPrefixWidth, memberHeight);
            }
            if (memberHeight > 0) {
                this.bandPosY.add(new JBandYDimension(rowBand, posy, posy + memberHeight - 1));
            }
            posy += memberHeight;
        }
        posy = 0;
        for (zeile = 0; zeile < this.model.getNumberOfBands(); ++zeile) {
            int i;
            int subCount;
            int memberHeight;
            Band rowBand = this.model.getBand(zeile);
            if (!rowBand.isEnabled()) {
                memberHeight = 0;
                for (int i2 = 0; i2 < rowBand.getNumberOfMembers(); ++i2) {
                    rowBand.getMember(i2).getBandMemberComponent().setBounds(new Rectangle(0, 0, 0, 0));
                }
                continue;
            }
            if (this.heightWeights[zeile] == 0.0f && rowBand instanceof BandAbsoluteHeightProvider) {
                memberHeight = ((BandAbsoluteHeightProvider)((Object)rowBand)).getAbsoluteHeight();
                if (memberHeight < (subCount = this.getSubbandCount(rowBand))) {
                    memberHeight = subCount;
                }
            } else {
                memberHeight = (int)((double)remainingBandsPanelHeight * (double)this.heightWeights[zeile] / (double)this.heightsWeightSum);
                subCount = this.getSubbandCount(rowBand);
                if (memberHeight < subCount) {
                    memberHeight = subCount;
                }
            }
            ArrayList subBands = new ArrayList();
            ArrayList<BandMember> masterBand = new ArrayList<BandMember>();
            for (i = 0; i < rowBand.getNumberOfMembers(); ++i) {
                masterBand.add(rowBand.getMember(i));
            }
            for (i = 0; i < rowBand.getNumberOfMembers(); ++i) {
                for (int j = i; j < rowBand.getNumberOfMembers(); ++j) {
                    BandMember bi = rowBand.getMember(i);
                    BandMember bandMember = rowBand.getMember(j);
                    if (i == j || !masterBand.contains(bi) || !masterBand.contains(bandMember) || !this.isColliding(bi, bandMember)) continue;
                    masterBand.remove(bandMember);
                    boolean added = false;
                    for (ArrayList arrayList : subBands) {
                        if (this.hasCollisions(arrayList, bandMember)) continue;
                        arrayList.add(bandMember);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    ArrayList<BandMember> newSubBand = new ArrayList<BandMember>();
                    newSubBand.add(bandMember);
                    subBands.add(newSubBand);
                }
            }
            double roundingDifference = 0.0;
            if (subBands.size() > 0) {
                roundingDifference = (double)memberHeight / (1.0 + (double)subBands.size());
                roundingDifference -= (double)(memberHeight /= 1 + subBands.size());
            }
            for (BandMember bandMember : masterBand) {
                bandMember.getBandMemberComponent().setBounds(this.getBoundsOfComponent(bandMember, memberHeight, posy));
            }
            posy += memberHeight;
            for (ArrayList arrayList : subBands) {
                for (BandMember bm : arrayList) {
                    bm.getBandMemberComponent().setBounds(this.getBoundsOfComponent(bm, memberHeight, posy));
                }
                posy += memberHeight;
            }
            posy = (int)((double)posy + roundingDifference * (double)(1 + subBands.size()));
            subBands.add(masterBand);
            this.subBandMap.put(rowBand, subBands);
        }
        posy = 0;
        for (int row = 0; row < this.model.getNumberOfBands(); ++row) {
            int memberHeight;
            Band rowBand = this.model.getBand(row);
            if (!rowBand.isEnabled()) {
                memberHeight = 0;
            } else if (this.heightWeights[row] == 0.0f && rowBand instanceof BandAbsoluteHeightProvider) {
                int subCount;
                memberHeight = ((BandAbsoluteHeightProvider)((Object)rowBand)).getAbsoluteHeight();
                if (memberHeight < (subCount = this.getSubbandCount(rowBand))) {
                    memberHeight = subCount;
                }
            } else {
                memberHeight = (int)((double)remainingBandsPanelHeight * (double)this.heightWeights[row] / (double)this.heightsWeightSum);
                int subCount = this.getSubbandCount(rowBand);
                if (memberHeight < subCount) {
                    memberHeight = subCount;
                }
            }
            if (rowBand instanceof BandPostfixProvider) {
                JComponent prefix = ((BandPostfixProvider)((Object)rowBand)).getPostfixComponent();
                prefix.setBounds(0, posy, this.maxPreferredPostfixWidth, memberHeight);
            }
            if (memberHeight > 0) {
                this.bandPosY.add(new JBandYDimension(rowBand, posy, posy + memberHeight - 1));
            }
            posy += memberHeight;
        }
    }

    private boolean hasCollisions(ArrayList<BandMember> members, BandMember candidate) {
        for (BandMember bm : members) {
            if (!this.isColliding(bm, candidate)) continue;
            return true;
        }
        return false;
    }

    private int getSubbandCount(Band band) {
        int i;
        ArrayList subBands = new ArrayList();
        ArrayList<BandMember> masterBand = new ArrayList<BandMember>();
        for (i = 0; i < band.getNumberOfMembers(); ++i) {
            masterBand.add(band.getMember(i));
        }
        for (i = 0; i < band.getNumberOfMembers(); ++i) {
            for (int j = i; j < band.getNumberOfMembers(); ++j) {
                BandMember bi = band.getMember(i);
                BandMember bj = band.getMember(j);
                if (i == j || !masterBand.contains(bi) || !masterBand.contains(bj) || !this.isColliding(bi, bj)) continue;
                masterBand.remove(bj);
                boolean added = false;
                for (ArrayList arrayList : subBands) {
                    if (this.hasCollisions(arrayList, bj)) continue;
                    arrayList.add(bj);
                    added = true;
                    break;
                }
                if (added) continue;
                ArrayList<BandMember> newSubBand = new ArrayList<BandMember>();
                newSubBand.add(bj);
                subBands.add(newSubBand);
            }
        }
        return subBands.size() + 1;
    }

    private boolean isColliding(BandMember a, BandMember b) {
        if (a instanceof Section && b instanceof Section) {
            return !(a.getMax() <= b.getMin()) && !(a.getMin() >= b.getMax());
        }
        if (a instanceof Spot || b instanceof Spot) {
            int memberHeight = 10;
            int posy = 10;
            Rectangle ri = this.getBoundsOfComponent(a, 10, 10);
            Rectangle rj = this.getBoundsOfComponent(b, 10, 10);
            int rimax = ri.x + ri.width;
            int rimin = ri.x;
            int rjmax = rj.x + rj.width;
            int rjmin = rj.x;
            return rimax > rjmin && rimin < rjmax;
        }
        throw new IllegalArgumentException("Possible Combinations are Section,Section and Spot,Spot");
    }

    private Rectangle getBoundsOfComponent(BandMember member, int memberHeight, int posy) {
        JComponent comp = member.getBandMemberComponent();
        double widthFactor = (double)this.bandsPanel.getWidth() / this.realWidth;
        if (member instanceof Section) {
            int posx = (int)((member.getMin() - this.minValue) * widthFactor + 0.5);
            int lastPosX = (int)((member.getMax() - this.minValue) * widthFactor + 0.5);
            int memberWidth = Math.max(lastPosX - posx, 1);
            return new Rectangle(posx, posy, memberWidth, memberHeight);
        }
        if (member instanceof Spot) {
            int memberWidth = comp.getPreferredSize().width;
            int posx = (int)((member.getMin() - this.minValue) * widthFactor + 0.5 - (double)memberWidth / 2.0);
            return new Rectangle(posx, posy, memberWidth, memberHeight);
        }
        return null;
    }

    public double getZoomFactor() {
        return this.zoomFactor / this.additionalZoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        double myZoomFactor = (zoomFactor *= this.additionalZoomFactor) / this.zoomFactor;
        this.zoomFactor = zoomFactor;
        this.setRefreshAvoided(true);
        RepaintManager rm = RepaintManager.currentManager(this.bandsPanel);
        rm.markCompletelyClean(this.bandsPanel);
        this.scrollPane.getViewport().revalidate();
        if (!this.selectedBandMember.isEmpty()) {
            double relTargetPosition = (this.selectedBandMember.get(0).getBandMember().getMin() - this.minValue) / (this.maxValue - this.minValue);
            double newJBandWidth = (double)this.scrollPane.getWidth() * 0.9 * zoomFactor;
            double absTargetPosition = newJBandWidth / myZoomFactor * relTargetPosition;
            double currentXOffset = this.scrollPane.getViewport().getViewPosition().getX();
            double currentAbsTargetViewPosition = absTargetPosition - currentXOffset;
            double newOffset = (currentAbsTargetViewPosition + currentXOffset) * myZoomFactor - currentAbsTargetViewPosition;
            Rectangle r = this.scrollPane.getViewportBorderBounds();
            Point newPosition = new Point((int)newOffset, (int)r.getY());
            this.scrollPane.getViewport().setViewPosition(newPosition);
        }
        this.setRefreshAvoided(false);
        this.scrollPane.getViewport().revalidate();
    }

    public void fireActionPerformed() {
        ActionEvent e = new ActionEvent(this, 1, "selectionChanged");
        this.log.info((Object)"BandMemberAction Performed");
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.readOnly && e.getClickCount() == 2) {
            if (e.getComponent() == this.bandsPanel) {
                int y = e.getY();
                int startY = 0;
                int bandHeight = 0;
                Band targetBand = null;
                for (JBandYDimension tmp : this.bandPosY) {
                    if (y < tmp.getyMin() || y > tmp.getyMax()) continue;
                    targetBand = tmp.getBand();
                    startY = tmp.getyMin();
                    bandHeight = tmp.getyMax() - tmp.getyMin();
                    break;
                }
                if (targetBand != null && targetBand instanceof BandModificationProvider) {
                    double station = this.getSationForXValue(e.getX());
                    ArrayList<ArrayList<BandMember>> subBands = this.subBandMap.get(targetBand);
                    int n = (y - startY) / (bandHeight / subBands.size());
                    if (--n == -1) {
                        n = subBands.size() - 1;
                    }
                    ((BandModificationProvider)((Object)targetBand)).addMember(station, null, this.getMinValue(), this.getMaxValue(), (List<BandMember>)subBands.get(n));
                }
            }
        } else if (e.getComponent() instanceof BandMemberSelectable) {
            BandMemberSelectable selecteable = (BandMemberSelectable)((Object)e.getComponent());
            JBandCursorManager.getInstance().setCursor(this);
            if (e.getClickCount() == 1 && !e.isPopupTrigger()) {
                if (this.selectionMode == SelectionMode.MULTIPLE_INTERVAL_SELECTION && !e.isShiftDown() && !e.isControlDown() && this.selectedBandMember.size() > 1) {
                    this.deselectAllBandMember();
                }
                if (selecteable.isSelectable() && !selecteable.isSelected() && !this.selectedBandMember.contains(selecteable)) {
                    if (!(this.selectedBandMember.isEmpty() || this.selectionMode == SelectionMode.MULTIPLE_INTERVAL_SELECTION && (e.isShiftDown() || e.isControlDown()))) {
                        this.deselectAllBandMember();
                    }
                    selecteable.setSelected(true);
                    if (this.selectionMode == SelectionMode.MULTIPLE_INTERVAL_SELECTION && e.isShiftDown() && !this.selectedBandMember.isEmpty()) {
                        Band targetBand = this.getBandForYCoordinate(e.getY());
                        BandMember bm = this.selectedBandMember.get(this.selectedBandMember.size() - 1).getBandMember();
                        double min = Math.min(bm.getMin(), selecteable.getBandMember().getMin());
                        double max = Math.max(bm.getMax(), selecteable.getBandMember().getMax());
                        List<BandMember> members = this.getAllBandMembersBetween(targetBand, min, max);
                        this.selectedBandMember.add(selecteable);
                        Collections.sort(members, new BandMemberComparator());
                        for (BandMember member : members) {
                            BandMemberSelectable bms;
                            if (!(member instanceof BandMemberSelectable) || this.selectedBandMember.contains(bms = (BandMemberSelectable)((Object)member))) continue;
                            bms.setSelected(true);
                            this.selectedBandMember.add(bms);
                        }
                        this.repaint();
                    } else {
                        this.selectedBandMember.add(selecteable);
                    }
                } else {
                    if (!(this.selectedBandMember.isEmpty() || this.selectionMode == SelectionMode.MULTIPLE_INTERVAL_SELECTION && (e.isShiftDown() || e.isControlDown()))) {
                        this.deselectAllBandMember();
                    }
                    if (selecteable.isSelected()) {
                        selecteable.setSelected(false);
                    }
                    this.selectedBandMember.remove(selecteable);
                    this.repaint();
                }
                if (this.model instanceof SimpleBandModel) {
                    SimpleBandModel sbm = (SimpleBandModel)this.model;
                    BandModelEvent event = new BandModelEvent();
                    event.setSelectionLost(!e.isShiftDown() && !e.isControlDown());
                    sbm.fireBandModelSelectionChanged(event);
                }
            }
        }
        if (e.getComponent() instanceof BandMemberMouseListeningComponent) {
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mouseClicked(e);
        }
    }

    private void deselectAllBandMember() {
        for (BandMemberSelectable tmp : this.selectedBandMember) {
            tmp.setSelected(false);
        }
        this.selectedBandMember.clear();
        this.repaint();
    }

    private Band getBandForYCoordinate(int y) {
        Band targetBand = null;
        for (JBandYDimension tmp : this.bandPosY) {
            if (y < tmp.getyMin() || y > tmp.getyMax()) continue;
            targetBand = tmp.getBand();
            break;
        }
        return targetBand;
    }

    private List<BandMember> getAllBandMembersBetween(Band band, double startX, double endX) {
        ArrayList<BandMember> bandMembers = new ArrayList<BandMember>();
        for (int i = 0; i < band.getNumberOfMembers(); ++i) {
            BandMember member = band.getMember(i);
            if (!(startX < member.getMin() && member.getMin() < endX) && (!(startX < member.getMax()) || !(member.getMax() < endX))) continue;
            bandMembers.add(member);
        }
        return bandMembers;
    }

    public void setSelectedMember(BandMemberSelectable selecteable) {
        ArrayList<BandMemberSelectable> l = new ArrayList<BandMemberSelectable>();
        if (selecteable != null) {
            l.add(selecteable);
        }
        this.setSelectedMember(l);
    }

    public void setSelectedMember(List<BandMemberSelectable> selecteable) {
        List<BandMemberSelectable> newSelection = selecteable;
        if (selecteable == null) {
            newSelection = new ArrayList<BandMemberSelectable>();
        }
        for (BandMemberSelectable tmp : new ArrayList<BandMemberSelectable>(this.selectedBandMember)) {
            if (newSelection.contains(tmp)) continue;
            tmp.setSelected(false);
            this.selectedBandMember.remove(tmp);
        }
        for (BandMemberSelectable tmp : newSelection) {
            if (!tmp.isSelectable() || tmp.isSelected() || this.selectedBandMember.contains(tmp)) continue;
            tmp.setSelected(true);
            this.selectedBandMember.add(tmp);
        }
        this.repaint();
        if (this.model instanceof SimpleBandModel) {
            SimpleBandModel sbm = (SimpleBandModel)this.model;
            BandModelEvent e = new BandModelEvent();
            e.setSelectionLost(true);
            sbm.fireBandModelSelectionChanged(e);
        }
    }

    public void dispose() {
        if (this.model != null) {
            for (int i = 0; i < this.model.getNumberOfBands(); ++i) {
                Band band = this.model.getBand(i);
                if (band instanceof DisposableBand) {
                    ((DisposableBand)((Object)band)).dispose();
                }
                for (int mi = 0; mi < band.getNumberOfMembers(); ++mi) {
                    band.getMember(mi).getBandMemberComponent().removeMouseListener(this);
                    band.getMember(mi).getBandMemberComponent().removeMouseMotionListener(this);
                }
            }
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.scrollPane.setSize(width, height);
        this.bandsPanel.setSize(width, height);
    }

    @Override
    public void bandModelSelectionChanged(BandModelEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getComponent() instanceof BandMemberMouseListeningComponent) {
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getComponent() instanceof BandMemberMouseListeningComponent) {
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mouseExited(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.readOnly && e.getComponent() instanceof BandMemberMouseListeningComponent) {
            this.lastPressedComponent = e.getComponent();
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragged = false;
        if (!this.readOnly && e.getComponent() instanceof BandMemberMouseListeningComponent) {
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor(this);
        }
        this.dragged = true;
        if (!this.readOnly && e.getComponent() instanceof BandMemberMouseListeningComponent) {
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mouseDragged(e);
        }
        if (!this.readOnly && e.getComponent() instanceof StationaryBandMemberMouseListeningComponent) {
            int x = 0;
            x = e.getSource() == this.bandsPanel ? e.getX() : (int)((Component)e.getSource()).getBounds().getX() + e.getX();
            double station = this.getSationForXValue(x);
            if (station < this.getMinValue()) {
                station = this.getMinValue();
            } else if (station > this.getMaxValue()) {
                station = this.getMaxValue();
            }
            station = this.considerSnapping(station, e.getComponent());
            ((StationaryBandMemberMouseListeningComponent)((Object)e.getComponent())).mouseDragged(e, station);
        }
    }

    private double considerSnapping(double station, Component c) {
        int dist = (int)((this.maxValue - this.minValue) / (100.0 * (this.zoomFactor == 0.0 ? 1.0 : this.zoomFactor)));
        if (dist < 1) {
            dist = 1;
        }
        for (SnappingPoint tmp : this.snappingPoints) {
            if (!(Math.abs(tmp.value - station) < (double)dist) || tmp.c == c) continue;
            return tmp.value;
        }
        return station;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.isAltDown()) {
            Component source = e.getComponent();
            int x = 0;
            x = source == this.bandsPanel ? e.getX() : (int)source.getBounds().getX() + e.getX();
            if (!this.bandsPanel.isMeasurementEnabled()) {
                this.bandsPanel.setMeasurementEnabled(true);
            }
            this.bandsPanel.setMeasurementx(x);
        } else if (this.bandsPanel.isMeasurementEnabled()) {
            this.bandsPanel.setMeasurementEnabled(false);
        }
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor(this);
        } else {
            JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JBandCursorManager.getInstance().setCursor(this);
        }
        if (e.getComponent() instanceof BandMemberMouseListeningComponent) {
            ((BandMemberMouseListeningComponent)((Object)e.getComponent())).mouseMoved(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void bandModelChanged(BandModelEvent e) {
        if (!this.refreshAvoided) {
            this.init();
            if (e != null && e.isSelectionLost()) {
                this.selectedBandMember.clear();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JBand.this.bandsPanel.repaint();
                }
            });
        }
    }

    @Override
    public void bandModelValuesChanged(BandModelEvent e) {
        if (!this.refreshAvoided) {
            if (e != null && e.isSelectionLost()) {
                this.selectedBandMember.clear();
            }
            this.layoutBandMemberComponents();
            this.repaint();
        }
    }

    public BandModel getModel() {
        return this.model;
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        JFrame jf = new JFrame("Test");
        jf.setDefaultCloseOperation(3);
        jf.getContentPane().setLayout(new BorderLayout());
        final JBand jbdTest = new JBand();
        MinimumHeightBand sb0 = new MinimumHeightBand();
        sb0.addMember(new SimpleTextSection("OTOL-800", 0.0, 300.0, true, false));
        sb0.addMember(new SimpleTextSection("OTOL-8700", 300.0, 500.0, false, false));
        sb0.addMember(new SimpleTextSection("OTOL-900", 500.0, 1000.0, false, true));
        final DefaultBand sb1 = new DefaultBand("Selektierbar");
        sb1.addMember(new SelectableSectionPanel(250.0, 1000.0));
        SimpleBand sb2 = new SimpleBand();
        sb2.addMember(new SimpleSection(0.0, 10.0));
        sb2.addMember(new SimpleSection(10.0, 20.0));
        sb2.addMember(new SimpleSection(20.0, 80.0));
        sb2.addMember(new SimpleSection(80.0, 100.0));
        SimpleBand sb3 = new SimpleBand();
        sb3.addMember(new SimpleSection(0.0, 50.0));
        sb3.addMember(new SimpleSection(50.0, 300.0));
        sb3.addMember(new SimpleSection(300.0, 1000.0));
        SimpleBand sb4 = new SimpleBand("Punkte .......");
        sb4.addMember(new SimpleSpot(100.0));
        sb4.addMember(new SimpleSpot(200.0));
        sb4.addMember(new SimpleSpot(300.0));
        sb4.addMember(new SimpleSpot(400.0));
        sb4.addMember(new SimpleSpot(500.0));
        SimpleBand sb4a = new SimpleBand("auch");
        sb4a.addMember(new SimpleSection(100.0, 100.0));
        sb4a.addMember(new SimpleSection(110.0, 110.0));
        sb4a.addMember(new SimpleSection(300.0, 300.0));
        sb4a.addMember(new SimpleSection(400.0, 400.0));
        sb4a.addMember(new SimpleSection(500.0, 500.0));
        SimpleBandModel sbm = new SimpleBandModel();
        sbm.addBand(sb0);
        sbm.addBand(sb1);
        sbm.addBand(new EmptyAbsoluteHeightedBand(1));
        sbm.addBand(sb2);
        sbm.addBand(new EmptyAbsoluteHeightedBand(1));
        SimpleModifiableBand sb6 = new SimpleModifiableBand("Band");
        sb6.addMember(new SimpleModifiableBandMember(sb6, false, 0.0, 100.0));
        sb6.addMember(new SimpleModifiableBandMember(sb6, false, 200.0, 500.0));
        sb6.addMember(new SimpleModifiableBandMember(sb6, false, 600.0, 1000.0));
        sbm.addBand(sb3);
        sbm.addBand(sb4);
        sbm.addBand(sb4a);
        sbm.addBand(sb6);
        SimpleBand sb5 = new SimpleBand();
        sb5.addMember(new SimpleSection(0.0, 1100.0));
        sb5.addMember(new SimpleSection(50.0, 500.0));
        sb5.addMember(new SimpleSection(400.0, 600.0));
        sbm.addBand(sb5);
        jbdTest.setModel(sbm);
        jbdTest.setBorder(new EmptyBorder(10, 10, 10, 10));
        jf.getContentPane().add((Component)jbdTest, "Center");
        final JSlider jsl = new JSlider(0, 100);
        jsl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                double zfAdd = (double)jsl.getValue() / 10.0;
                jbdTest.setZoomFactor(1.0 + zfAdd);
            }
        });
        JCheckBox checker = new JCheckBox("test");
        checker.setSelected(true);
        checker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sb1.setEnabled(!sb1.isEnabled());
                ((SimpleBandModel)jbdTest.getModel()).fireBandModelValuesChanged();
            }
        });
        JButton cmd2 = new JButton("2.0");
        cmd2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jbdTest.setZoomFactor(2.0);
            }
        });
        jf.getContentPane().add((Component)cmd2, "North");
        jsl.setValue(0);
        jf.getContentPane().add((Component)jsl, "South");
        jf.setSize(300, 400);
        jf.setVisible(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setBounds((screenSize.width - 800) / 2, (screenSize.height - 222) / 2, 1000, 222);
        jbdTest.setHideEmptyPrePostfix(true);
    }

    public boolean isRefreshAvoided() {
        return this.refreshAvoided;
    }

    public void setRefreshAvoided(boolean refreshAvoided) {
        this.refreshAvoided = refreshAvoided;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
        this.setAdditionalZoomFactor();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        this.setAdditionalZoomFactor();
    }

    private void setAdditionalZoomFactor() {
        this.additionalZoomFactor = (this.maxValue - this.minValue) / 1000.0;
        if (this.additionalZoomFactor < 1.0) {
            this.additionalZoomFactor = 1.0;
        }
    }

    private double getSationForXValue(int x) {
        return (double)Math.round((this.realWidth * (double)x / (double)this.bandsPanel.getWidth() + this.minValue) * 10.0) / 10.0;
    }

    public void scrollToBandMember(BandMember bandMember) {
        double min = bandMember.getMin();
        double max = bandMember.getMax();
        double len = max - min;
        double mid = min + len / 2.0;
        double fac = mid / (this.maxValue - this.minValue);
        double maxScrollBarValue = this.scrollPane.getHorizontalScrollBar().getMaximum() - this.scrollPane.getHorizontalScrollBar().getVisibleAmount();
        double midOfMember = fac * (double)this.scrollPane.getHorizontalScrollBar().getMaximum();
        double halfVisibleAmountBeforeMid = midOfMember - (double)(this.scrollPane.getHorizontalScrollBar().getVisibleAmount() / 2);
        if (halfVisibleAmountBeforeMid < (double)this.scrollPane.getHorizontalScrollBar().getMinimum()) {
            halfVisibleAmountBeforeMid = this.scrollPane.getHorizontalScrollBar().getMinimum();
        } else if (halfVisibleAmountBeforeMid > maxScrollBarValue) {
            halfVisibleAmountBeforeMid = maxScrollBarValue;
        }
        this.scrollPane.getHorizontalScrollBar().setValue((int)halfVisibleAmountBeforeMid);
    }

    private class BandMemberComparator
    implements Comparator<BandMember> {
        private BandMemberComparator() {
        }

        @Override
        public int compare(BandMember o1, BandMember o2) {
            return (int)Math.signum(o1.getMin() - o2.getMin());
        }
    }

    class JBandsPanel
    extends JPanel {
        private boolean measurementEnabled;
        private int measurementx;
        private Color MIDDLE;
        private Color SIDE;
        private Color SIDER;

        public JBandsPanel() {
            super(null);
            this.measurementEnabled = false;
            this.measurementx = 0;
            this.MIDDLE = new Color(50, 50, 50, 150);
            this.SIDE = new Color(250, 250, 250, 150);
            this.SIDER = new Color(220, 220, 220, 50);
            this.setForeground(new Color(50, 50, 50, 150));
        }

        public boolean isMeasurementEnabled() {
            return this.measurementEnabled;
        }

        public void setMeasurementEnabled(boolean measurementEnabled) {
            this.measurementEnabled = measurementEnabled;
            this.repaint();
        }

        public int getMeasurementx() {
            return this.measurementx;
        }

        public void setMeasurementx(int measurementx) {
            this.measurementx = measurementx < 0 ? 0 : measurementx;
            if (this.measurementEnabled) {
                this.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension((int)((double)JBand.this.scrollPane.getWidth() * 0.9 * JBand.this.zoomFactor), d.height);
        }

        @Override
        public void setSize(int width, int height) {
            super.setSize(width, height);
            JBand.this.layoutBandMemberComponents();
        }

        @Override
        public void setSize(Dimension d) {
            this.setSize(d.width, d.height);
        }

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (this.measurementEnabled) {
                Graphics2D g2d = (Graphics2D)g;
                double station = JBand.this.getSationForXValue(this.measurementx);
                g.setColor(this.SIDER);
                g.drawLine(this.measurementx - 2, 0, this.measurementx - 2, this.getHeight());
                g.drawLine(this.measurementx + 2, 0, this.measurementx + 2, this.getHeight());
                g.setColor(this.SIDE);
                g.drawLine(this.measurementx - 1, 0, this.measurementx - 1, this.getHeight());
                g.drawLine(this.measurementx + 1, 0, this.measurementx + 1, this.getHeight());
                g.setColor(this.MIDDLE);
                g.drawLine(this.measurementx, 0, this.measurementx, this.getHeight());
                String s = String.valueOf(station);
                int sWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), s);
                int sPos = this.measurementx + 5;
                if (sPos + sWidth <= this.getWidth() - 10) {
                    g.drawString(s, this.measurementx + 5, this.getHeight() - 3);
                } else {
                    g.drawString(s, this.measurementx - sWidth - 5, this.getHeight() - 3);
                }
            }
        }
    }

    class JLegendPanel
    extends JPanel {
        public JLegendPanel() {
            super(null);
            this.setOpaque(false);
            this.setForeground(new Color(50, 50, 50, 150));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            double maxWidth = 100.0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                int tmp = (int)this.getComponent(i).getPreferredSize().getWidth();
                if (!((double)tmp > maxWidth)) continue;
                maxWidth = tmp;
            }
            return new Dimension((int)(maxWidth += 2.0), d.height);
        }
    }

    class JBandYDimension {
        private Band band;
        private int yMin;
        private int yMax;

        public JBandYDimension(Band band, int yMin, int yMax) {
            this.band = band;
            this.yMin = yMin;
            this.yMax = yMax;
        }

        public Band getBand() {
            return this.band;
        }

        public void setBand(Band band) {
            this.band = band;
        }

        public int getyMin() {
            return this.yMin;
        }

        public void setyMin(int yMin) {
            this.yMin = yMin;
        }

        public int getyMax() {
            return this.yMax;
        }

        public void setyMax(int yMax) {
            this.yMax = yMax;
        }
    }

    class SnappingPoint
    implements Comparable<SnappingPoint> {
        private Double value;
        private Component c;

        public SnappingPoint(double value, Component c) {
            this.value = value;
            this.c = c;
        }

        @Override
        public int compareTo(SnappingPoint other) {
            double o = other.value;
            if (Math.abs(this.value - o) < (JBand.this.maxValue - JBand.this.minValue) / 100.0) {
                return 0;
            }
            return this.value.compareTo(o);
        }

        public Component getC() {
            return this.c;
        }

        public void setC(Component c) {
            this.c = c;
        }
    }

    private static class SelectableSectionPanel
    extends JPanel
    implements Section,
    BandMember,
    BandMemberSelectable {
        private boolean selected;
        private double from = 0.0;
        private double to = 0.0;

        public SelectableSectionPanel(double from, double to) {
            this(Color.getHSBColor((float)Math.random(), 0.85f, 1.0f), from, to);
        }

        public SelectableSectionPanel(Color c, double from, double to) {
            this.initComponents();
            this.from = from;
            this.to = to;
            this.setBackground(c);
        }

        private void initComponents() {
            this.setBackground(new Color(255, 51, 0));
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(1, 1));
            GroupLayout layout = new GroupLayout((Container)this);
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 1, Short.MAX_VALUE));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 1, Short.MAX_VALUE));
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean selection) {
            this.selected = selection;
            if (selection) {
                this.setBackground(this.getBackground().darker());
            } else {
                this.setBackground(this.getBackground().brighter());
            }
        }

        @Override
        public boolean isSelectable() {
            return true;
        }

        @Override
        public BandMember getBandMember() {
            return this;
        }

        public void setFrom(double from) {
            this.from = from;
        }

        public void setTo(double to) {
            this.to = to;
        }

        @Override
        public double getMax() {
            return this.from < this.to ? this.to : this.from;
        }

        @Override
        public double getMin() {
            return this.from < this.to ? this.from : this.to;
        }

        @Override
        public JComponent getBandMemberComponent() {
            return this;
        }

        @Override
        public double getFrom() {
            return this.from;
        }

        @Override
        public double getTo() {
            return this.to;
        }
    }

    public static enum SelectionMode {
        SINGLE_SELECTION,
        MULTIPLE_INTERVAL_SELECTION;

    }
}

