/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jbands;

import de.cismet.tools.gui.jbands.BandEvent;
import de.cismet.tools.gui.jbands.BandModelEvent;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandListener;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import de.cismet.tools.gui.jbands.interfaces.BandModelListener;
import de.cismet.tools.gui.jbands.interfaces.BandModificationProvider;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleBandModel
implements BandModel,
BandListener {
    private ArrayList<Band> bands = new ArrayList();
    private final CopyOnWriteArrayList<BandModelListener> listeners = new CopyOnWriteArrayList();
    private double min = -1.0;
    private double max = -1.0;

    @Override
    public Band getBand(int bandNumber) {
        return this.bands.get(bandNumber);
    }

    @Override
    public int getNumberOfBands() {
        return this.bands.size();
    }

    public void addBand(Band band) {
        if (band == null) {
            throw new IllegalArgumentException("band must not be null");
        }
        if (band instanceof BandModificationProvider) {
            ((BandModificationProvider)((Object)band)).addBandListener(this);
        }
        this.bands.add(band);
        this.fireBandModelChanged();
    }

    public void insertBand(Band band, int pos) {
        if (band == null) {
            throw new IllegalArgumentException("band must not be null");
        }
        this.bands.add(pos, band);
        this.fireBandModelChanged();
    }

    public int removeBand(Band band) {
        int pos = this.bands.indexOf(band);
        if (band instanceof BandModificationProvider) {
            ((BandModificationProvider)((Object)band)).removeBandListener(this);
        }
        this.bands.remove(band);
        this.fireBandModelChanged();
        return pos;
    }

    @Override
    public double getMax() {
        if (this.max > -1.0) {
            return this.max;
        }
        double value = 0.0;
        for (Band b : this.bands) {
            value = b.getMax() > value ? b.getMax() : value;
        }
        return value;
    }

    @Override
    public double getMin() {
        if (this.min > -1.0) {
            return this.min;
        }
        double value = Double.MAX_VALUE;
        for (Band b : this.bands) {
            value = b.getMin() < value ? b.getMin() : value;
        }
        return value;
    }

    @Override
    public void addBandModelListener(BandModelListener bml) {
        this.listeners.add(bml);
    }

    @Override
    public void removeBandModelListener(BandModelListener bml) {
        this.listeners.remove(bml);
    }

    public void fireBandModelChanged() {
        for (BandModelListener bml : this.listeners) {
            bml.bandModelChanged(null);
        }
    }

    public void fireBandModelChanged(BandModelEvent e) {
        for (BandModelListener bml : this.listeners) {
            bml.bandModelChanged(e);
        }
    }

    public void fireBandModelSelectionChanged() {
        for (BandModelListener bml : this.listeners) {
            bml.bandModelSelectionChanged(null);
        }
    }

    public void fireBandModelSelectionChanged(BandModelEvent e) {
        for (BandModelListener bml : this.listeners) {
            bml.bandModelSelectionChanged(e);
        }
    }

    public void fireBandModelValuesChanged(BandModelEvent e) {
        for (BandModelListener bml : this.listeners) {
            bml.bandModelValuesChanged(e);
        }
    }

    public void fireBandModelValuesChanged() {
        for (BandModelListener bml : this.listeners) {
            bml.bandModelValuesChanged(null);
        }
    }

    @Override
    public void bandChanged(BandEvent e) {
        if (e.isSelectionLost()) {
            BandModelEvent bme = new BandModelEvent();
            bme.setSelectionLost(true);
            if (e != null && !e.isModelChanged()) {
                this.fireBandModelValuesChanged(bme);
            } else {
                this.fireBandModelChanged(bme);
            }
            this.fireBandModelSelectionChanged();
        } else if (e != null && !e.isModelChanged()) {
            this.fireBandModelValuesChanged(null);
        } else {
            this.fireBandModelChanged(null);
        }
    }

    public void setMin(double min) {
        this.min = min;
        for (Band tmp : this.bands) {
            if (!(tmp instanceof BandModificationProvider)) continue;
            ((BandModificationProvider)((Object)tmp)).setMin(min);
        }
    }

    public void setMax(double max) {
        this.max = max;
        for (Band tmp : this.bands) {
            if (!(tmp instanceof BandModificationProvider)) continue;
            ((BandModificationProvider)((Object)tmp)).setMax(max);
        }
    }
}

