/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jbands;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.jbands.BandEvent;
import de.cismet.tools.gui.jbands.BandMemberEvent;
import de.cismet.tools.gui.jbands.DefaultBand;
import de.cismet.tools.gui.jbands.SimpleModifiableBandMember;
import de.cismet.tools.gui.jbands.interfaces.BandListener;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberListener;
import de.cismet.tools.gui.jbands.interfaces.BandModificationProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SimpleModifiableBand
extends DefaultBand
implements BandModificationProvider,
BandMemberListener {
    private static final Logger LOG = Logger.getLogger(SimpleModifiableBand.class);
    protected boolean readOnly = false;
    protected Double fixMin = null;
    protected Double fixMax = null;
    private List<BandListener> listenerList = new ArrayList<BandListener>();

    public SimpleModifiableBand(String title) {
        this(1.0f, title);
    }

    public SimpleModifiableBand(float heightWeight) {
        super(heightWeight);
    }

    public SimpleModifiableBand(float heightWeight, String title) {
        super(heightWeight, title);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void addMember(final Double startStation, final Double endStation, final Double minStart, final Double maxEnd, final List<BandMember> memberList) {
        WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame(this.getPrefixComponent()), true, "Erstelle Abschnitt", null, 100){

            @Override
            protected Void doInBackground() throws Exception {
                if (endStation == null) {
                    SimpleModifiableBand.this.addUnspecifiedMember(startStation, minStart, maxEnd, memberList);
                } else {
                    SimpleModifiableBand.this.addSpecifiedMember(startStation, endStation);
                }
                return null;
            }
        };
        wdt.start();
    }

    @Override
    public void addMember(BandMember m) {
        super.addMember(m);
        if (m instanceof SimpleModifiableBandMember) {
            ((SimpleModifiableBandMember)m).addBandMemberListener(this);
        }
    }

    private void addUnspecifiedMember(Double startStation, Double minStart, Double maxEnd, List<BandMember> memberList) {
        double distanceBefore = Double.MAX_VALUE;
        double distanceBehind = Double.MAX_VALUE;
        double newTo = maxEnd;
        double newFrom = minStart;
        if (memberList != null) {
            for (BandMember tmp : memberList) {
                Double from = tmp.getMin();
                Double till = tmp.getMax();
                if (from == null || till == null) continue;
                double distance = startStation - till;
                if (distance < distanceBefore && distance >= 0.0) {
                    distanceBefore = distance;
                    newFrom = till;
                }
                if (!((distance = from - startStation) < distanceBehind) || !(distance >= 0.0)) continue;
                distanceBehind = distance;
                newTo = from;
            }
            try {
                this.addNewMember(newFrom, newTo);
            }
            catch (Exception e) {
                LOG.error((Object)"error while creating new station.", (Throwable)e);
            }
        }
    }

    private void addSpecifiedMember(Double startStation, Double endStation) {
        try {
            this.addNewMember(startStation, endStation);
        }
        catch (Exception e) {
            LOG.error((Object)"error while creating new station.", (Throwable)e);
        }
    }

    private void addNewMember(Double start, Double end) throws Exception {
        SimpleModifiableBandMember m = this.createNewBandMember(start, end);
        this.members.add(m);
        this.fireBandChanged(new BandEvent());
    }

    protected SimpleModifiableBandMember createNewBandMember(Double start, Double end) {
        SimpleModifiableBandMember member = new SimpleModifiableBandMember(this, this.readOnly, start, end);
        member.addBandMemberListener(this);
        return member;
    }

    @Override
    public void addBandListener(BandListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeBandListener(BandListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireBandChanged(BandEvent e) {
        for (BandListener l : this.listenerList) {
            l.bandChanged(e);
        }
    }

    @Override
    public void bandMemberChanged(BandMemberEvent e) {
        BandEvent ev = new BandEvent();
        if (e != null) {
            if (e.isSelectionLost()) {
                ev.setSelectionLost(true);
            }
            ev.setModelChanged(e.isModelChanged());
        }
        this.fireBandChanged(ev);
    }

    public void deleteMember(SimpleModifiableBandMember member) {
        this.members.remove(member);
        BandEvent e = new BandEvent();
        e.setSelectionLost(true);
        this.fireBandChanged(e);
    }

    @Override
    public void setMin(Double min) {
        this.fixMin = min;
    }

    @Override
    public void setMax(Double max) {
        this.fixMax = max;
    }

    @Override
    public double getMin() {
        if (this.fixMin != null) {
            return this.fixMin;
        }
        return super.getMin();
    }

    @Override
    public double getMax() {
        if (this.fixMax != null) {
            return this.fixMax;
        }
        return super.getMax();
    }
}

