/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.jtextcompoonent.undoredo;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class UndoableTableModel
extends AbstractTableModel
implements TableModelListener {
    private TableModel delegate;
    private UndoableEditSupport support = new UndoableEditSupport();

    public UndoableTableModel(TableModel delegate) {
        this.setDelegate(delegate);
    }

    public void setDelegate(TableModel delegate) {
        if (this.delegate != null) {
            this.delegate.removeTableModelListener(this);
        }
        this.delegate = delegate;
        if (this.delegate != null) {
            this.delegate.addTableModelListener(this);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.delegate.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.delegate.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.delegate.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.delegate.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.delegate.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.delegate.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object oldValue = this.delegate.getValueAt(rowIndex, columnIndex);
        this.delegate.setValueAt(aValue, rowIndex, columnIndex);
        Object newValue = this.delegate.getValueAt(rowIndex, columnIndex);
        this.fireChangeEdit(rowIndex, columnIndex, oldValue, newValue);
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.support.addUndoableEditListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.support.removeUndoableEditListener(l);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModelEvent newEvent = new TableModelEvent(this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType());
        this.fireTableChanged(newEvent);
    }

    protected void fireChangeEdit(int row, int col, Object oldValue, Object newValue) {
        TableChangeEdit edit = new TableChangeEdit(row, col, oldValue, newValue);
        this.support.beginUpdate();
        this.support.postEdit(edit);
        this.support.endUpdate();
    }

    private class TableChangeEdit
    extends AbstractUndoableEdit {
        private int columnIndex;
        private int rowIndex;
        private Object oldValue;
        private Object newValue;

        public TableChangeEdit(int rowIndex, int columnIndex, Object oldValue, Object newValue) {
            this.columnIndex = columnIndex;
            this.rowIndex = rowIndex;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            UndoableTableModel.this.delegate.setValueAt(this.oldValue, this.rowIndex, this.columnIndex);
        }

        @Override
        public void redo() {
            super.redo();
            UndoableTableModel.this.delegate.setValueAt(this.newValue, this.rowIndex, this.columnIndex);
        }
    }
}

