/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.log4jquickconfig;

import de.cismet.tools.gui.GradientPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;
import org.openide.util.NbBundle;

public class Log4JQuickConfig
extends JDialog {
    private static Log4JQuickConfig log4jConfigurator = null;
    private ButtonGroup bgrWhat;
    private JCheckBox chkConsole;
    private JCheckBox chkFile;
    private JCheckBox chkSockets;
    private JButton cmdCancel;
    private JButton cmdConfig;
    private JButton cmdFile;
    private GradientPanel gpnTitle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel lblFile;
    private JLabel lblHost;
    private JLabel lblPort;
    private JPanel panButtons;
    private JPanel panConfig;
    private JPanel panTitle;
    private JPanel panWhat;
    private JPanel panWhere;
    private JRadioButton rdbDebug;
    private JRadioButton rdbDisable;
    private JRadioButton rdbError;
    private JRadioButton rdbFatal;
    private JRadioButton rdbInfo;
    private JRadioButton rdbWarn;
    private JTextField txtFile;
    private JTextField txtHost;
    private JTextField txtPort;

    public Log4JQuickConfig() {
        super((Frame)null, true);
        this.initComponents();
        this.gpnTitle.setLeftColor(new Color(49, 66, 122));
        this.gpnTitle.setRightColor(Color.white);
        this.getRootPane().setDefaultButton(this.cmdConfig);
        StaticSwingTools.doClickButtonOnKeyStroke(this.cmdConfig, KeyStroke.getKeyStroke(10, 0), this.getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke(this.cmdCancel, KeyStroke.getKeyStroke(27, 0), this.getRootPane());
    }

    private void initComponents() {
        this.bgrWhat = new ButtonGroup();
        this.panConfig = new JPanel();
        this.panWhat = new JPanel();
        this.rdbDebug = new JRadioButton();
        this.rdbInfo = new JRadioButton();
        this.rdbWarn = new JRadioButton();
        this.rdbError = new JRadioButton();
        this.rdbFatal = new JRadioButton();
        this.rdbDisable = new JRadioButton();
        this.panWhere = new JPanel();
        this.chkSockets = new JCheckBox();
        this.lblHost = new JLabel();
        this.txtHost = new JTextField();
        this.lblPort = new JLabel();
        this.txtPort = new JTextField();
        this.chkFile = new JCheckBox();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.cmdFile = new JButton();
        this.chkConsole = new JCheckBox();
        this.panTitle = new JPanel();
        this.gpnTitle = new GradientPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.panButtons = new JPanel();
        this.cmdCancel = new JButton();
        this.cmdConfig = new JButton();
        this.jPanel1 = new JPanel();
        this.panConfig.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.panConfig.setLayout(new GridBagLayout());
        this.panWhat.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.panWhat.border.insideBorder.title"))));
        this.panWhat.setLayout(new GridBagLayout());
        this.bgrWhat.add(this.rdbDebug);
        this.rdbDebug.setSelected(true);
        this.rdbDebug.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.rdbDebug.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panWhat.add((Component)this.rdbDebug, gridBagConstraints);
        this.bgrWhat.add(this.rdbInfo);
        this.rdbInfo.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.rdbInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panWhat.add((Component)this.rdbInfo, gridBagConstraints);
        this.bgrWhat.add(this.rdbWarn);
        this.rdbWarn.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.rdbWarn.text"));
        this.rdbWarn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Log4JQuickConfig.this.rdbWarnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panWhat.add((Component)this.rdbWarn, gridBagConstraints);
        this.bgrWhat.add(this.rdbError);
        this.rdbError.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.rdbError.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panWhat.add((Component)this.rdbError, gridBagConstraints);
        this.bgrWhat.add(this.rdbFatal);
        this.rdbFatal.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.rdbFatal.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panWhat.add((Component)this.rdbFatal, gridBagConstraints);
        this.bgrWhat.add(this.rdbDisable);
        this.rdbDisable.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.rdbDisable.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.panWhat.add((Component)this.rdbDisable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panConfig.add((Component)this.panWhat, gridBagConstraints);
        this.panWhere.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.panWhere.border.insideBorder.title"))));
        this.panWhere.setLayout(new GridBagLayout());
        this.chkSockets.setSelected(true);
        this.chkSockets.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.chkSockets.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 2, 0);
        this.panWhere.add((Component)this.chkSockets, gridBagConstraints);
        this.lblHost.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.lblHost.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 2, 0);
        this.panWhere.add((Component)this.lblHost, gridBagConstraints);
        this.txtHost.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.txtHost.text"));
        this.txtHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Log4JQuickConfig.this.txtHostActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 2, 9);
        this.panWhere.add((Component)this.txtHost, gridBagConstraints);
        this.lblPort.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.lblPort.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 2, 0);
        this.panWhere.add((Component)this.lblPort, gridBagConstraints);
        this.txtPort.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.txtPort.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 2, 9);
        this.panWhere.add((Component)this.txtPort, gridBagConstraints);
        this.chkFile.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.chkFile.text"));
        this.chkFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Log4JQuickConfig.this.chkFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 2, 0);
        this.panWhere.add((Component)this.chkFile, gridBagConstraints);
        this.lblFile.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.lblFile.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 2, 0);
        this.panWhere.add((Component)this.lblFile, gridBagConstraints);
        this.txtFile.setEnabled(false);
        this.txtFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Log4JQuickConfig.this.txtFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 2, 9);
        this.panWhere.add((Component)this.txtFile, gridBagConstraints);
        this.cmdFile.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.cmdFile.text"));
        this.cmdFile.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 2, 3);
        this.panWhere.add((Component)this.cmdFile, gridBagConstraints);
        this.chkConsole.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.chkConsole.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 2, 0);
        this.panWhere.add((Component)this.chkConsole, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panConfig.add((Component)this.panWhere, gridBagConstraints);
        this.getContentPane().add((Component)this.panConfig, "Center");
        this.panTitle.setLayout(new GridBagLayout());
        this.gpnTitle.setForeground(new Color(236, 233, 216));
        this.gpnTitle.setLeftColor(new Color(49, 66, 122));
        this.gpnTitle.setRightColor(new Color(255, 255, 255));
        this.gpnTitle.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Courier", 1, 24));
        this.jLabel1.setForeground(new Color(236, 233, 216));
        this.jLabel1.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.gpnTitle.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 75.0;
        this.panTitle.add((Component)this.gpnTitle, gridBagConstraints);
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/log4jquickconfig/res/log4j.png")));
        this.jPanel3.add(this.jLabel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panTitle.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.panTitle.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.panTitle, "North");
        this.panButtons.setLayout(new GridBagLayout());
        this.cmdCancel.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.cmdCancel.text_1"));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Log4JQuickConfig.this.cmdCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.panButtons.add((Component)this.cmdCancel, gridBagConstraints);
        this.cmdConfig.setText(NbBundle.getMessage(Log4JQuickConfig.class, (String)"Log4JQuickConfig.cmdConfig.text"));
        this.cmdConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Log4JQuickConfig.this.cmdConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 4, 7);
        this.panButtons.add((Component)this.cmdConfig, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panButtons.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.panButtons, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 532) / 2, (screenSize.height - 335) / 2, 532, 335);
    }

    private void chkFileActionPerformed(ActionEvent evt) {
        this.txtFile.setEnabled(this.chkFile.isSelected());
    }

    private void cmdConfigActionPerformed(ActionEvent evt) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        for (Appender appender : config.getAppenders().values()) {
            ctx.getLogger("root").removeAppender(appender);
        }
        ctx.updateLoggers();
        Level level = Level.DEBUG;
        if (this.rdbInfo.isSelected()) {
            level = Level.INFO;
        } else if (this.rdbWarn.isSelected()) {
            level = Level.WARN;
        } else if (this.rdbError.isSelected()) {
            level = Level.ERROR;
        } else if (this.rdbFatal.isSelected()) {
            level = Level.FATAL;
        } else if (this.rdbDisable.isSelected()) {
            level = Level.OFF;
        }
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        if (this.chkSockets.isSelected()) {
            AppenderComponentBuilder socketAppender = (AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("Remote", "Socket").addAttribute("host", this.txtHost.getText())).addAttribute("port", Integer.parseInt(this.txtPort.getText()));
            socketAppender.add(builder.newLayout("JsonLayout"));
            builder.add(socketAppender);
        }
        if (this.chkFile.isSelected()) {
            AppenderComponentBuilder fileAppender = (AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("File", "File").addAttribute("fileName", this.txtFile.getText())).addAttribute("append", true);
            fileAppender.add(builder.newLayout("HtmlLayout"));
            builder.add(fileAppender);
        }
        if (this.chkConsole.isSelected()) {
            AppenderComponentBuilder consoleAppender = builder.newAppender("Console", "Console");
            consoleAppender.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%d{yyyy-MM-dd HH:mm:ss}] [%t] %-5level %logger{36} - %msg%n"));
            builder.add(consoleAppender);
        }
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);
        if (this.chkSockets.isSelected()) {
            rootLogger.add(builder.newAppenderRef("Remote"));
        }
        if (this.chkFile.isSelected()) {
            rootLogger.add(builder.newAppenderRef("File"));
        }
        if (this.chkConsole.isSelected()) {
            rootLogger.add(builder.newAppenderRef("Console"));
        }
        builder.add(rootLogger);
        ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = (Configuration)builder.build();
        ctx.start(conf);
        this.hide();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.hide();
    }

    private void txtFileActionPerformed(ActionEvent evt) {
    }

    private void txtHostActionPerformed(ActionEvent evt) {
    }

    private void rdbWarnActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Log4JQuickConfig.getSingletonInstance().setVisible(true);
            }
        });
    }

    public static Log4JQuickConfig getSingletonInstance() {
        if (log4jConfigurator == null) {
            log4jConfigurator = new Log4JQuickConfig();
        }
        return log4jConfigurator;
    }

    public static void configure4LumbermillOnLocalhost() {
        Log4JQuickConfig.configure4LumbermillOnLocalhost("DEBUG");
    }

    public static void configure4LumbermillOnLocalhost(String level) {
        Log4JQuickConfig.configure4LumbermillOn("localhost", 4445, level);
    }

    public static void configure4LumbermillOn(String host, int port) {
        Log4JQuickConfig.configure4LumbermillOn(host, port, "DEBUG");
    }

    public static void configure4LumbermillOn(String host, int port, String level) {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        builder.setStatusLevel(Level.WARN);
        builder.setConfigurationName("DynamicConfig");
        AppenderComponentBuilder socketAppender = (AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("Remote", "Socket").addAttribute("host", host)).addAttribute("port", port);
        socketAppender.add(builder.newLayout("JsonLayout"));
        builder.add(socketAppender);
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);
        builder.add(rootLogger);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration conf = (Configuration)builder.build();
        ctx.start(conf);
    }
}

