/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.panels;

import de.cismet.tools.gui.RoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AlertPanel
extends RoundedPanel {
    public static final Color dangerBgColor = new Color(242, 222, 222);
    public static final Color dangerBorderColor = new Color(235, 204, 209);
    public static final Color dangerMessageColor = new Color(169, 69, 66);
    public static final Color infoBgColor = new Color(217, 237, 247);
    public static final Color infoBorderColor = new Color(188, 232, 241);
    public static final Color infoMessageColor = new Color(80, 112, 152);
    public static final Color successBgColor = new Color(223, 240, 216);
    public static final Color successBorderColor = new Color(214, 233, 198);
    public static final Color successMessageColor = new Color(90, 118, 75);
    public static final Color warningBgColor = new Color(252, 248, 227);
    public static final Color warningBorderColor = new Color(250, 235, 204);
    public static final Color warningMessageColor = new Color(159, 109, 74);
    private TYPE type;
    private boolean closeable = false;
    private AbstractBorder border;
    private Component content;
    private final ArrayList<ActionListener> closeListeners = new ArrayList();
    private JButton closeButton;
    private JPanel pnlContent;

    public AlertPanel() {
        this(TYPE.INFO, new JLabel("insert a message"), true);
    }

    public AlertPanel(TYPE t, String message, boolean closeable) {
        this(t, new JLabel("insert a message"), closeable);
    }

    public AlertPanel(TYPE t, Component content, boolean closeable) {
        this.alpha = 255;
        this.type = t;
        this.closeable = closeable;
        this.content = content;
        this.initComponents();
        this.pnlContent.add(content, "Center");
        this.stylePanel();
    }

    public void addCloseButtonActionListener(ActionListener al) {
        this.closeListeners.add(al);
    }

    public void removeCloseButtonActionListener(ActionListener al) {
        this.closeListeners.remove(al);
    }

    private void fireCloseEvent(ActionEvent ae) {
        for (ActionListener al : this.closeListeners) {
            al.actionPerformed(ae);
        }
    }

    private void styleDanger() {
        this.setBackground(dangerBgColor);
        this.border = new RoundedBorder(dangerBorderColor, this.curve, 1);
        if (this.content instanceof JLabel) {
            ((JLabel)this.content).setForeground(dangerMessageColor);
        }
    }

    private void styleSuccess() {
        this.setBackground(successBgColor);
        this.border = new RoundedBorder(successBorderColor, this.curve, 1);
        if (this.content instanceof JLabel) {
            ((JLabel)this.content).setForeground(successMessageColor);
        }
    }

    private void styleWarning() {
        this.setBackground(warningBgColor);
        this.border = new RoundedBorder(warningBorderColor, this.curve, 1);
        if (this.content instanceof JLabel) {
            ((JLabel)this.content).setForeground(warningMessageColor);
        }
    }

    private void styleInfo() {
        this.setBackground(infoBgColor);
        this.border = new RoundedBorder(infoBorderColor, this.curve, 1);
        if (this.content instanceof JLabel) {
            ((JLabel)this.content).setForeground(infoMessageColor);
        }
    }

    public void setContent(Component content) {
        this.pnlContent.removeAll();
        this.pnlContent.add(content, "Center");
    }

    public void setType(TYPE t) {
        this.type = t;
        this.stylePanel();
    }

    private void stylePanel() {
        switch (this.type) {
            case DANGER: {
                this.styleDanger();
                break;
            }
            case SUCCESS: {
                this.styleSuccess();
                break;
            }
            case WARNING: {
                this.styleWarning();
                break;
            }
            default: {
                this.styleInfo();
            }
        }
        this.setBorder(BorderFactory.createCompoundBorder(this.border, new EmptyBorder(10, 30, 10, 10)));
    }

    public static void main(String[] args) {
        AlertPanel info = new AlertPanel(TYPE.INFO, new JLabel("<html> <b>INFO! </b> What a cool alert message box</html>"), true);
        AlertPanel success = new AlertPanel(TYPE.SUCCESS, new JLabel("<html> <b>SUCCESS! </b>What a cool alert message box</html>"), true);
        AlertPanel warn = new AlertPanel(TYPE.WARNING, new JLabel("<html> <b>WARNING! </b>What a cool alert message box</html>"), true);
        AlertPanel danger = new AlertPanel(TYPE.DANGER, new JLabel("<html> <b>DANGER! </b>What a cool alert message box</html>"), true);
        JFrame f = new JFrame();
        f.setSize(500, 500);
        f.setDefaultCloseOperation(3);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridLayout layout = new GridLayout(4, 1);
        layout.setHgap(5);
        layout.setVgap(5);
        p.setLayout(layout);
        p.add(info);
        p.add(success);
        p.add(warn);
        p.add(danger);
        f.getContentPane().add(p);
        f.setVisible(true);
    }

    private void initComponents() {
        this.pnlContent = new JPanel();
        if (this.closeable) {
            this.closeButton = new JButton();
        }
        this.setMinimumSize(new Dimension(44, 50));
        this.setPreferredSize(new Dimension(36, 50));
        this.setLayout(new GridBagLayout());
        this.pnlContent.setOpaque(false);
        this.pnlContent.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlContent, gridBagConstraints);
        if (this.closeable) {
            this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/res/glyphicons_207_remove_2.png")));
            Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(AlertPanel.class, (String)"AlertPanel.closeButton.text"));
            this.closeButton.setBorderPainted(false);
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setFocusPainted(false);
            this.closeButton.setPreferredSize(new Dimension(16, 16));
        }
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlertPanel.this.closeButtonActionPerformed(evt);
            }
        });
        if (this.closeable) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            this.add((Component)this.closeButton, gridBagConstraints);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.fireCloseEvent(evt);
    }

    private static final class RoundedBorder
    extends AbstractBorder {
        private Color color;
        private int arc;
        private int thickness;

        public RoundedBorder(Color c, int arc, int thickness) {
            this.color = c;
            this.arc = arc;
            this.thickness = thickness;
        }

        public void setColor(Color g) {
            this.color = g;
        }

        public void setArc(int arc) {
            this.arc = arc;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.color);
            int offs = this.thickness;
            int size = offs + offs;
            RoundRectangle2D.Float outer = new RoundRectangle2D.Float(x, y, width, height, this.arc, this.arc);
            RoundRectangle2D.Float inner = new RoundRectangle2D.Float(x + offs, y + offs, width - size, height - size, this.arc, this.arc);
            Path2D.Float path = new Path2D.Float(0);
            path.append(outer, false);
            path.append(inner, false);
            g2.fill(path);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(this.thickness, this.thickness, this.thickness, this.thickness);
            return insets;
        }
    }

    public static enum TYPE {
        INFO,
        SUCCESS,
        WARNING,
        DANGER;

    }
}

