/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.slideabletree;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.slideabletree.DelegatingModel;
import de.cismet.tools.gui.slideabletree.SlideableSubTree;
import de.cismet.tools.gui.slideabletree.SubTreePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;

public class SlideableTree
extends JTree
implements TreeExpansionListener,
TreeSelectionListener,
TreeWillExpandListener {
    protected boolean useSlideableTreeView = false;
    private final Logger logger;
    private JXTaskPaneContainer container;
    private ArrayList<SlideableSubTree> trees;
    private ArrayList<SubTreePane> panes;
    private JScrollPane containerScrollPane;
    private JPanel panel;

    public SlideableTree() {
        this(false);
    }

    public SlideableTree(boolean useSlideableView) {
        this.useSlideableTreeView = useSlideableView;
        this.logger = Logger.getLogger(this.getClass());
        if (this.useSlideableTreeView) {
            this.trees = new ArrayList();
            this.panes = new ArrayList();
            this.container = new JXTaskPaneContainer();
            this.container.setBackgroundPainter(null);
            UIManager.getDefaults().put("TaskPane.titleBackgroundGradientStart", new Color(222, 222, 222));
            UIManager.getDefaults().put("TaskPane.titleBackgroundGradientEnd", new Color(244, 244, 244));
            this.setLayout(new BorderLayout());
            VerticalLayout verticalLayout = new VerticalLayout();
            verticalLayout.setGap(7);
            this.container.setLayout((LayoutManager)verticalLayout);
            this.container.setBorder((Border)new EmptyBorder(0, 5, 0, 5));
            this.container.setBackground(new Color(255, 255, 255));
            this.containerScrollPane = new JScrollPane((Component)this.container);
            StaticSwingTools.setNiftyScrollBars(this.containerScrollPane);
            this.createSubTrees(this.getModel());
            this.addToTreeContainer(this.panes);
            this.setDragEnabled(true);
            this.setEditable(false);
            this.add((Component)this.containerScrollPane, "Center");
        }
    }

    public SlideableTree(TreeModel model) {
        this(false);
        this.setModel(model);
    }

    public SlideableTree(TreeNode node) {
        this(new DefaultTreeModel(node));
    }

    public boolean isUseSlideableTreeView() {
        return this.useSlideableTreeView;
    }

    public JXTaskPaneContainer getContainer() {
        return this.container;
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                SlideableSubTree t = this.getSubTreeForPath(path);
                TreePath subTreePath = this.getPathForSubTree(path);
                t.addSelectionPath(path);
            }
        } else {
            super.addSelectionPath(path);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (int i = 0; i < paths.length; ++i) {
                    this.addSelectionPath(paths[i]);
                }
            }
            super.addSelectionPaths(paths);
        } else {
            super.addSelectionPaths(paths);
        }
    }

    @Override
    public void addSelectionRow(int row) {
        TreePath path = this.getPathForRow(row);
        this.addSelectionPath(path);
        super.addSelectionRow(row);
    }

    @Override
    public void addSelectionRows(int[] rows) {
        if (this.useSlideableTreeView) {
            for (int i = 0; i < rows.length; ++i) {
                this.addSelectionRow(rows[i]);
            }
            super.addSelectionRows(rows);
        } else {
            super.addSelectionRows(rows);
        }
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (this.useSlideableTreeView) {
            if (index1 < index0) {
                return;
            }
            for (int i = index0; i <= index1; ++i) {
                TreePath path = this.getPathForRow(i);
                this.addSelectionPath(path);
            }
        }
        super.addSelectionInterval(index0, index1);
    }

    @Override
    public void cancelEditing() {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.cancelEditing();
                }
            }
        } else {
            super.cancelEditing();
        }
    }

    @Override
    public void clearSelection() {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    this.panes.get(this.trees.indexOf(t)).setSelected(false);
                    t.clearSelection();
                }
            }
        } else {
            super.clearSelection();
        }
    }

    @Override
    protected void clearToggledPaths() {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.clearToggledPaths();
            }
        }
        super.clearToggledPaths();
    }

    @Override
    public void expandRow(int row) {
        if (this.useSlideableTreeView) {
            if (row < 0 || row > this.getRowCount()) {
                return;
            }
            if (this.trees != null && this.panes != null) {
                SlideableSubTree t = this.getSubTreeForRow(row);
                int index = this.trees.indexOf(t);
                SubTreePane pane = this.panes.get(index);
                pane.setCollapsed(false);
                TreePath subTreePath = this.getPathForSubTree(this.getPathForRow(row));
                t.expandPath(subTreePath);
            }
        } else {
            super.expandRow(row);
        }
    }

    @Override
    public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
        if (this.useSlideableTreeView) {
            Vector<TreePath> paths = new Vector<TreePath>();
            Object lastPathElement = parent.getLastPathComponent();
            Object origRoot = this.getModel().getRoot();
            if (this.trees != null) {
                if (lastPathElement.equals(origRoot)) {
                    for (SlideableSubTree t : this.trees) {
                        SubTreePane pane = this.panes.get(this.trees.indexOf(t));
                        if (pane.isCollapsed()) continue;
                        Object subTreeRoot = t.getModel().getRoot();
                        paths.add(this.getPathforOriginalTree(new TreePath(subTreeRoot)));
                    }
                } else {
                    SlideableSubTree subTree = this.getSubTreeForPath(parent);
                    Enumeration<TreePath> newPaths = subTree.getExpandedDescendants(this.getPathForSubTree(parent));
                    if (newPaths != null) {
                        while (newPaths.hasMoreElements()) {
                            paths.add(this.getPathforOriginalTree(newPaths.nextElement()));
                        }
                    }
                }
            }
            return paths.elements();
        }
        return super.getExpandedDescendants(parent);
    }

    @Override
    public TreePath getEditingPath() {
        if (this.useSlideableTreeView) {
            for (JTree jTree : this.trees) {
                TreePath path = jTree.getEditingPath();
                if (path == null) continue;
                return this.getPathforOriginalTree(path);
            }
        }
        return super.getEditingPath();
    }

    @Override
    public TreePath getPathForLocation(int x, int y) {
        if (this.useSlideableTreeView) {
            TreePath closestPath = this.getClosestPathForLocation(x, y);
            if (closestPath == null) {
                return null;
            }
            SubTreePane pane = this.panes.get(this.trees.indexOf(this.getSubTreeForPath(closestPath)));
            int paneX = pane.getX();
            int paneY = pane.getY();
            int titleBarHeight = pane.getHeight() - pane.getContentPane().getHeight();
            if (closestPath.getPathCount() == 2 && y >= paneY && y <= paneY + titleBarHeight) {
                return closestPath;
            }
            int treeX = this.getSubTreeForPath(closestPath).getX();
            int treeY = this.getSubTreeForPath(closestPath).getY();
            int newX = x - paneX - treeX;
            int newY = y - paneY - treeY - titleBarHeight;
            Rectangle r = this.getPathBounds(closestPath);
            double recX = 0.0;
            double recY = 0.0;
            double recWidth = 0.0;
            double recHeight = 0.0;
            if (r != null) {
                recX = r.getX();
                recY = r.getY();
                recWidth = r.getWidth();
                recHeight = r.getHeight();
            }
            if ((double)newX >= recX && (double)newX <= recX + recWidth && (double)newY >= recY && (double)newY <= recY + recHeight) {
                return closestPath;
            }
            return null;
        }
        return super.getPathForLocation(x, y);
    }

    @Override
    public TreePath getClosestPathForLocation(int x, int y) {
        if (this.useSlideableTreeView) {
            Component c;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("VisibleRect: " + this.getVisibleRect()));
                this.logger.debug((Object)("Tree X/Y von: " + this.getX() + "/" + this.getY()));
                this.logger.debug((Object)("Tree X/Y bis: " + this.getX() + this.getWidth() + "/" + this.getY() + this.getHeight()));
            }
            if ((c = this.container.getComponentAt(x, y)) instanceof SubTreePane) {
                int distanceToTree;
                int distanceToTitle;
                SubTreePane pane = (SubTreePane)((Object)c);
                SlideableSubTree t = this.trees.get(this.panes.indexOf((Object)pane));
                int titleBarHeight = pane.getHeight() - pane.getContentPane().getHeight();
                if (y <= titleBarHeight + pane.getY()) {
                    return this.getPathforOriginalTree(new TreePath(t.getModel().getRoot()));
                }
                if (y > titleBarHeight + pane.getY() && y < pane.getY() + titleBarHeight + t.getY() && (distanceToTitle = Math.abs(y - (titleBarHeight + pane.getY()))) < (distanceToTree = Math.abs(y - (pane.getY() + titleBarHeight + t.getY())))) {
                    return this.getPathforOriginalTree(new TreePath(t.getModel().getRoot()));
                }
                int newY = y - pane.getY() - t.getY() - titleBarHeight;
                int newX = x - pane.getX() - t.getX();
                TreePath subTreePath = t.getClosestPathForLocation(x, y);
                if (subTreePath == null) {
                    subTreePath = new TreePath(t.getModel().getRoot());
                }
                return this.getPathforOriginalTree(subTreePath);
            }
            if (c instanceof JXTaskPaneContainer) {
                SubTreePane closest = null;
                boolean lastComponent = false;
                for (SubTreePane p : this.panes) {
                    SubTreePane predecessor;
                    int distanceToPredecessor;
                    int paneY = p.getY();
                    if (y >= paneY) continue;
                    if (this.panes.indexOf((Object)p) == 0) {
                        closest = p;
                        lastComponent = false;
                        continue;
                    }
                    int distance = Math.abs(y - paneY);
                    if (distance <= (distanceToPredecessor = Math.abs(y - ((predecessor = this.panes.get(this.panes.indexOf((Object)p) - 1)).getY() + predecessor.getHeight())))) {
                        closest = p;
                        lastComponent = false;
                        continue;
                    }
                    closest = predecessor;
                    lastComponent = true;
                }
                if (closest == null) {
                    closest = this.panes.get(this.panes.size() - 1);
                    lastComponent = true;
                }
                SlideableSubTree t = this.trees.get(this.panes.indexOf((Object)closest));
                if (lastComponent) {
                    int newY = closest.getY() + closest.getHeight();
                    TreePath subTreePath = t.getClosestPathForLocation(0, newY);
                    if (subTreePath == null) {
                        subTreePath = new TreePath(t.getModel().getRoot());
                    }
                    return this.getPathforOriginalTree(subTreePath);
                }
                return this.getPathforOriginalTree(new TreePath(t.getModel().getRoot()));
            }
            return null;
        }
        return super.getClosestPathForLocation(x, y);
    }

    @Override
    protected Enumeration<TreePath> getDescendantToggledPaths(TreePath parent) {
        if (this.useSlideableTreeView) {
            Vector<TreePath> toggledPaths = new Vector<TreePath>();
            Object lastPathComponent = parent.getLastPathComponent();
            Object parentRoot = this.getModel().getRoot();
            if (this.trees != null) {
                if (!lastPathComponent.equals(parentRoot)) {
                    SlideableSubTree t = this.getSubTreeForPath(parent);
                    TreePath subTreePath = this.getPathForSubTree(parent);
                    Enumeration<TreePath> toggledSubPaths = t.getDescendantToggledPaths(subTreePath);
                    while (toggledSubPaths.hasMoreElements()) {
                        TreePath originPath = this.getPathforOriginalTree(toggledSubPaths.nextElement());
                        toggledPaths.add(this.getPathforOriginalTree(originPath));
                    }
                }
                return toggledPaths.elements();
            }
        }
        return super.getDescendantToggledPaths(parent);
    }

    @Override
    public int getMaxSelectionRow() {
        if (this.useSlideableTreeView && this.trees != null) {
            int offset = 0;
            boolean maxSelection = false;
            int indexOfTree = 0;
            int i = this.trees.size() - 1;
            if (i >= 0) {
                SlideableSubTree t = this.trees.get(i);
                indexOfTree = i;
            }
            for (i = 0; i < indexOfTree; ++i) {
                offset += this.trees.get(i).getRowCount() + 1;
            }
            return 0 + offset;
        }
        return super.getMaxSelectionRow();
    }

    @Override
    public int getMinSelectionRow() {
        if (this.useSlideableTreeView && this.trees != null) {
            SlideableSubTree t;
            int offset = 0;
            int minSelection = 0;
            boolean indexOfTree = false;
            Iterator<SlideableSubTree> iterator = this.trees.iterator();
            while (iterator.hasNext() && (minSelection = (t = iterator.next()).getMinSelectionRow()) == -1) {
                offset += t.getRowCount() + 1;
            }
            if (minSelection == -1) {
                return minSelection;
            }
            return minSelection + offset;
        }
        return super.getMinSelectionRow();
    }

    @Override
    public Rectangle getPathBounds(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                return super.getPathBounds(path);
            }
            Rectangle rec = t.getPathBounds(this.getPathForSubTree(path));
            SubTreePane pane = this.panes.get(this.trees.indexOf(t));
            rec.setLocation((int)rec.getX() + pane.getX(), (int)rec.getY() + pane.getY());
            return rec;
        }
        return super.getPathBounds(path);
    }

    @Override
    public int getRowCount() {
        if (this.useSlideableTreeView) {
            int sum = 0;
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    sum += t.getRowCount();
                    if (t.isRootVisible()) continue;
                    ++sum;
                }
            }
            return sum;
        }
        return super.getRowCount();
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    TreePath firstSelection = t.getSelectionPath();
                    if (firstSelection == null) continue;
                    return this.getPathforOriginalTree(firstSelection);
                }
            }
            return null;
        }
        return super.getSelectionPath();
    }

    @Override
    public TreePath[] getSelectionPaths() {
        if (this.useSlideableTreeView) {
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    TreePath[] selections = t.getSelectionPaths();
                    if (selections == null) continue;
                    for (int i = 0; i < selections.length; ++i) {
                        paths.add(this.getPathforOriginalTree(selections[i]));
                    }
                }
                if (paths.isEmpty()) {
                    return null;
                }
                TreePath[] path = new TreePath[paths.size()];
                paths.toArray(path);
                return path;
            }
            return null;
        }
        return super.getSelectionPaths();
    }

    @Override
    public int getSelectionCount() {
        if (this.useSlideableTreeView) {
            int sum = 0;
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    sum += t.getSelectionCount();
                }
                return sum;
            }
        }
        return super.getSelectionCount();
    }

    @Override
    public TreePath getPathForRow(int row) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForRow(row);
            int subTreeRow = this.getRowForSubTree(row);
            if (t != null) {
                if (subTreeRow < 0 && !t.isRootVisible()) {
                    return this.getPathforOriginalTree(new TreePath(t.getModel().getRoot()));
                }
                TreePath tmp = t.getPathForRow(subTreeRow);
                TreePath path = this.getPathforOriginalTree(tmp);
                return path;
            }
            return null;
        }
        return this.getPathForRow(row);
    }

    @Override
    public int getRowForPath(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree subTree = this.getSubTreeForPath(path);
            TreePath subPath = this.getPathForSubTree(path);
            int offset = 0;
            int row = -1;
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    if (t.equals(subTree)) break;
                    offset += t.getRowCount() + 1;
                }
                row = subTree.getRowForPath(subPath) + offset;
            }
            return row;
        }
        return super.getRowForPath(path);
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return super.getNextMatch(prefix, startingRow, bias);
    }

    @Override
    protected TreePath[] getPathBetweenRows(int index0, int index1) {
        if (this.useSlideableTreeView) {
            ArrayList<TreePath> list = new ArrayList<TreePath>();
            for (int i = index0 + 1; i <= index1; ++i) {
                list.add(this.getPathForRow(i));
            }
            TreePath[] finalPaths = new TreePath[list.size()];
            for (int i = 0; i < finalPaths.length; ++i) {
                finalPaths[i] = (TreePath)list.get(i);
            }
            return finalPaths;
        }
        return this.getPathBetweenRows(index0, index1);
    }

    @Override
    public boolean hasBeenExpanded(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                return super.hasBeenExpanded(path);
            }
            return t.hasBeenExpanded(this.getPathForSubTree(path));
        }
        return super.hasBeenExpanded(path);
    }

    @Override
    public boolean isEditing() {
        if (this.useSlideableTreeView) {
            boolean isEditing = false;
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    if (!t.isEditing()) continue;
                    isEditing = true;
                }
            }
            return isEditing;
        }
        return super.isEditable();
    }

    @Override
    public boolean isExpanded(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                return super.isExpanded(path);
            }
            return t.isExpanded(this.getPathForSubTree(path));
        }
        return super.isExpanded(path);
    }

    @Override
    public boolean isExpanded(int row) {
        if (this.useSlideableTreeView) {
            TreePath path = this.getPathForRow(row);
            return this.isExpanded(path);
        }
        return super.isExpanded(row);
    }

    @Override
    public boolean isPathSelected(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                return super.isPathSelected(path);
            }
            return t.isPathSelected(this.getPathForSubTree(path));
        }
        return super.isPathSelected(path);
    }

    @Override
    public boolean isRowSelected(int row) {
        if (this.useSlideableTreeView) {
            TreePath path = this.getPathForRow(row);
            if (path == null) {
                return false;
            }
            boolean isSelected = this.isPathSelected(path);
            return isSelected;
        }
        return super.isRowSelected(row);
    }

    @Override
    public boolean isSelectionEmpty() {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    if (t.isSelectionEmpty()) continue;
                    return false;
                }
            }
            return true;
        }
        return super.isSelectionEmpty();
    }

    @Override
    public boolean isVisible(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                return super.isVisible(path);
            }
            return t.isVisible(this.getPathForSubTree(path));
        }
        return super.isVisible();
    }

    @Override
    public void makeVisible(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                super.makeVisible(path);
            } else {
                t.makeVisible(this.getPathForSubTree(path));
            }
        } else {
            super.makeVisible(path);
        }
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                if (index1 < index0) {
                    return;
                }
                for (int i = index0; i <= index1; ++i) {
                    TreePath path = this.getPathForRow(i);
                    this.removeSelectionPath(path);
                }
                super.removeSelectionInterval(index0, index1);
            }
        } else {
            super.removeSelectionInterval(index0, index1);
        }
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (this.useSlideableTreeView && this.trees != null) {
            SlideableSubTree subTree = this.getSubTreeForPath(path);
            subTree.removeSelectionPath(this.getPathForSubTree(path));
        }
        super.removeSelectionPath(path);
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (this.useSlideableTreeView) {
            for (int i = 0; i < paths.length; ++i) {
                this.removeSelectionPath(paths[i]);
            }
        }
        super.removeSelectionPaths(paths);
    }

    @Override
    public void removeSelectionRow(int row) {
        if (this.useSlideableTreeView) {
            TreePath path = this.getPathForRow(row);
            this.removeSelectionPath(path);
        }
        super.removeSelectionRow(row);
    }

    @Override
    public void removeSelectionRows(int[] rows) {
        if (this.useSlideableTreeView) {
            for (int i = 0; i < rows.length; ++i) {
                TreePath path = this.getPathForRow(i);
                this.removeSelectionPath(path);
            }
        }
        super.removeSelectionRows(rows);
    }

    @Override
    protected boolean removeDescendantSelectedPaths(TreePath path, boolean includePath) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            TreePath subTreePath = this.getPathForSubTree(path);
            if (this.trees != null) {
                return t.removeDescendantSelectedPaths(subTreePath, includePath);
            }
            return super.removeDescendantSelectedPaths(path, includePath);
        }
        return super.removeDescendantSelectedPaths(path, includePath);
    }

    @Override
    protected void removeDescendantToggledPaths(Enumeration<TreePath> toRemove) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                while (toRemove.hasMoreElements()) {
                    TreePath path = toRemove.nextElement();
                    SlideableSubTree t = this.getSubTreeForPath(path);
                    Vector<TreePath> subToRemove = new Vector<TreePath>();
                    subToRemove.add(this.getPathForSubTree(path));
                    t.removeDescendantToggledPaths(subToRemove.elements());
                }
            } else {
                super.removeDescendantToggledPaths(toRemove);
            }
        } else {
            super.removeDescendantToggledPaths(toRemove);
        }
    }

    @Override
    public int[] getSelectionRows() {
        if (this.useSlideableTreeView) {
            int[][] result = new int[this.trees.size()][];
            int offset = 0;
            int count = 0;
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    result[this.trees.indexOf((Object)t)] = t.getSelectionRows();
                    count += result[this.trees.indexOf(t)].length;
                    int i = 0;
                    while (i < result[this.trees.indexOf(t)].length) {
                        int[] nArray = result[this.trees.indexOf(t)];
                        int n = i++;
                        nArray[n] = nArray[n] + offset;
                    }
                    offset += t.getRowCount() + 1;
                }
                int[] selectionRows = new int[count];
                for (int i = 0; i < selectionRows.length; ++i) {
                    for (int j = 0; j < result[i].length; ++j) {
                        selectionRows[i] = result[i][j];
                    }
                }
                return selectionRows;
            }
        }
        return super.getSelectionRows();
    }

    @Override
    public void scrollPathToVisible(final TreePath path) {
        if (this.useSlideableTreeView && this.trees != null) {
            if (path == null || path.getPathCount() <= 2) {
                return;
            }
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t != null) {
                final SubTreePane pane = this.panes.get(this.trees.indexOf(t));
                if (!pane.isSelected() && pane.isCollapsed()) {
                    PropertyChangeListener propChangedListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getNewValue().equals("expanded")) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TreePath tmpPath = path;
                                        Rectangle r = SlideableTree.this.getPathBounds(tmpPath);
                                        JViewport vp = SlideableTree.this.containerScrollPane.getViewport();
                                        if (r != null && r.getY() + (double)pane.getTitleBarHeight() > (double)vp.getHeight()) {
                                            double y = r.getY() + (double)pane.getTitleBarHeight();
                                            vp.setViewPosition(new Point(0, (int)y));
                                        }
                                    }
                                });
                                pane.removePropertyChangeListener(this);
                            }
                        }
                    };
                    pane.addPropertyChangeListener("animationState", propChangedListener);
                    pane.setCollapsed(false);
                    return;
                }
                Rectangle r = this.getPathBounds(path);
                JViewport vp = this.containerScrollPane.getViewport();
                if (r != null && r.getY() + (double)pane.getTitleBarHeight() > (double)vp.getHeight()) {
                    double y = r.getY() + (double)pane.getTitleBarHeight();
                    vp.setViewPosition(new Point(0, (int)y));
                }
                return;
            }
        }
        super.scrollPathToVisible(path);
    }

    @Override
    public void scrollRowToVisible(int row) {
        if (this.useSlideableTreeView) {
            TreePath path = this.getPathForRow(row);
            this.scrollPathToVisible(path);
        } else {
            super.scrollRowToVisible(row);
        }
    }

    @Override
    public void setAnchorSelectionPath(TreePath newPath) {
        if (this.useSlideableTreeView && this.trees != null) {
            SlideableSubTree t = this.getSubTreeForPath(newPath);
            TreePath subTreePath = this.getPathForSubTree(newPath);
            if (t != null) {
                t.setAnchorSelectionPath(subTreePath);
            }
        }
        super.setAnchorSelectionPath(newPath);
    }

    @Override
    public void setCellEditor(TreeCellEditor cellEditor) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setCellEditor(cellEditor);
            }
        }
        super.setCellEditor(cellEditor);
    }

    @Override
    public void setCellRenderer(TreeCellRenderer x) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setCellRenderer(x);
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)t.getModel().getRoot();
                SubTreePane pane = this.panes.get(this.trees.indexOf(t));
                if (!(x instanceof DefaultTreeCellRenderer)) continue;
                DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)t.getCellRenderer();
                JLabel l = (JLabel)renderer.getTreeCellRendererComponent(this, rootNode, false, !pane.isCollapsed(), rootNode.isLeaf(), 0, false);
                pane.setIcon(l.getIcon());
            }
        }
        super.setCellRenderer(x);
    }

    @Override
    public void setDragEnabled(boolean b) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setDragEnabled(b);
            }
        }
        super.setDragEnabled(b);
    }

    @Override
    public void setEditable(boolean flag) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setEditable(flag);
            }
        }
        super.setEditable(flag);
    }

    @Override
    public void setExpandsSelectedPaths(boolean newValue) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setExpandsSelectedPaths(newValue);
            }
        }
        super.setExpandsSelectedPaths(newValue);
    }

    @Override
    protected void setExpandedState(TreePath path, boolean state) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                SlideableSubTree t = this.getSubTreeForPath(path);
                TreePath subTreePath = this.getPathForSubTree(path);
                t.setExpandedState(subTreePath, state);
            }
        } else {
            super.setExpandedState(path, state);
        }
    }

    @Override
    public void setInvokesStopCellEditing(boolean newValue) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setInvokesStopCellEditing(newValue);
            }
        }
        super.setInvokesStopCellEditing(newValue);
    }

    @Override
    public void setLargeModel(boolean newValue) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setLargeModel(newValue);
                }
                super.setLargeModel(newValue);
            }
        } else {
            super.setLargeModel(newValue);
        }
    }

    @Override
    public void setLeadSelectionPath(TreePath newPath) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setLeadSelectionPath(newPath);
            }
        }
        super.setLeadSelectionPath(newPath);
    }

    @Override
    public void setModel(TreeModel newModel) {
        if (this.useSlideableTreeView) {
            TreeModel oldModel = this.getModel();
            this.treeModel = newModel;
            this.firePropertyChange("model", oldModel, newModel);
            if (this.trees != null) {
                this.createSubTrees(newModel);
                this.flushTreeContainer();
                this.addToTreeContainer(this.panes);
            }
        } else {
            super.setModel(newModel);
        }
    }

    @Override
    public void setRootVisible(boolean rootVisible) {
        if (this.useSlideableTreeView) {
            for (SlideableSubTree t : this.trees) {
                t.setRootVisible(rootVisible);
            }
        }
        super.setRootVisible(rootVisible);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setRowHeight(rowHeight);
                }
            } else {
                super.setRowHeight(rowHeight);
            }
        } else {
            super.setRowHeight(rowHeight);
        }
    }

    @Override
    public void setScrollsOnExpand(boolean newValue) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setScrollsOnExpand(newValue);
                }
            }
        } else {
            super.setScrollsOnExpand(newValue);
        }
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                ArrayList<TreePath> pathList = new ArrayList<TreePath>();
                if (index1 < index0) {
                    return;
                }
                for (int i = index0; i <= index1; ++i) {
                    TreePath path = this.getPathForRow(i);
                    pathList.add(path);
                }
                TreePath[] finalPaths = new TreePath[pathList.size()];
                for (int i = 0; i < finalPaths.length; ++i) {
                    finalPaths[i] = (TreePath)pathList.get(i);
                }
                this.setSelectionPaths(finalPaths);
            } else {
                super.setSelectionInterval(index0, index1);
            }
        } else {
            super.setSelectionInterval(index0, index1);
        }
    }

    @Override
    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setSelectionModel(selectionModel);
                }
            } else {
                super.setSelectionModel(selectionModel);
            }
        } else {
            super.setSelectionModel(selectionModel);
        }
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                SlideableSubTree t = this.getSubTreeForPath(path);
                for (JTree jTree : this.trees) {
                    if (t.equals(jTree)) continue;
                    jTree.clearSelection();
                }
                if (t != null) {
                    t.setSelectionPath(this.getPathForSubTree(path));
                }
            }
        } else {
            super.setSelectionPath(path);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] paths) {
        if (this.useSlideableTreeView) {
            for (int i = 0; i < paths.length; ++i) {
                this.setSelectionPath(paths[i]);
            }
        } else {
            super.setSelectionPaths(paths);
        }
    }

    @Override
    public void setSelectionRow(int row) {
        if (this.useSlideableTreeView) {
            TreePath path = this.getPathForRow(row);
            SlideableSubTree subTree = this.getSubTreeForPath(path);
            subTree.setSelectionPath(this.getPathForSubTree(path));
        } else {
            super.setSelectionRow(row);
        }
    }

    @Override
    public void setSelectionRows(int[] rows) {
        if (this.useSlideableTreeView) {
            for (int i = 0; i < rows.length; ++i) {
                TreePath path = this.getPathForRow(rows[i]);
                SlideableSubTree subTree = this.getSubTreeForPath(path);
                subTree.setSelectionPath(this.getPathForSubTree(path));
            }
        } else {
            super.setSelectionRows(rows);
        }
    }

    @Override
    public void setShowsRootHandles(boolean newValue) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setShowsRootHandles(newValue);
                }
            } else {
                super.setShowsRootHandles(newValue);
            }
        } else {
            super.setShowsRootHandles(newValue);
        }
    }

    @Override
    public void setToggleClickCount(int clickCount) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setToggleClickCount(clickCount);
                }
            } else {
                super.setToggleClickCount(clickCount);
            }
        } else {
            super.setToggleClickCount(clickCount);
        }
    }

    @Override
    public void setUI(TreeUI ui) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    t.setUI(ui);
                }
            } else {
                super.setUI(ui);
            }
        } else {
            super.setUI(ui);
        }
    }

    @Override
    public void setVisibleRowCount(int newCount) {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.setVisibleRowCount(newCount);
            }
        }
        super.setVisibleRowCount(newCount);
    }

    @Override
    public void startEditingAtPath(TreePath path) {
        if (this.useSlideableTreeView) {
            SlideableSubTree t = this.getSubTreeForPath(path);
            if (t == null) {
                super.startEditingAtPath(path);
            } else {
                t.startEditingAtPath(this.getPathForSubTree(path));
            }
        } else {
            super.startEditingAtPath(path);
        }
    }

    @Override
    public boolean stopEditing() {
        if (this.useSlideableTreeView) {
            boolean stopped = false;
            if (this.trees != null) {
                for (SlideableSubTree t : this.trees) {
                    if (!t.stopEditing()) continue;
                    stopped = true;
                }
            } else {
                return super.stopEditing();
            }
            return stopped;
        }
        return super.stopEditing();
    }

    @Override
    public void updateUI() {
        if (this.useSlideableTreeView && this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                t.updateUI();
            }
        }
        super.updateUI();
    }

    private void createSubTrees(TreeModel model) {
        TreeModelListener listener = this.createTreeModelListener();
        this.treeModel.addTreeModelListener(listener);
        this.flushTreeContainer();
        this.trees = new ArrayList();
        this.panes = new ArrayList();
        Object root = this.getModel().getRoot();
        int childCount = this.getModel().getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChild(root, i);
            this.createTreeNode(child);
            this.addToTreeContainer(this.panes);
        }
    }

    private void createTreeNode(Object node) {
        DefaultMutableTreeNode newRootNode = new DefaultMutableTreeNode(node);
        SlideableSubTree subTree = new SlideableSubTree(newRootNode, true);
        DelegatingModel modelDelegate = new DelegatingModel(node, this.getModel());
        subTree.setModel(modelDelegate);
        subTree.setEditable(false);
        subTree.setRootVisible(false);
        subTree.addTreeExpansionListener(this);
        subTree.addTreeSelectionListener(this);
        subTree.addTreeWillExpandListener(this);
        subTree.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.trees.add(subTree);
        SubTreePane tmpPane = new SubTreePane();
        tmpPane.setCollapsed(true);
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)subTree.getModel().getRoot();
        TreeCellRenderer treeCellRenderer = subTree.getCellRenderer();
        JLabel l = (JLabel)treeCellRenderer.getTreeCellRendererComponent(this, (DefaultMutableTreeNode)subTree.getModel().getRoot(), false, tmpPane.isCollapsed(), false, 0, false);
        tmpPane.setIcon(l.getIcon());
        Border border = BorderFactory.createLineBorder(new Color(234, 234, 234));
        ((JComponent)tmpPane.getContentPane()).setBorder(border);
        tmpPane.getContentPane().setBackground(Color.white);
        tmpPane.setTitle(((Object)newRootNode).toString());
        tmpPane.addMouseListener(new ClickAndSelectListener());
        tmpPane.add(subTree);
        this.panes.add(tmpPane);
    }

    private void flushTreeContainer() {
        if (this.container != null) {
            this.container.removeAll();
        }
    }

    private void addToTreeContainer(ArrayList<SubTreePane> list) {
        for (SubTreePane p : list) {
            p.setCollapsed(true);
            this.container.add((JXTaskPane)p);
        }
    }

    private SlideableSubTree getSubTreeForPath(TreePath path) {
        if (path == null) {
            return null;
        }
        Object pathRoot = path.getPathComponent(0);
        if (path.getPathCount() <= 1) {
            return null;
        }
        Object pathSubRoot = path.getPathComponent(1);
        if (this.trees != null) {
            for (JTree jTree : this.trees) {
                Object subTreeRoot = jTree.getModel().getRoot();
                if (!pathSubRoot.equals(subTreeRoot)) continue;
                return (SlideableSubTree)jTree;
            }
        }
        return null;
    }

    protected TreePath getPathforOriginalTree(TreePath subTreePath) {
        Object origRoot;
        Object pathRoot = subTreePath.getPathComponent(0);
        if (pathRoot.equals(origRoot = this.getModel().getRoot())) {
            return subTreePath;
        }
        Object[] oldPath = subTreePath.getPath();
        Object[] newPath = new Object[oldPath.length + 1];
        newPath[0] = origRoot;
        System.arraycopy(oldPath, 0, newPath, 1, oldPath.length);
        return new TreePath(newPath);
    }

    private TreePath getPathForSubTree(TreePath originPath) {
        Object originRoot;
        Object pathRoot = originPath.getPathComponent(0);
        if (!pathRoot.equals(originRoot = this.getModel().getRoot())) {
            return null;
        }
        if (originPath.getPathCount() <= 1) {
            return null;
        }
        Object[] oldPath = originPath.getPath();
        Object[] newPath = new Object[oldPath.length - 1];
        System.arraycopy(oldPath, 1, newPath, 0, newPath.length);
        return new TreePath(newPath);
    }

    private SlideableSubTree getSubTreeForRow(int row) {
        int sum = 0;
        if (this.trees != null) {
            for (SlideableSubTree t : this.trees) {
                sum += t.getRowCount();
                if (!t.isRootVisible()) {
                    ++sum;
                }
                if (sum <= row) continue;
                return t;
            }
        }
        return null;
    }

    private int getRowForSubTree(int originRow) {
        SlideableSubTree tmpTree = this.getSubTreeForRow(originRow);
        int offset = 1;
        if (tmpTree != null) {
            for (SlideableSubTree t : this.trees) {
                if (t.equals(tmpTree)) break;
                offset += t.getRowCount();
                if (t.isRootVisible()) continue;
                ++offset;
            }
        }
        return originRow - offset;
    }

    @Override
    public Object getLastSelectedPathComponent() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            return path.getLastPathComponent();
        }
        return null;
    }

    @Override
    public void addTreeExpansionListener(TreeExpansionListener tel) {
        super.addTreeExpansionListener(tel);
    }

    @Override
    public void fireTreeExpanded(TreePath path) {
        if (this.useSlideableTreeView) {
            TreeExpansionListener[] listener = this.getTreeExpansionListeners();
            for (int i = 0; i < listener.length; ++i) {
                listener[i].treeExpanded(new TreeExpansionEvent(this, path));
            }
        } else {
            super.fireTreeExpanded(path);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.fireTreeExpanded(this.getPathforOriginalTree(event.getPath()));
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.fireTreeCollapsed(this.getPathforOriginalTree(event.getPath()));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.useSlideableTreeView && this.trees != null) {
            TreePath path = this.getPathforOriginalTree(e.getPath());
            if (e.isAddedPath()) {
                for (JTree jTree : this.trees) {
                    SubTreePane pane = this.panes.get(this.trees.indexOf(jTree));
                    pane.setSelected(false);
                    if (jTree.equals((SlideableSubTree)e.getSource())) continue;
                    jTree.clearSelection();
                }
            }
            this.fireValueChanged(e);
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        this.fireTreeWillExpand(this.getPathforOriginalTree(event.getPath()));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        this.fireTreeWillCollapse(this.getPathforOriginalTree(event.getPath()));
    }

    @Override
    public TreeModelListener createTreeModelListener() {
        if (this.useSlideableTreeView) {
            return new MyTreeModelHandler(this);
        }
        return super.createTreeModelListener();
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.useSlideableTreeView) {
            if (this.trees != null) {
                for (JTree jTree : this.trees) {
                    jTree.addMouseListener(l);
                    this.panes.get(this.trees.indexOf(jTree)).addMouseListener(l);
                }
            }
        } else {
            super.addMouseListener(l);
        }
    }

    public ArrayList<SlideableSubTree> getTrees() {
        return this.trees;
    }

    public ArrayList<SubTreePane> getPanes() {
        return this.panes;
    }

    protected class ClickAndSelectListener
    extends MouseAdapter {
        protected ClickAndSelectListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SubTreePane pane = (SubTreePane)((Object)e.getSource());
            if (e.getX() < pane.getWidth() && e.getY() < pane.getTitleBarHeight() && !e.isPopupTrigger()) {
                SlideableSubTree t = (SlideableSubTree)SlideableTree.this.trees.get(SlideableTree.this.panes.indexOf((Object)pane));
                TreePath path = SlideableTree.this.getPathforOriginalTree(new TreePath(t.getModel().getRoot()));
                SlideableTree.this.clearSelection();
                SlideableTree.this.setSelectionPath(path);
                TreeCellRenderer cellRenderer = t.getCellRenderer();
                JLabel l = (JLabel)cellRenderer.getTreeCellRendererComponent(SlideableTree.this, (DefaultMutableTreeNode)t.getModel().getRoot(), false, pane.isCollapsed(), false, 0, false);
                pane.setIcon(l.getIcon());
                if (!pane.isCollapsed()) {
                    pane.setSelected(false);
                    SlideableTree.this.fireTreeCollapsed(path);
                } else {
                    pane.setSelected(true);
                    SlideableTree.this.fireTreeExpanded(path);
                }
            }
        }
    }

    protected class MyTreeModelHandler
    implements TreeModelListener {
        private SlideableTree tree;

        public MyTreeModelHandler() {
        }

        public MyTreeModelHandler(SlideableTree t) {
            this.tree = t;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (SlideableTree.this.useSlideableTreeView) {
                SlideableSubTree t = SlideableTree.this.getSubTreeForPath(e.getTreePath());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                this.tree.scrollPathToVisible(e.getTreePath());
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (SlideableTree.this.useSlideableTreeView) {
                SlideableSubTree t = SlideableTree.this.getSubTreeForPath(e.getTreePath());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                this.tree.scrollPathToVisible(e.getTreePath());
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (SlideableTree.this.useSlideableTreeView) {
                final SlideableSubTree t = SlideableTree.this.getSubTreeForPath(e.getTreePath());
                if (t == null) {
                    if (this.tree.getModel().getRoot().equals(e.getTreePath().getLastPathComponent())) {
                        int i;
                        DefaultMutableTreeNode treeRoot = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
                        int childCount = treeRoot.getChildCount();
                        if (childCount < SlideableTree.this.panes.size()) {
                            int treesToRemove = SlideableTree.this.panes.size() - childCount;
                            for (i = 0; i < treesToRemove; ++i) {
                                SlideableTree.this.trees.remove(SlideableTree.this.trees.size() - 1 - i);
                                SlideableTree.this.panes.remove(SlideableTree.this.panes.size() - 1 - i);
                            }
                        } else if (childCount > SlideableTree.this.panes.size()) {
                            int treesToAdd = childCount - SlideableTree.this.panes.size();
                            for (i = 0; i < treesToAdd; ++i) {
                                SlideableTree.this.createTreeNode(treeRoot.getChildAt(childCount - 1 - i));
                            }
                        }
                        for (int i2 = 0; i2 < treeRoot.getChildCount(); ++i2) {
                            TreeNode subRoot;
                            TreeNode child = treeRoot.getChildAt(i2);
                            SlideableSubTree subTree = (SlideableSubTree)SlideableTree.this.trees.get(i2);
                            if (subTree == null || (subRoot = (TreeNode)subTree.getModel().getRoot()).equals(child)) continue;
                            SubTreePane pane = (SubTreePane)((Object)SlideableTree.this.panes.get(i2));
                            pane.setTitle(child.toString());
                            pane.removeAll();
                            DelegatingModel newModel = new DelegatingModel(child, this.tree.getModel());
                            subTree.setModel(newModel);
                            pane.add(subTree);
                        }
                        this.tree.flushTreeContainer();
                        this.tree.addToTreeContainer(SlideableTree.this.panes);
                        this.tree.updateUI();
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            t.updateUI();
                        }
                    });
                    this.tree.scrollPathToVisible(e.getTreePath());
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (SlideableTree.this.useSlideableTreeView) {
                SlideableSubTree t = SlideableTree.this.getSubTreeForPath(e.getTreePath());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                this.tree.scrollPathToVisible(e.getTreePath());
            }
        }
    }
}

