/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.startup;

import com.jhlabs.image.BoxBlurFilter;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.Painter;

public class StaticStartupTools {
    private static final transient Logger log = Logger.getLogger(StaticStartupTools.class);

    public static void saveScreenshotOfFrame(JFrame frame, String file) throws Exception {
        try {
            BufferedImage bi;
            boolean isUnix;
            if (!EventQueue.isDispatchThread()) {
                log.fatal((Object)"not in EDT");
            }
            GraphicsConfiguration configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            String OS = System.getProperty("os.name").toLowerCase();
            boolean bl = isUnix = OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") >= 0;
            if (isUnix) {
                Insets insets = frame.getInsets();
                int x = new Double(frame.getBounds().getX()).intValue() + insets.left;
                int y = new Double(frame.getBounds().getY()).intValue() + insets.top;
                int width = frame.getWidth() - insets.right;
                int h = frame.getHeight() - insets.top - insets.bottom;
                Rectangle screenRect = new Rectangle(x, y, width, h);
                bi = new Robot().createScreenCapture(screenRect);
            } else {
                bi = configuration.createCompatibleImage(frame.getWidth(), frame.getHeight(), 3);
                Graphics g = bi.getGraphics();
                frame.paintAll(g);
                g.dispose();
            }
            BoxBlurFilter blurFilter = new BoxBlurFilter();
            blurFilter.setRadius(1);
            blurFilter.filter(bi, bi);
            ImageIO.write((RenderedImage)bi, "png", new File(file + ".png"));
            File boundsFile = new File(file + ".bounds");
            boundsFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(boundsFile));
            writer.write(Integer.toString(new Double(frame.getBounds().getX()).intValue()) + "\n");
            writer.write(Integer.toString(new Double(frame.getBounds().getY()).intValue()) + "\n");
            writer.write(Integer.toString(new Double(frame.getBounds().getWidth()).intValue()) + "\n");
            writer.write(Integer.toString(new Double(frame.getBounds().getHeight()).intValue()) + "\n");
            writer.close();
        }
        catch (Exception e) {
            log.error((Object)"cannot save screenshot", (Throwable)e);
        }
    }

    public static JFrame showGhostFrame(String file, String title) throws Exception {
        File boundsFile = new File(file + ".bounds");
        if (boundsFile.exists()) {
            Rectangle rectangle = null;
            BufferedReader reader = new BufferedReader(new FileReader(boundsFile));
            String x = reader.readLine();
            String y = reader.readLine();
            String width = reader.readLine();
            String height = reader.readLine();
            reader.close();
            rectangle = new Rectangle();
            rectangle.setBounds(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height));
            ImageIcon i = new ImageIcon(file + ".png");
            BufferedImage bi = (BufferedImage)Static2DTools.removeUnusedBorder((Image)i.getImage(), (int)0, (double)1.0);
            JFrame fake = new JFrame(title);
            if (rectangle != null) {
                fake.setBounds(rectangle);
            }
            return StaticStartupTools.showGhostFrameInternal(fake, bi);
        }
        File imageFile = new File(file + ".png");
        return StaticStartupTools.showCustomGhostFrame(imageFile.toURI().toURL(), title);
    }

    public static JFrame showCustomGhostFrame(URL file, String title) throws Exception {
        ImageIcon i = new ImageIcon(file);
        BufferedImage bi = (BufferedImage)Static2DTools.removeUnusedBorder((Image)i.getImage(), (int)0, (double)1.0);
        JFrame fake = new JFrame(title);
        fake.setSize(bi.getWidth(), bi.getHeight());
        Rectangle r = StaticSwingTools.getCenterBoundsForComponent(fake);
        fake.setBounds(r);
        return StaticStartupTools.showGhostFrameInternal(fake, bi);
    }

    private static JFrame showGhostFrameInternal(JFrame frame, BufferedImage bufferedImage) {
        JXBusyLabel busy = new JXBusyLabel(new Dimension(100, 100));
        GlossPainter gp = new GlossPainter((Paint)new Color(255, 255, 255, 25), GlossPainter.GlossPosition.TOP);
        ImagePainter ip = new ImagePainter(bufferedImage);
        JXPanel p = new JXPanel();
        p.setAlpha(0.5f);
        p.setLayout((LayoutManager)new BorderLayout());
        p.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{ip, gp}));
        frame.getContentPane().add((Component)p, "Center");
        busy.setDelay(100);
        busy.setOpaque(false);
        busy.setBusy(true);
        busy.setHorizontalAlignment(0);
        p.add((Component)busy, (Object)"Center");
        frame.setVisible(true);
        return frame;
    }

    public static void main(String[] args) throws Exception {
        JFrame f = StaticStartupTools.showGhostFrame("/Users/thorsten/.verdis/verdis.screen", "xxx");
        f.setDefaultCloseOperation(3);
    }
}

