/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.treetable;

import de.cismet.tools.gui.treetable.JTreeTable;
import de.cismet.tools.gui.treetable.TreeTableModel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class TreeTableCellEditor
extends DefaultCellEditor {
    private final JTreeTable treeTable;
    private final JTree tree;

    public TreeTableCellEditor(JTreeTable treeTable, JTree tree) {
        super(new TreeTableTextField());
        if (treeTable == null) {
            throw new IllegalArgumentException("null treeTable");
        }
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        this.treeTable = treeTable;
        this.tree = tree;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        Rectangle bounds = this.tree.getRowBounds(row);
        int offset = bounds.x;
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            Object node = this.tree.getPathForRow(row).getLastPathComponent();
            Icon icon = this.tree.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (this.tree.isExpanded(row) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
            if (icon != null) {
                offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
            }
        }
        ((TreeTableTextField)this.getComponent()).offset = offset;
        return component;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (e instanceof MouseEvent) {
            for (int counter = this.treeTable.getColumnCount() - 1; counter >= 0; --counter) {
                if (this.treeTable.getColumnClass(counter) != TreeTableModel.class) continue;
                if (((MouseEvent)e).getClickCount() >= this.clickCountToStart) {
                    return true;
                }
                MouseEvent me = (MouseEvent)e;
                MouseEvent newME = new MouseEvent(this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - this.treeTable.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                this.tree.dispatchEvent(newME);
                return false;
            }
            return ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
        }
        return false;
    }

    static class TreeTableTextField
    extends JTextField {
        int offset;

        TreeTableTextField() {
        }

        @Override
        public void reshape(int x, int y, int width, int height) {
            int newOffset = this.offset - this.getInsets().left;
            super.reshape(x + newOffset, y, width - newOffset, height);
        }
    }
}

