/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui.treetable;

import de.cismet.tools.gui.treetable.FileSystemModel2;
import de.cismet.tools.gui.treetable.JTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;

public class TreeTableExample2 {
    protected static int ttCount;
    protected FileSystemModel2 model;
    protected JTreeTable treeTable;
    protected int reloadRow;
    protected TreePath reloadPath;
    protected int reloadCounter;
    protected Timer timer;
    protected JLabel statusLabel;
    protected JFrame frame;
    protected String path;

    public TreeTableExample2(String path) {
        this.path = path;
        ++ttCount;
        this.frame = this.createFrame();
        Container cPane = this.frame.getContentPane();
        JMenuBar mb = this.createMenuBar();
        this.model = this.createModel(path);
        this.treeTable = this.createTreeTable();
        this.statusLabel = this.createStatusLabel();
        cPane.add(new JScrollPane(this.treeTable));
        cPane.add((Component)this.statusLabel, "South");
        this.reloadRow = -1;
        this.frame.setJMenuBar(mb);
        this.frame.pack();
        this.frame.show();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableExample2.this.reload(TreeTableExample2.this.model.getRoot());
            }
        });
    }

    protected JLabel createStatusLabel() {
        JLabel retLabel = new JLabel(" ");
        retLabel.setHorizontalAlignment(4);
        retLabel.setBorder(new BevelBorder(1));
        return retLabel;
    }

    protected JTreeTable createTreeTable() {
        JTreeTable treeTable = new JTreeTable(this.model);
        treeTable.getColumnModel().getColumn(1).setCellRenderer(new IndicatorRenderer());
        Reloader rl = new Reloader();
        this.timer = new Timer(700, rl);
        this.timer.setRepeats(true);
        treeTable.getTree().addTreeExpansionListener(rl);
        return treeTable;
    }

    protected FileSystemModel2 createModel(String path) {
        return new FileSystemModel2(path);
    }

    protected JFrame createFrame() {
        JFrame retFrame = new JFrame(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createFrame().retFrame.title"));
        retFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (--ttCount == 0) {
                    System.exit(0);
                }
            }
        });
        return retFrame;
    }

    protected JMenuBar createMenuBar() {
        JMenu fileMenu = new JMenu(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createMenuBar().fileMenu.title"));
        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createMenuBar().menuItem.text.open"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser fc = new JFileChooser(TreeTableExample2.this.path);
                fc.setFileSelectionMode(1);
                int result = fc.showOpenDialog(TreeTableExample2.this.frame);
                if (result == 0) {
                    String newPath = fc.getSelectedFile().getPath();
                    new TreeTableExample2(newPath);
                }
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createMenuBar().menuItem.text.reload"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreePath path = TreeTableExample2.this.treeTable.getTree().getSelectionPath();
                if (path != null) {
                    TreeTableExample2.this.model.stopLoading();
                    TreeTableExample2.this.reload(path.getLastPathComponent());
                }
            }
        });
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createMenuBar().menuItem.text.stop"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TreeTableExample2.this.model.stopLoading();
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createMenuBar().menuItem.text.exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
        fileMenu.add(menuItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        ButtonGroup lafGroup = new ButtonGroup();
        JMenu optionsMenu = new JMenu(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.createMenuBar().optionsMenu.title"));
        menuBar.add(optionsMenu);
        for (int i = 0; i < lafs.length; ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(lafs[i].getName());
            optionsMenu.add(rb);
            rb.setSelected(UIManager.getLookAndFeel().getName().equals(lafs[i].getName()));
            rb.putClientProperty("UIKey", lafs[i]);
            rb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ae) {
                    JRadioButtonMenuItem rb2 = (JRadioButtonMenuItem)ae.getSource();
                    if (rb2.isSelected()) {
                        UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)rb2.getClientProperty("UIKey");
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                            SwingUtilities.updateComponentTreeUI(TreeTableExample2.this.frame);
                        }
                        catch (Exception e) {
                            System.err.println("unable to set UI " + e.getMessage());
                        }
                    }
                }
            });
            lafGroup.add(rb);
        }
        return menuBar;
    }

    protected void reload(Object node) {
        this.model.reloadChildren(node);
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    protected void updateStatusLabel() {
        if (this.reloadPath != null) {
            this.statusLabel.setText(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.statusLabel.text.reload", (Object)this.model.getPath(this.reloadPath.getLastPathComponent())));
            if (this.reloadCounter % 4 < 2) {
                this.statusLabel.setForeground(Color.red);
            } else {
                this.statusLabel.setForeground(Color.blue);
            }
        } else if (!this.model.isReloading()) {
            this.statusLabel.setText(NbBundle.getMessage(TreeTableExample2.class, (String)"TreeTableExample2.statusLabel.text.default", (Object)NumberFormat.getInstance().format(this.model.getTotalSize(this.model.getRoot()))));
            this.statusLabel.setForeground(Color.black);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (int counter = args.length - 1; counter >= 0; --counter) {
                new TreeTableExample2(args[counter]);
            }
        } else {
            String path;
            try {
                path = System.getProperty("user.home");
                if (path != null) {
                    new TreeTableExample2(path);
                }
            }
            catch (SecurityException se) {
                path = null;
            }
            if (path == null) {
                System.out.println("Could not determine home directory");
            }
        }
    }

    class IndicatorRenderer
    extends DefaultTableCellRenderer {
        protected NumberFormat formatter;
        protected int lastRow;

        IndicatorRenderer() {
            this.setHorizontalAlignment(4);
            this.formatter = NumberFormat.getInstance();
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "---" : this.formatter.format(value));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.lastRow = row;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            if (this.lastRow == TreeTableExample2.this.reloadRow) {
                int width = this.getWidth();
                int height = this.getHeight();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
                g.setColor(this.getForeground());
                int diameter = Math.min(width, height);
                if (TreeTableExample2.this.reloadCounter < 5) {
                    g.fillArc((width - diameter) / 2, (height - diameter) / 2, diameter, diameter, 90, -(TreeTableExample2.this.reloadCounter * 90));
                } else {
                    g.fillArc((width - diameter) / 2, (height - diameter) / 2, diameter, diameter, 90, (4 - TreeTableExample2.this.reloadCounter % 4) * 90);
                }
            } else {
                super.paint(g);
            }
        }
    }

    class Reloader
    implements ActionListener,
    TreeExpansionListener {
        Reloader() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!TreeTableExample2.this.model.isReloading()) {
                TreeTableExample2.this.timer.stop();
                if (TreeTableExample2.this.reloadRow != -1) {
                    this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                }
                TreeTableExample2.this.reloadRow = -1;
                TreeTableExample2.this.reloadPath = null;
            } else {
                TreePath newPath = TreeTableExample2.this.model.getPathLoading();
                if (newPath == null) {
                    if (TreeTableExample2.this.reloadRow != -1) {
                        this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                    }
                    TreeTableExample2.this.reloadRow = -1;
                    TreeTableExample2.this.reloadPath = null;
                } else {
                    int newRow = TreeTableExample2.this.treeTable.getTree().getRowForPath(newPath);
                    if (newPath.equals(TreeTableExample2.this.reloadPath)) {
                        TreeTableExample2.this.reloadCounter = (TreeTableExample2.this.reloadCounter + 1) % 8;
                        if (newRow != TreeTableExample2.this.reloadRow) {
                            int lastRow = TreeTableExample2.this.reloadRow;
                            TreeTableExample2.this.reloadRow = newRow;
                            this.generateChangeEvent(lastRow);
                        }
                        this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                    } else {
                        int lastRow = TreeTableExample2.this.reloadRow;
                        TreeTableExample2.this.reloadCounter = 0;
                        TreeTableExample2.this.reloadRow = newRow;
                        TreeTableExample2.this.reloadPath = newPath;
                        if (lastRow != TreeTableExample2.this.reloadRow) {
                            this.generateChangeEvent(lastRow);
                        }
                        this.generateChangeEvent(TreeTableExample2.this.reloadRow);
                    }
                }
            }
            TreeTableExample2.this.updateStatusLabel();
        }

        protected void generateChangeEvent(int row) {
            if (row != -1) {
                AbstractTableModel tModel = (AbstractTableModel)TreeTableExample2.this.treeTable.getModel();
                tModel.fireTableChanged(new TableModelEvent(tModel, row, row, 1));
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent te) {
            this.updateRow();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent te) {
            this.updateRow();
        }

        protected void updateRow() {
            TreeTableExample2.this.reloadPath = TreeTableExample2.this.model.getPathLoading();
            if (TreeTableExample2.this.reloadPath != null) {
                TreeTableExample2.this.reloadRow = TreeTableExample2.this.treeTable.getTree().getRowForPath(TreeTableExample2.this.reloadPath);
            }
        }
    }
}

