/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.commons.gui.progress;

import java.awt.EventQueue;

import javax.swing.JPanel;

/**
 * Simple panel that displays an animated busy label as long as it is busy. Additionally it can display a status
 * message.
 *
 * @author   mscholl
 * @version  1.0
 */
public class BusyStatusPanel extends JPanel {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private final transient javax.swing.JPanel jPanel1 = new javax.swing.JPanel();
    private final transient org.jdesktop.swingx.JXBusyLabel lblProgress = new org.jdesktop.swingx.JXBusyLabel();
    private final transient javax.swing.JLabel lblStatusMsg = new javax.swing.JLabel();
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new BusyStatusPanel object.
     */
    public BusyStatusPanel() {
        this(null);
    }

    /**
     * Creates new form TimeSeriesImportFileChoosePanel.
     *
     * @param  name  name of the component
     */
    public BusyStatusPanel(final String name) {
        initComponents();

        setName(name);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getStatusMessage() {
        return lblStatusMsg.getText();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  statusMsg  DOCUMENT ME!
     */
    public void setStatusMessage(final String statusMsg) {
        if (EventQueue.isDispatchThread()) {
            this.lblStatusMsg.setText(statusMsg);
        } else {
            EventQueue.invokeLater(new Runnable() {

                    @Override
                    public void run() {
                        BusyStatusPanel.this.lblStatusMsg.setText(statusMsg);
                    }
                });
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isBusy() {
        return lblProgress.isBusy();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  isBusy  DOCUMENT ME!
     */
    public void setBusy(final boolean isBusy) {
        if (EventQueue.isDispatchThread()) {
            this.lblProgress.setBusy(isBusy);
            this.lblProgress.setVisible(isBusy);
        } else {
            EventQueue.invokeLater(new Runnable() {

                    @Override
                    public void run() {
                        BusyStatusPanel.this.lblProgress.setBusy(isBusy);
                        BusyStatusPanel.this.lblProgress.setVisible(isBusy);
                    }
                });
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        lblProgress.setText(org.openide.util.NbBundle.getMessage(
                BusyStatusPanel.class,
                "BusyStatusPanel.lblProgress.text")); // NOI18N
        jPanel1.add(lblProgress, new java.awt.GridBagConstraints());

        lblStatusMsg.setFont(new java.awt.Font("DejaVu Sans", 1, 13)); // NOI18N
        lblStatusMsg.setText(org.openide.util.NbBundle.getMessage(
                BusyStatusPanel.class,
                "BusyStatusPanel.lblStatusMsg.text"));                 // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 8);
        jPanel1.add(lblStatusMsg, gridBagConstraints);

        add(jPanel1, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents
}
