/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.lookupoptions.options;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.lookup.ServiceProvider;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.security.PrivacyClientHandler;

import de.cismet.tools.configuration.NoWriteError;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class PrivacyOptionsPanel extends AbstractOptionsPanel implements OptionsPanelController {

    //~ Static fields/initializers ---------------------------------------------

    private static final transient Logger LOG = Logger.getLogger(PrivacyOptionsPanel.class);

    private static final String OPTION_NAME = org.openide.util.NbBundle.getMessage(
            PrivacyOptionsPanel.class,
            "PrivacyOptionsPanel.OptionController.name"); // NOI18N
    private static final String XML_CONF_ROOT = "privacy";
    private static final String XML_CONF_SEND_UNCAUGHT_EXCEPTIONS = "sendUncaughtExceptions";

    // Variables declaration - do not modify
    // NOI18N

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbSendUncaughtClientExceptions;
    private javax.swing.Box.Filler filler1;
    private javax.swing.Box.Filler filler2;
    private javax.swing.JPanel jPanel3;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form ProxyOptionsPanel.
     */
    public PrivacyOptionsPanel() {
        super(OPTION_NAME, SecurityOptionsCategory.class);
        initComponents();

        update();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     */
    @Override
    public final void update() {
        cbSendUncaughtClientExceptions.setSelected(PrivacyClientHandler.getInstance().isSendUncaughtExceptions());
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void applyChanges() {
        PrivacyClientHandler.getInstance().setSendUncaughtExceptions(cbSendUncaughtClientExceptions.isSelected());
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public boolean isChanged() {
        return PrivacyClientHandler.getInstance().isSendUncaughtExceptions()
                    != cbSendUncaughtClientExceptions.isSelected();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public String getTooltip() {
        return org.openide.util.NbBundle.getMessage(PrivacyOptionsPanel.class, "PrivacyOptionsPanel.getTooltip().text"); // NOI18N
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public void configure(final Element parent) {
        if (parent == null) {
            return;
        }

        boolean sendUncaughtExceptions = true;

        try {
            final Element config = parent.getChild(XML_CONF_ROOT);
            final Element sendUncaughtExceptionsElement = config.getChild(XML_CONF_SEND_UNCAUGHT_EXCEPTIONS);
            if ((sendUncaughtExceptionsElement != null) && (sendUncaughtExceptionsElement.getTextTrim() != null)) {
                sendUncaughtExceptions = Boolean.parseBoolean(sendUncaughtExceptionsElement.getTextTrim());
            }
        } catch (final Exception ex) {
            LOG.warn(ex, ex);
        }

        PrivacyClientHandler.getInstance().setSendUncaughtExceptions(sendUncaughtExceptions);
        update();
    }

    @Override
    public void masterConfigure(final Element parent) {
        // NOP
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        final Element config = new Element(XML_CONF_ROOT);
        final Element directory = new Element(XML_CONF_SEND_UNCAUGHT_EXCEPTIONS);
        directory.addContent(Boolean.toString(PrivacyClientHandler.getInstance().isSendUncaughtExceptions()));
        config.addContent(directory);
        return config;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel3 = new javax.swing.JPanel();
        cbSendUncaughtClientExceptions = new javax.swing.JCheckBox();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));

        setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        cbSendUncaughtClientExceptions.setText(org.openide.util.NbBundle.getMessage(
                PrivacyOptionsPanel.class,
                "PrivacyOptionsPanel.cbSendUncaughtClientExceptions.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 15);
        jPanel3.add(cbSendUncaughtClientExceptions, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(filler1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(filler2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(jPanel3, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents
}
