/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.tools.gui;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.lookup.ServiceProvider;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.lookupoptions.options.GeneralOptionsCategory;

import de.cismet.tools.BrowserLauncher;

import de.cismet.tools.configuration.NoWriteError;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class BrowserLauncherOptionsPanel extends AbstractOptionsPanel implements ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final transient Logger LOG = Logger.getLogger(BrowserLauncherOptionsPanel.class);
    private static final String CONFIGURATION = "BrowserLauncherOptionsPanel";
    private static final String CONF_CUSTOM_CMD = "CustomCmd";

    //~ Instance fields --------------------------------------------------------

    private boolean browserCmdEnabled = false;
    private String browserCmd = null;
    private boolean stillConfigured = false;

    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.Box.Filler filler1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JLabel lblIntervall;
    private javax.swing.JLabel lblSeconds;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form PasswordOptionsDialog.
     */
    public BrowserLauncherOptionsPanel() {
        super(org.openide.util.NbBundle.getMessage(
                BrowserLauncherOptionsPanel.class,
                "BrowserLauncherOptionsPanel.title"), // NOI18N,
            GeneralOptionsCategory.class);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        try {
            initComponents();
        } catch (Exception e) {
            LOG.error("Erro during Creation of Password Dialog", e);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblSeconds = new javax.swing.JLabel();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        lblIntervall = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jCheckBox1 = new javax.swing.JCheckBox();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        setMaximumSize(new java.awt.Dimension(264, 177));
        setMinimumSize(new java.awt.Dimension(100, 177));
        setLayout(new java.awt.GridBagLayout());

        lblSeconds.setFont(new java.awt.Font("Noto Sans", 2, 12)); // NOI18N
        lblSeconds.setText(org.openide.util.NbBundle.getMessage(
                BrowserLauncherOptionsPanel.class,
                "BrowserLauncherOptionsPanel.lblSeconds.text"));   // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                jCheckBox1,
                org.jdesktop.beansbinding.ELProperty.create("${selected}"),
                lblSeconds,
                org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        add(lblSeconds, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        add(filler1, gridBagConstraints);

        lblIntervall.setText(org.openide.util.NbBundle.getMessage(
                BrowserLauncherOptionsPanel.class,
                "BrowserLauncherOptionsPanel.lblIntervall.text")); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                jCheckBox1,
                org.jdesktop.beansbinding.ELProperty.create("${selected}"),
                lblIntervall,
                org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(lblIntervall, gridBagConstraints);

        jTextField1.setText(org.openide.util.NbBundle.getMessage(
                BrowserLauncherOptionsPanel.class,
                "BrowserLauncherOptionsPanel.jTextField1.text")); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                jCheckBox1,
                org.jdesktop.beansbinding.ELProperty.create("${selected}"),
                jTextField1,
                org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jTextField1, gridBagConstraints);

        jCheckBox1.setText(org.openide.util.NbBundle.getMessage(
                BrowserLauncherOptionsPanel.class,
                "BrowserLauncherOptionsPanel.jCheckBox1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jCheckBox1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public void update() {
        browserCmd = BrowserLauncher.getCustomBrowserCmd();
        browserCmdEnabled = browserCmd != null;
        updateGui();
    }

    @Override
    public void applyChanges() {
        browserCmd = jTextField1.getText();
        browserCmdEnabled = jCheckBox1.isSelected();
        if (browserCmdEnabled) {
            BrowserLauncher.setCustomBrowserCmd(browserCmd);
        }
    }

    @Override
    public boolean isChanged() {
        final String test = jCheckBox1.isSelected() ? jTextField1.getText() : null;
        return ((test == null) ? (browserCmd != null) : (!test.equals(browserCmd)));
    }

    /**
     * DOCUMENT ME!
     */
    private void updateGui() {
        jCheckBox1.setSelected(browserCmdEnabled);
        jTextField1.setText(browserCmd);
    }

    /**
     * Returns tooltip text.
     *
     * @return  tooltip text
     */
    @Override
    public String getTooltip() {
        return org.openide.util.NbBundle.getMessage(
                BrowserLauncherOptionsPanel.class,
                "BrowserLauncherOptionsPanel.tooltip"); // NOI18N
    }

    @Override
    public void configure(final Element parent) {
        if (!stillConfigured) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configure BrowserLauncherOptionsPanel");
            }
            try {
                String browserCmd = null;
                if (parent != null) {
                    final Element conf = parent.getChild(CONFIGURATION);
                    if (conf != null) {
                        browserCmd = conf.getChildText(CONF_CUSTOM_CMD);
                    }
                }
                this.browserCmd = browserCmd;
                this.browserCmdEnabled = browserCmd != null;
            } catch (Exception ex) {
                LOG.error("Fehler beim Konfigurieren des BrowserLauncherOptionsPanel", ex);
            }

            updateGui();

            stillConfigured = true;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip Configure GeometryOptionsPanel - still configured");
            }
        }

        // Änderungen anwenden
        applyChanges();
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        final Element conf = new Element(CONFIGURATION);

        if (browserCmdEnabled) {
            final Element cmdElement = new Element(CONF_CUSTOM_CMD);
            cmdElement.addContent(browserCmd);
            conf.addContent(cmdElement);
        }

        return conf;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
