/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.tools.gui.breadcrumb;

import org.jdesktop.swingx.JXHyperlink;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public final class LinkStyleBreadCrumbGui extends javax.swing.JPanel {

    //~ Instance fields --------------------------------------------------------

    private final transient ImageIcon arrow;

    private transient JXHyperlink first;
    private transient BreadCrumbModel breadCrumbModel;
    private transient boolean showFirstCrumbAlone;

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form LinkStyleBreadCrumbGui.
     */
    public LinkStyleBreadCrumbGui() {
        this(new DefaultBreadCrumbModel());
    }

    /**
     * Creates a new LinkStyleBreadCrumbGui object.
     *
     * @param  breadCrumbModel  DOCUMENT ME!
     */
    public LinkStyleBreadCrumbGui(final BreadCrumbModel breadCrumbModel) {
        initComponents();

        arrow = new ImageIcon(getClass().getResource("/de/cismet/tools/gui/res/arrowRight.png")); // NOI18N
        showFirstCrumbAlone = false;
        first = null;

        setBreadCrumbModel(breadCrumbModel);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        setOpaque(false);
        setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public BreadCrumbModel getBreadCrumbModel() {
        return breadCrumbModel;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  breadCrumbModel  DOCUMENT ME!
     */
    public void setBreadCrumbModel(final BreadCrumbModel breadCrumbModel) {
        this.breadCrumbModel = breadCrumbModel;
        breadCrumbModel.addBreadCrumbModelListener(new AbstractBreadCrumbModelListener() {

                @Override
                public void breadCrumbModelChanged(final BreadCrumbEvent bce) {
                    LinkStyleBreadCrumbGui.this.removeAll();
                    LinkStyleBreadCrumbGui.this.revalidate();
                    final BreadCrumbModel m = bce.getSource();
                    final List<BreadCrumb> l = m.getAllCrumbs();
                    for (final BreadCrumb bc : l) {
                        addToGui(bc);
                    }
                }

                @Override
                public void breadCrumbAdded(final BreadCrumbEvent bce) {
                    final BreadCrumb bc = bce.getBreadCrumb();
                    addToGui(bc);
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public boolean isShowFirstCrumbAlone() {
        return showFirstCrumbAlone;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  showFirstCrumbAlone  DOCUMENT ME!
     */
    public void setShowFirstCrumbAlone(final boolean showFirstCrumbAlone) {
        this.showFirstCrumbAlone = showFirstCrumbAlone;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  bc  DOCUMENT ME!
     */
    private void addToGui(final BreadCrumb bc) {
        if ((breadCrumbModel.getSize() > 0) && (breadCrumbModel.getFirstCrumb() != bc)) {
            final JLabel arrowL = new JLabel(arrow);
            LinkStyleBreadCrumbGui.this.add(arrowL);
        }

        final JXHyperlink bcLink = new JXHyperlink(bc);
        bcLink.setClickedColor(bcLink.getUnclickedColor());
        bcLink.setFocusPainted(false);
        LinkStyleBreadCrumbGui.this.add(bcLink);
        if (!showFirstCrumbAlone) {
            if (breadCrumbModel.getSize() == 1) {
                first = bcLink;
                first.setVisible(false);
            } else {
                first.setVisible(true);
            }
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
