/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.tools.gui.historybutton;

import java.io.IOException;

import java.net.URL;

import javax.swing.UIManager;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten.hell@cismet.de
 * @version  $Revision$, $Date$
 */
public class HistoryButtonPresenter extends javax.swing.JApplet {

    //~ Instance fields --------------------------------------------------------

    DefaultHistoryModel hm = new DefaultHistoryModel();
    JHistoryButton hbBack = null;
    JHistoryButton hbForward = null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JToolBar toolBar;
    private javax.swing.JTextField txtUrl;
    // End of variables declaration//GEN-END:variables

    //~ Methods ----------------------------------------------------------------

    /**
     * Initializes the applet HistoryButtonPresenter.
     */
    @Override
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                    @Override
                    public void run() {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        } catch (Exception e) {
                        }
                        initComponents();

                        hbBack = JHistoryButton.getDefaultJHistoryButton(
                                JHistoryButton.DIRECTION_BACKWARD,
                                JHistoryButton.ICON_SIZE_16,
                                hm);
                        hbForward = JHistoryButton.getDefaultJHistoryButton(
                                JHistoryButton.DIRECTION_FORWARD,
                                JHistoryButton.ICON_SIZE_16,
                                hm);
                        toolBar.add(hbBack, 0);
                        toolBar.add(hbForward, 1);
                        hm.addHistoryModelListener(new HistoryModelListener() {

                                @Override
                                public void historyChanged() {
                                    txtUrl.setText(hm.getCurrentElement().toString());
                                }

                                @Override
                                public void forwardStatusChanged() {
                                }

                                @Override
                                public void backStatusChanged() {
                                }

                                @Override
                                public void historyActionPerformed() {
                                }
                            });
                        hm.addToHistory("http://www.google.de/"); // NOI18N
                    }
                });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * This method is called from within the init() method to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        toolBar = new javax.swing.JToolBar();
        jLabel1 = new javax.swing.JLabel();
        txtUrl = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();

        setBackground(javax.swing.UIManager.getDefaults().getColor("Button.background"));

        jLabel1.setText(org.openide.util.NbBundle.getMessage(
                HistoryButtonPresenter.class,
                "HistoryButtonPresenter.jLabel1.text")); // NOI18N
        toolBar.add(jLabel1);

        txtUrl.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtUrlActionPerformed(evt);
                }
            });
        toolBar.add(txtUrl);

        getContentPane().add(toolBar, java.awt.BorderLayout.NORTH);

        jLabel2.setBackground(javax.swing.UIManager.getDefaults().getColor("ComboBox.selectionBackground"));
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText(org.openide.util.NbBundle.getMessage(
                HistoryButtonPresenter.class,
                "HistoryButtonPresenter.jLabel2.text")); // NOI18N
        getContentPane().add(jLabel2, java.awt.BorderLayout.CENTER);
    }                                                    // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtUrlActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtUrlActionPerformed
        hm.addToHistory(txtUrl.getText());
    }                                                                          //GEN-LAST:event_txtUrlActionPerformed
}
