/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.tools.gui.log4jquickconfig;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.KeyEvent;

import java.util.Properties;

import javax.swing.JDialog;
import javax.swing.KeyStroke;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten.hell@cismet.de
 * @version  $Revision$, $Date$
 */
public class Log4JQuickConfig extends JDialog {

    //~ Static fields/initializers ---------------------------------------------

    private static Log4JQuickConfig log4jConfigurator = null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgrWhat;
    private javax.swing.JCheckBox chkConsole;
    private javax.swing.JCheckBox chkFile;
    private javax.swing.JCheckBox chkSockets;
    private javax.swing.JButton cmdCancel;
    private javax.swing.JButton cmdConfig;
    private javax.swing.JButton cmdFile;
    private de.cismet.tools.gui.GradientPanel gpnTitle;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JLabel lblFile;
    private javax.swing.JLabel lblHost;
    private javax.swing.JLabel lblPort;
    private javax.swing.JPanel panButtons;
    private javax.swing.JPanel panConfig;
    private javax.swing.JPanel panTitle;
    private javax.swing.JPanel panWhat;
    private javax.swing.JPanel panWhere;
    private javax.swing.JRadioButton rdbDebug;
    private javax.swing.JRadioButton rdbDisable;
    private javax.swing.JRadioButton rdbError;
    private javax.swing.JRadioButton rdbFatal;
    private javax.swing.JRadioButton rdbInfo;
    private javax.swing.JRadioButton rdbWarn;
    private javax.swing.JTextField txtFile;
    private javax.swing.JTextField txtHost;
    private javax.swing.JTextField txtPort;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form Log4JQuickConfig.
     */
    public Log4JQuickConfig() {
        super((Frame)null, true);
        initComponents();
        gpnTitle.setLeftColor(new Color(49, 66, 122));
        gpnTitle.setRightColor(Color.white);
        getRootPane().setDefaultButton(cmdConfig);
        StaticSwingTools.doClickButtonOnKeyStroke(
            cmdConfig,
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
            getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke(
            cmdCancel,
            KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
            getRootPane());
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        bgrWhat = new javax.swing.ButtonGroup();
        panConfig = new javax.swing.JPanel();
        panWhat = new javax.swing.JPanel();
        rdbDebug = new javax.swing.JRadioButton();
        rdbInfo = new javax.swing.JRadioButton();
        rdbWarn = new javax.swing.JRadioButton();
        rdbError = new javax.swing.JRadioButton();
        rdbFatal = new javax.swing.JRadioButton();
        rdbDisable = new javax.swing.JRadioButton();
        panWhere = new javax.swing.JPanel();
        chkSockets = new javax.swing.JCheckBox();
        lblHost = new javax.swing.JLabel();
        txtHost = new javax.swing.JTextField();
        lblPort = new javax.swing.JLabel();
        txtPort = new javax.swing.JTextField();
        chkFile = new javax.swing.JCheckBox();
        lblFile = new javax.swing.JLabel();
        txtFile = new javax.swing.JTextField();
        cmdFile = new javax.swing.JButton();
        chkConsole = new javax.swing.JCheckBox();
        panTitle = new javax.swing.JPanel();
        gpnTitle = new de.cismet.tools.gui.GradientPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        panButtons = new javax.swing.JPanel();
        cmdCancel = new javax.swing.JButton();
        cmdConfig = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();

        panConfig.setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panConfig.setLayout(new java.awt.GridBagLayout());

        panWhat.setBorder(javax.swing.BorderFactory.createCompoundBorder(
                javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3),
                javax.swing.BorderFactory.createTitledBorder(
                    org.openide.util.NbBundle.getMessage(
                        Log4JQuickConfig.class,
                        "Log4JQuickConfig.panWhat.border.insideBorder.title")))); // NOI18N
        panWhat.setLayout(new java.awt.GridBagLayout());

        bgrWhat.add(rdbDebug);
        rdbDebug.setSelected(true);
        rdbDebug.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.rdbDebug.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        panWhat.add(rdbDebug, gridBagConstraints);

        bgrWhat.add(rdbInfo);
        rdbInfo.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.rdbInfo.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        panWhat.add(rdbInfo, gridBagConstraints);

        bgrWhat.add(rdbWarn);
        rdbWarn.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.rdbWarn.text")); // NOI18N
        rdbWarn.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    rdbWarnActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        panWhat.add(rdbWarn, gridBagConstraints);

        bgrWhat.add(rdbError);
        rdbError.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.rdbError.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        panWhat.add(rdbError, gridBagConstraints);

        bgrWhat.add(rdbFatal);
        rdbFatal.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.rdbFatal.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        panWhat.add(rdbFatal, gridBagConstraints);

        bgrWhat.add(rdbDisable);
        rdbDisable.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.rdbDisable.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        panWhat.add(rdbDisable, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        panConfig.add(panWhat, gridBagConstraints);

        panWhere.setBorder(javax.swing.BorderFactory.createCompoundBorder(
                javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3),
                javax.swing.BorderFactory.createTitledBorder(
                    org.openide.util.NbBundle.getMessage(
                        Log4JQuickConfig.class,
                        "Log4JQuickConfig.panWhere.border.insideBorder.title")))); // NOI18N
        panWhere.setLayout(new java.awt.GridBagLayout());

        chkSockets.setSelected(true);
        chkSockets.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.chkSockets.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 2, 0);
        panWhere.add(chkSockets, gridBagConstraints);

        lblHost.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.lblHost.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 2, 0);
        panWhere.add(lblHost, gridBagConstraints);

        txtHost.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.txtHost.text")); // NOI18N
        txtHost.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtHostActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 2, 9);
        panWhere.add(txtHost, gridBagConstraints);

        lblPort.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.lblPort.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 2, 0);
        panWhere.add(lblPort, gridBagConstraints);

        txtPort.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.txtPort.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 2, 9);
        panWhere.add(txtPort, gridBagConstraints);

        chkFile.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.chkFile.text")); // NOI18N
        chkFile.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    chkFileActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 2, 0);
        panWhere.add(chkFile, gridBagConstraints);

        lblFile.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.lblFile.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 2, 0);
        panWhere.add(lblFile, gridBagConstraints);

        txtFile.setEnabled(false);
        txtFile.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtFileActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 2, 9);
        panWhere.add(txtFile, gridBagConstraints);

        cmdFile.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.cmdFile.text")); // NOI18N
        cmdFile.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 2, 3);
        panWhere.add(cmdFile, gridBagConstraints);

        chkConsole.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.chkConsole.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 2, 0);
        panWhere.add(chkConsole, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panConfig.add(panWhere, gridBagConstraints);

        getContentPane().add(panConfig, java.awt.BorderLayout.CENTER);

        panTitle.setLayout(new java.awt.GridBagLayout());

        gpnTitle.setForeground(new java.awt.Color(236, 233, 216));
        gpnTitle.setLeftColor(new java.awt.Color(49, 66, 122));
        gpnTitle.setRightColor(new java.awt.Color(255, 255, 255));
        gpnTitle.setLayout(new java.awt.GridBagLayout());

        jLabel1.setFont(new java.awt.Font("Courier", 1, 24));                                                           // NOI18N
        jLabel1.setForeground(new java.awt.Color(236, 233, 216));
        jLabel1.setText(org.openide.util.NbBundle.getMessage(Log4JQuickConfig.class, "Log4JQuickConfig.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gpnTitle.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 75.0;
        panTitle.add(gpnTitle, gridBagConstraints);

        jPanel3.setBackground(new java.awt.Color(255, 255, 255));

        jLabel2.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/tools/gui/log4jquickconfig/res/log4j.png"))); // NOI18N
        jPanel3.add(jLabel2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        panTitle.add(jPanel3, gridBagConstraints);

        jPanel4.setBackground(new java.awt.Color(255, 255, 255));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        panTitle.add(jPanel4, gridBagConstraints);

        getContentPane().add(panTitle, java.awt.BorderLayout.NORTH);

        panButtons.setLayout(new java.awt.GridBagLayout());

        cmdCancel.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.cmdCancel.text_1")); // NOI18N
        cmdCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdCancelActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 4);
        panButtons.add(cmdCancel, gridBagConstraints);

        cmdConfig.setText(org.openide.util.NbBundle.getMessage(
                Log4JQuickConfig.class,
                "Log4JQuickConfig.cmdConfig.text")); // NOI18N
        cmdConfig.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdConfigActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 7);
        panButtons.add(cmdConfig, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        panButtons.add(jPanel1, gridBagConstraints);

        getContentPane().add(panButtons, java.awt.BorderLayout.SOUTH);

        final java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width - 532) / 2, (screenSize.height - 335) / 2, 532, 335);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void chkFileActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_chkFileActionPerformed
        txtFile.setEnabled(chkFile.isSelected());
    }                                                                           //GEN-LAST:event_chkFileActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdConfigActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdConfigActionPerformed
        // remove all old appenders
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        final Configuration config = ctx.getConfiguration();

        // Remove all appenders
        for (final Appender appender : config.getAppenders().values()) {
            ctx.getLogger("root").removeAppender(appender);
        }

        // Reconfigure Log4j2 to apply changes
        ctx.updateLoggers();

        // add new appenders
        Level level = Level.DEBUG;

        if (rdbInfo.isSelected()) {
            level = Level.INFO;
        } else if (rdbWarn.isSelected()) {
            level = Level.WARN;
        } else if (rdbError.isSelected()) {
            level = Level.ERROR;
        } else if (rdbFatal.isSelected()) {
            level = Level.FATAL;
        } else if (rdbDisable.isSelected()) {
            level = Level.OFF;
        }

        final ConfigurationBuilder<?> builder = ConfigurationBuilderFactory.newConfigurationBuilder();

        // Define appenders
        if (chkSockets.isSelected()) {
            final AppenderComponentBuilder socketAppender = builder.newAppender("Remote", "Socket")
                        .addAttribute("host", txtHost.getText())
                        .addAttribute("port", Integer.parseInt(txtPort.getText()));
            socketAppender.add(builder.newLayout("JsonLayout"));
            builder.add(socketAppender);
        }

        if (chkFile.isSelected()) {
            final AppenderComponentBuilder fileAppender = builder.newAppender("File", "File")
                        .addAttribute("fileName", txtFile.getText())
                        .addAttribute("append", true);
            fileAppender.add(builder.newLayout("HtmlLayout"));
            builder.add(fileAppender);
        }

        if (chkConsole.isSelected()) {
            final AppenderComponentBuilder consoleAppender = builder.newAppender("Console", "Console");
            consoleAppender.add(builder.newLayout("PatternLayout").addAttribute(
                    "pattern",
                    "[%d{yyyy-MM-dd HH:mm:ss}] [%t] %-5level %logger{36} - %msg%n"));
            builder.add(consoleAppender);
        }

        // Configure Root Logger
        final RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);

        // Define appenders
        if (chkSockets.isSelected()) {
            rootLogger.add(builder.newAppenderRef("Remote"));
        }

        if (chkFile.isSelected()) {
            rootLogger.add(builder.newAppenderRef("File"));
        }

        if (chkConsole.isSelected()) {
            rootLogger.add(builder.newAppenderRef("Console"));
        }

        builder.add(rootLogger);

        // Apply Configuration
        ctx = (LoggerContext)LogManager.getContext(false);
        final Configuration conf = builder.build();
        ctx.start(conf);

        this.hide();
    } //GEN-LAST:event_cmdConfigActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdCancelActionPerformed
        this.hide();
    }                                                                             //GEN-LAST:event_cmdCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtFileActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtFileActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_txtFileActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtHostActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtHostActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_txtHostActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void rdbWarnActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rdbWarnActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_rdbWarnActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    Log4JQuickConfig.getSingletonInstance().setVisible(true);
                }
            });
    }
    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static Log4JQuickConfig getSingletonInstance() {
        if (log4jConfigurator == null) {
            log4jConfigurator = new Log4JQuickConfig();
        }
        return log4jConfigurator;
    }

    /**
     * DOCUMENT ME!
     */
    public static void configure4LumbermillOnLocalhost() {
        configure4LumbermillOnLocalhost("DEBUG");
    }

    /**
     * DOCUMENT ME!
     *
     * @param  level  DOCUMENT ME!
     */
    public static void configure4LumbermillOnLocalhost(final String level) {
        configure4LumbermillOn("localhost", 4445, level);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  host  DOCUMENT ME!
     * @param  port  DOCUMENT ME!
     */
    public static void configure4LumbermillOn(final String host, final int port) {
        configure4LumbermillOn(host, port, "DEBUG");
    }

    /**
     * DOCUMENT ME!
     *
     * @param  host   DOCUMENT ME!
     * @param  port   DOCUMENT ME!
     * @param  level  DOCUMENT ME!
     */
    public static void configure4LumbermillOn(final String host, final int port, final String level) {
        final ConfigurationBuilder<BuiltConfiguration> builder = new DefaultConfigurationBuilder<>();

        builder.setStatusLevel(Level.WARN);
        builder.setConfigurationName("DynamicConfig");

        // Define appenders
        final AppenderComponentBuilder socketAppender = builder.newAppender("Remote", "Socket")
                    .addAttribute("host", host)
                    .addAttribute("port", port);
        socketAppender.add(builder.newLayout("JsonLayout"));
        builder.add(socketAppender);

        // Define root logger
        final RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);

        builder.add(rootLogger);

        // Build and apply the configuration
        final LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        final Configuration conf = builder.build();
        ctx.start(conf);
    }
}
