/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import de.cismet.commons.gui.equalizer.AbstractEqualizerModel;
import de.cismet.commons.gui.equalizer.EqualizerModelEvent;
import de.cismet.commons.gui.equalizer.EqualizerModelListener;
import de.cismet.commons.gui.equalizer.Range;
import java.lang.reflect.Field;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractEqualizerModelNGTest {
    private EqualizerModelListenerImpl eqL1;
    private EqualizerModelListenerImpl eqL2;
    private EqualizerModelListenerImpl eqL3;

    @BeforeMethod
    public void setUpMethod() throws Exception {
        this.eqL1 = new EqualizerModelListenerImpl();
        this.eqL2 = new EqualizerModelListenerImpl();
        this.eqL3 = new EqualizerModelListenerImpl();
    }

    @AfterMethod
    public void tearDonwMethod() throws Exception {
        this.eqL1 = null;
        this.eqL2 = null;
        this.eqL3 = null;
    }

    @Test
    public void testFireEqualizerModelEvent() {
        AbstractEqualizerModelImpl model = new AbstractEqualizerModelImpl();
        EqualizerModelEvent event = new EqualizerModelEvent((Object)model);
        model.addEqualizerModelListener(this.eqL1);
        model.fireEqualizerModelEvent(event);
        Assert.assertEquals((Object)this.eqL1.event, (Object)event);
        this.eqL1.event = null;
        model.addEqualizerModelListener(this.eqL2);
        model.addEqualizerModelListener(this.eqL3);
        model.fireEqualizerModelEvent(event);
        Assert.assertEquals((Object)this.eqL1.event, (Object)event);
        Assert.assertEquals((Object)this.eqL2.event, (Object)event);
        Assert.assertEquals((Object)this.eqL3.event, (Object)event);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFireEqualizerModelEvent_nullEvent() {
        AbstractEqualizerModelImpl model = new AbstractEqualizerModelImpl();
        model.fireEqualizerModelEvent(null);
    }

    @Test
    public void testAddEqualizerModelListener() throws Exception {
        AbstractEqualizerModelImpl model = new AbstractEqualizerModelImpl();
        Assert.assertEquals((int)model.getListenerCount(), (int)0);
        model.addEqualizerModelListener(this.eqL1);
        Assert.assertEquals((int)model.getListenerCount(), (int)1);
        model.addEqualizerModelListener(this.eqL2);
        model.addEqualizerModelListener(this.eqL3);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
        model.addEqualizerModelListener(this.eqL1);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
        model.addEqualizerModelListener(this.eqL2);
        model.addEqualizerModelListener(this.eqL3);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
        model.addEqualizerModelListener(this.eqL1);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
        model.addEqualizerModelListener(this.eqL2);
        model.addEqualizerModelListener(this.eqL3);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
        model.addEqualizerModelListener(null);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
    }

    @Test(dependsOnMethods={"testAddEqualizerModelListener"})
    public void testRemoveEqualizerModelListener() throws Exception {
        AbstractEqualizerModelImpl model = new AbstractEqualizerModelImpl();
        model.addEqualizerModelListener(this.eqL1);
        model.addEqualizerModelListener(this.eqL2);
        model.addEqualizerModelListener(this.eqL3);
        model.removeEqualizerModelListener(null);
        Assert.assertEquals((int)model.getListenerCount(), (int)3);
        model.removeEqualizerModelListener(this.eqL1);
        Assert.assertEquals((int)model.getListenerCount(), (int)2);
        model.removeEqualizerModelListener(this.eqL1);
        Assert.assertEquals((int)model.getListenerCount(), (int)2);
        model.removeEqualizerModelListener(this.eqL2);
        model.removeEqualizerModelListener(this.eqL3);
        Assert.assertEquals((int)model.getListenerCount(), (int)0);
        model.removeEqualizerModelListener(this.eqL1);
        model.removeEqualizerModelListener(this.eqL2);
        model.removeEqualizerModelListener(this.eqL3);
        Assert.assertEquals((int)model.getListenerCount(), (int)0);
    }

    private static final class AbstractEqualizerModelImpl
    extends AbstractEqualizerModel {
        private AbstractEqualizerModelImpl() {
        }

        int getListenerCount() throws Exception {
            Field field = AbstractEqualizerModel.class.getDeclaredField("listeners");
            field.setAccessible(true);
            return ((Set)field.get((Object)this)).size();
        }

        public Range getRange() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getEqualizerCategory(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getEqualizerCategoryCount() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getValueAt(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setValueAt(int index, int value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class EqualizerModelListenerImpl
    implements EqualizerModelListener {
        EqualizerModelEvent event = null;

        private EqualizerModelListenerImpl() {
        }

        public void equalizerChanged(EqualizerModelEvent event) {
            this.event = event;
        }
    }
}

