/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import de.cismet.commons.gui.equalizer.DefaultEqualizerModel;
import de.cismet.commons.gui.equalizer.EqualizerCategory;
import de.cismet.commons.gui.equalizer.Range;
import java.util.ArrayList;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultEqualizerModelNGTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @BeforeMethod
    public void setUpMethod() throws Exception {
    }

    @AfterMethod
    public void tearDownMethod() throws Exception {
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultEqualizerModel_nullCategories() {
        new DefaultEqualizerModel(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultEqualizerModel_emptyCategories() {
        new DefaultEqualizerModel(new ArrayList(0));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultEqualizerModel_nullRange() {
        new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test")), null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultEqualizerModel_valueNotWithinRange1() {
        new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1)), new Range(0, 1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultEqualizerModel_valueNotWithinRange2() {
        new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -6)), new Range(-5, 7));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultEqualizerModel_duplicateCatName() {
        new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test1", -5)), new Range(-5, 7));
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testGetEqualizerCategory_indexTooLow() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.getEqualizerCategory(-1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testGetEqualizerCategory_indexTooHigh() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.getEqualizerCategory(3);
    }

    @Test
    public void testGetEqualizerCategory() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        Assert.assertEquals((String)instance.getEqualizerCategory(0), (String)"test1");
        Assert.assertEquals((String)instance.getEqualizerCategory(2), (String)"test3");
    }

    @Test
    public void testGetEqualizerCategoryCount() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        Assert.assertEquals((int)instance.getEqualizerCategoryCount(), (int)3);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testGetValueAt_indexTooLow() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.getValueAt(-1);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testGetValueAt_indexTooHigh() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.getValueAt(3);
    }

    @Test
    public void testGetValueAt() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        Assert.assertEquals((int)instance.getValueAt(0), (int)-1);
        Assert.assertEquals((int)instance.getValueAt(2), (int)-5);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSetValueAt_notWithinRange() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.setValueAt(2, 8);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetValueAt_indexTooLow() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.setValueAt(-1, 8);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetValueAt_indexTooHigh() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.setValueAt(3, 8);
    }

    @Test(dependsOnMethods={"testGetValueAt"})
    public void testSetValueAt() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.setValueAt(0, 1);
        instance.setValueAt(2, 4);
        Assert.assertEquals((int)instance.getValueAt(0), (int)1);
        Assert.assertEquals((int)instance.getValueAt(2), (int)4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCheckValueWithinRange_notWithinRange1() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.checkValueWithinRange(8);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testCheckValueWithinRange_notWithinRange2() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.checkValueWithinRange(-6);
    }

    @Test
    public void testCheckValueWithinRange() {
        DefaultEqualizerModel instance = new DefaultEqualizerModel(Arrays.asList(new EqualizerCategory("test1", -1), new EqualizerCategory("test2", 7), new EqualizerCategory("test3", -5)), new Range(-5, 7));
        instance.checkValueWithinRange(0);
        instance.checkValueWithinRange(2);
        instance.checkValueWithinRange(-5);
        instance.checkValueWithinRange(7);
    }
}

