/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import de.cismet.commons.gui.equalizer.EqualizerCategory;
import de.cismet.commons.gui.equalizer.RubberBandEqualizerModel;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RubberBandEqualizerModelNGTest {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRubberBandEqualizerModel_sumNE100_1() {
        new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 1)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRubberBandEqualizerModel_sumNE100_2() {
        new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 1), new EqualizerCategory("test1", 1), new EqualizerCategory("test1", 1), new EqualizerCategory("test1", 1), new EqualizerCategory("test1", 1)));
    }

    public void testRubberBandEqualizerModel_equalDistribution() {
        RubberBandEqualizerModel model = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 0), new EqualizerCategory("test1", 0), new EqualizerCategory("test1", 0), new EqualizerCategory("test1", 0), new EqualizerCategory("test1", 0)));
        Assert.assertEquals((int)model.getValueAt(0), (int)20);
        Assert.assertEquals((int)model.getValueAt(1), (int)20);
        Assert.assertEquals((int)model.getValueAt(2), (int)20);
        Assert.assertEquals((int)model.getValueAt(3), (int)20);
        Assert.assertEquals((int)model.getValueAt(4), (int)20);
        model = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 0), new EqualizerCategory("test1", 0), new EqualizerCategory("test1", 0)));
        Assert.assertEquals((int)model.getValueAt(0), (int)33);
        Assert.assertEquals((int)model.getValueAt(1), (int)33);
        Assert.assertEquals((int)model.getValueAt(2), (int)34);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSetValueAt_notWithinRange() {
        RubberBandEqualizerModel instance = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 33), new EqualizerCategory("test2", 33), new EqualizerCategory("test3", 34)));
        instance.setValueAt(0, 101);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetValueAt_indexTooLow() {
        RubberBandEqualizerModel instance = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 33), new EqualizerCategory("test2", 33), new EqualizerCategory("test3", 34)));
        instance.setValueAt(-1, 8);
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testSetValueAt_indexTooHigh() {
        RubberBandEqualizerModel instance = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 33), new EqualizerCategory("test2", 33), new EqualizerCategory("test3", 34)));
        instance.setValueAt(3, 8);
    }

    @Test
    public void testSetValueAt() {
        RubberBandEqualizerModel instance = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 33), new EqualizerCategory("test2", 33), new EqualizerCategory("test3", 34)));
        instance.setValueAt(2, 50);
        Assert.assertEquals((int)instance.getValueAt(0), (int)25);
        Assert.assertEquals((int)instance.getValueAt(1), (int)25);
        Assert.assertEquals((int)instance.getValueAt(2), (int)50);
        instance.setValueAt(2, 50);
        Assert.assertEquals((int)instance.getValueAt(0), (int)25);
        Assert.assertEquals((int)instance.getValueAt(1), (int)25);
        Assert.assertEquals((int)instance.getValueAt(2), (int)50);
        instance.setValueAt(1, 50);
        Assert.assertEquals((int)instance.getValueAt(0), (int)12);
        Assert.assertEquals((int)instance.getValueAt(1), (int)50);
        Assert.assertEquals((int)instance.getValueAt(2), (int)38);
        instance.setValueAt(0, 11);
        Assert.assertEquals((int)instance.getValueAt(0), (int)11);
        Assert.assertEquals((int)instance.getValueAt(1), (int)51);
        Assert.assertEquals((int)instance.getValueAt(2), (int)38);
        instance.setValueAt(1, 81);
        Assert.assertEquals((int)instance.getValueAt(0), (int)0);
        Assert.assertEquals((int)instance.getValueAt(1), (int)81);
        Assert.assertEquals((int)instance.getValueAt(2), (int)19);
        instance.setValueAt(2, 45);
        Assert.assertEquals((int)instance.getValueAt(0), (int)0);
        Assert.assertEquals((int)instance.getValueAt(1), (int)55);
        Assert.assertEquals((int)instance.getValueAt(2), (int)45);
        instance.setValueAt(0, 99);
        Assert.assertEquals((int)instance.getValueAt(0), (int)99);
        Assert.assertEquals((int)instance.getValueAt(1), (int)1);
        Assert.assertEquals((int)instance.getValueAt(2), (int)0);
        instance.setValueAt(2, 100);
        Assert.assertEquals((int)instance.getValueAt(0), (int)0);
        Assert.assertEquals((int)instance.getValueAt(1), (int)0);
        Assert.assertEquals((int)instance.getValueAt(2), (int)100);
        instance = new RubberBandEqualizerModel(Arrays.asList(new EqualizerCategory("test1", 10), new EqualizerCategory("test2", 10), new EqualizerCategory("test3", 10), new EqualizerCategory("test4", 10), new EqualizerCategory("test5", 10), new EqualizerCategory("test6", 10), new EqualizerCategory("test7", 10), new EqualizerCategory("test8", 10), new EqualizerCategory("test9", 10), new EqualizerCategory("test10", 10)));
        instance.setValueAt(0, 50);
        Assert.assertEquals((int)instance.getValueAt(0), (int)50);
        Assert.assertEquals((int)instance.getValueAt(1), (int)5);
        Assert.assertEquals((int)instance.getValueAt(2), (int)5);
        Assert.assertEquals((int)instance.getValueAt(3), (int)5);
        Assert.assertEquals((int)instance.getValueAt(4), (int)5);
        Assert.assertEquals((int)instance.getValueAt(5), (int)6);
        Assert.assertEquals((int)instance.getValueAt(6), (int)6);
        Assert.assertEquals((int)instance.getValueAt(7), (int)6);
        Assert.assertEquals((int)instance.getValueAt(8), (int)6);
        Assert.assertEquals((int)instance.getValueAt(9), (int)6);
        instance.setValueAt(9, 49);
        Assert.assertEquals((int)instance.getValueAt(0), (int)45);
        Assert.assertEquals((int)instance.getValueAt(1), (int)0);
        Assert.assertEquals((int)instance.getValueAt(2), (int)0);
        Assert.assertEquals((int)instance.getValueAt(3), (int)0);
        Assert.assertEquals((int)instance.getValueAt(4), (int)0);
        Assert.assertEquals((int)instance.getValueAt(5), (int)1);
        Assert.assertEquals((int)instance.getValueAt(6), (int)1);
        Assert.assertEquals((int)instance.getValueAt(7), (int)2);
        Assert.assertEquals((int)instance.getValueAt(8), (int)2);
        Assert.assertEquals((int)instance.getValueAt(9), (int)49);
        instance.setValueAt(0, 50);
        Assert.assertEquals((int)instance.getValueAt(0), (int)50);
        Assert.assertEquals((int)instance.getValueAt(1), (int)0);
        Assert.assertEquals((int)instance.getValueAt(2), (int)0);
        Assert.assertEquals((int)instance.getValueAt(3), (int)0);
        Assert.assertEquals((int)instance.getValueAt(4), (int)0);
        Assert.assertEquals((int)instance.getValueAt(5), (int)0);
        Assert.assertEquals((int)instance.getValueAt(6), (int)0);
        Assert.assertEquals((int)instance.getValueAt(7), (int)1);
        Assert.assertEquals((int)instance.getValueAt(8), (int)1);
        Assert.assertEquals((int)instance.getValueAt(9), (int)48);
    }
}

