/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.cismet.commons.gui.protocol.AbstractProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.impl.CommentProtocolStep;
import de.cismet.commons.gui.protocol.impl.CommentProtocolStepImpl;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProtocolTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test010SingleProtocolStep() throws JsonProcessingException, IOException {
        CommentProtocolStepImpl step = new CommentProtocolStepImpl("dies ist ein Test-Kommentar");
        String jsonString = step.toJsonString();
        CommentProtocolStep newStep = (CommentProtocolStep)AbstractProtocolStep.fromJsonString((String)jsonString, CommentProtocolStepImpl.class);
        Assert.assertEquals((long)step.getDate().getTime(), (long)newStep.getDate().getTime());
        Assert.assertEquals((Object)step.getMessage(), (Object)newStep.getMessage());
    }

    @Test
    public void test020MultipleProtocolSteps() throws JsonProcessingException, IOException, ClassNotFoundException {
        ProtocolHandler.getInstance().setRecordEnabled(true);
        ProtocolHandler.getInstance().recordStep((ProtocolStep)new CommentProtocolStepImpl("Protollierungs-Test nummer eins..."));
        ProtocolHandler.getInstance().recordStep((ProtocolStep)new CommentProtocolStepImpl("...noch ein Test..."));
        ProtocolHandler.getInstance().recordStep((ProtocolStep)new CommentProtocolStepImpl("...es wird wie wild getestet..."));
        ProtocolHandler.getInstance().recordStep((ProtocolStep)new CommentProtocolStepImpl("...irgendwann reicht es aber auch !"));
        Assert.assertEquals((long)4L, (long)ProtocolHandler.getInstance().getAllSteps().size());
        String allProtosJson = ProtocolHandler.getInstance().toJsonString();
        ProtocolHandler.getInstance().fromJsonString(allProtosJson);
        List list = ProtocolHandler.getInstance().getAllSteps();
        List newList = ProtocolHandler.getInstance().getAllSteps();
        Assert.assertEquals((long)list.size(), (long)newList.size());
        Iterator stepIterator = list.iterator();
        Iterator newStepIterator = newList.iterator();
        while (stepIterator.hasNext() && newStepIterator.hasNext()) {
            CommentProtocolStep step = (CommentProtocolStep)stepIterator.next();
            CommentProtocolStep newStep = (CommentProtocolStep)newStepIterator.next();
            Assert.assertEquals((long)step.getDate().getTime(), (long)newStep.getDate().getTime());
            Assert.assertEquals((Object)step.getMessage(), (Object)newStep.getMessage());
        }
    }
}

