/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import de.cismet.commons.gui.equalizer.EqualizerModel;
import de.cismet.commons.gui.equalizer.EqualizerModelEvent;
import de.cismet.commons.gui.equalizer.EqualizerModelListener;
import de.cismet.commons.gui.equalizer.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.openide.util.WeakListeners;

public class EqualizerPanel
extends JPanel {
    public static final Paint DEFAULT_PAINT = new Color(Integer.decode("0x17"), Integer.decode("0xA8"), Integer.decode("0x14"), Integer.decode("0xDD"));
    public static final Stroke DEFAULT_STROKE = new BasicStroke(3.0f, 0, 0, 10.0f, new float[]{7.0f, 3.0f}, 0.0f);
    private static final String PROP_MODEL_INDEX = "__prop_model_index__";
    private final EqualizerModelListener equalizerModelL = new EqualizerModelL();
    private final ChangeListener sliderChangeL = new SliderChangeL();
    private EqualizerModel model;
    private TreeMap<Integer, JSlider> sliderMap;
    private boolean updateInProgress = false;
    private Paint splinePaint;
    private Stroke splineStroke;
    private boolean rangeAxisPainted;
    private boolean splinePainted;
    private boolean updateSplineWhileAdjusting;
    private boolean updateModelWhileAdjusting;
    private JLabel lblRangeAxis;
    private JPanel pnlEqualizer;

    public EqualizerPanel() {
        this(new EqualizerModel(){
            private final EventListenerList list = new EventListenerList();
            private final int[] value = new int[1];

            @Override
            public Range getRange() {
                return new Range(0, 10);
            }

            @Override
            public String getEqualizerCategory(int index) {
                return "EQ1";
            }

            @Override
            public int getEqualizerCategoryCount() {
                return 1;
            }

            @Override
            public int getValueAt(int index) {
                return this.value[index];
            }

            @Override
            public void setValueAt(int index, int value) {
                if (value < 0 || value > 10) {
                    throw new IllegalArgumentException("value out of range: " + value);
                }
                int oldValue = this.value[index];
                this.value[index] = value;
                for (EqualizerModelListener o : (EqualizerModelListener[])this.list.getListeners(EqualizerModelListener.class)) {
                    o.equalizerChanged(new EqualizerModelEvent(this, index, oldValue, value));
                }
            }

            @Override
            public void addEqualizerModelListener(EqualizerModelListener eml) {
                this.list.add(EqualizerModelListener.class, eml);
            }

            @Override
            public void removeEqualizerModelListener(EqualizerModelListener eml) {
                this.list.remove(EqualizerModelListener.class, eml);
            }
        }, DEFAULT_PAINT, DEFAULT_STROKE, true, null, true, false, true);
    }

    public EqualizerPanel(EqualizerModel model) {
        this(model, DEFAULT_PAINT, DEFAULT_STROKE, true, null, true, false, true);
    }

    public EqualizerPanel(EqualizerModel model, Paint splinePaint, Stroke splineStroke, boolean splinePainted, String rangeAxisName, boolean rangeAxisPainted, boolean updateModelWhileAdjusting, boolean updateSplineWhileAdjusting) {
        this.initComponents();
        this.updateModelWhileAdjusting = updateModelWhileAdjusting;
        this.updateSplineWhileAdjusting = updateSplineWhileAdjusting;
        this.splinePainted = splinePainted;
        this.rangeAxisPainted = rangeAxisPainted;
        this.lblRangeAxis = new JLabel(rangeAxisName);
        this.lblRangeAxis.setOpaque(false);
        this.setModel(model);
        this.setSplinePaint(splinePaint);
        this.setSplineStroke(splineStroke);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (JSlider s : this.sliderMap.values()) {
            s.setEnabled(enabled);
        }
    }

    public EqualizerModel getModel() {
        return this.model;
    }

    public final void setModel(EqualizerModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        if (this.model != model) {
            this.model = model;
            this.model.addEqualizerModelListener((EqualizerModelListener)WeakListeners.create(EqualizerModelListener.class, (EventListener)this.equalizerModelL, (Object)this.model));
            this.recreateComponents();
        }
    }

    public boolean isSplinePainted() {
        return this.splinePainted;
    }

    public void setSplinePainted(boolean splinePainted) {
        this.splinePainted = splinePainted;
        this.repaint();
    }

    public Paint getSplinePaint() {
        return this.splinePaint;
    }

    public final void setSplinePaint(Paint splinePaint) {
        if (splinePaint == null) {
            throw new IllegalArgumentException("splinePaint must not be null");
        }
        this.splinePaint = splinePaint;
        this.repaint();
    }

    public Stroke getSplineStroke() {
        return this.splineStroke;
    }

    public final void setSplineStroke(Stroke splineStroke) {
        if (splineStroke == null) {
            throw new IllegalArgumentException("splineStroke must not be null");
        }
        this.splineStroke = splineStroke;
        this.repaint();
    }

    public boolean isRangeAxisPainted() {
        return this.rangeAxisPainted;
    }

    public final void setRangeAxisPainted(boolean rangeAxisPainted) {
        if (this.rangeAxisPainted != rangeAxisPainted) {
            this.rangeAxisPainted = rangeAxisPainted;
            this.recreateComponents();
        }
    }

    public String getRangeAxisName() {
        return this.lblRangeAxis.getText();
    }

    public final void setRangeAxisName(String rangeAxisName) {
        this.lblRangeAxis.setText(rangeAxisName);
    }

    public boolean isUpdateModelWhileAdjusting() {
        return this.updateModelWhileAdjusting;
    }

    public void setUpdateModelWhileAdjusting(boolean updateModelWhileAdjusting) {
        this.updateModelWhileAdjusting = updateModelWhileAdjusting;
    }

    public boolean isUpdateSplineWhileAdjusting() {
        return this.updateSplineWhileAdjusting;
    }

    public void setUpdateSplineWhileAdjusting(boolean updateSplineWhileAdjusting) {
        this.updateSplineWhileAdjusting = updateSplineWhileAdjusting;
    }

    private void recreateComponents() {
        this.createComponents();
        this.invalidate();
        this.validate();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EqualizerPanel.this.repaint();
            }
        });
    }

    private JPanel createRangeComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        RangePanel rangePanel = new RangePanel();
        GridBagConstraints rangeConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 15, 3, new Insets(5, 5, 5, 5), 0, 0);
        GridBagConstraints labelConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0);
        panel.add((Component)rangePanel, rangeConstraints);
        panel.add((Component)this.lblRangeAxis, labelConstraints);
        return panel;
    }

    private void createComponents() {
        this.sliderMap = new TreeMap(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        });
        this.pnlEqualizer.removeAll();
        GridBagConstraints baseConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 15, 3, new Insets(5, 5, 5, 5), 0, 0);
        if (this.rangeAxisPainted) {
            JPanel scaleComp = this.createRangeComponent();
            GridBagConstraints constraints = (GridBagConstraints)baseConstraints.clone();
            this.pnlEqualizer.add((Component)scaleComp, constraints);
        }
        for (int i = 0; i < this.model.getEqualizerCategoryCount(); ++i) {
            JPanel sliderComp = this.createSliderComponent(i);
            GridBagConstraints constraints = (GridBagConstraints)baseConstraints.clone();
            constraints.gridx = i + 1;
            this.pnlEqualizer.add((Component)sliderComp, constraints);
        }
        this.pnlEqualizer.repaint();
    }

    private JPanel createSliderComponent(int index) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        JLabel label = new JLabel(this.model.getEqualizerCategory(index));
        label.setOpaque(false);
        JSlider slider = new JSlider(1);
        slider.setEnabled(this.isEnabled());
        slider.setOpaque(false);
        slider.setMinimum(this.model.getRange().getMin());
        slider.setMaximum(this.model.getRange().getMax());
        slider.setValue(this.model.getValueAt(index));
        slider.putClientProperty(PROP_MODEL_INDEX, index);
        slider.addChangeListener(WeakListeners.change((ChangeListener)this.sliderChangeL, (Object)slider));
        this.sliderMap.put(index, slider);
        GridBagConstraints sliderConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 15, 3, new Insets(5, 5, 5, 5), 0, 0);
        GridBagConstraints labelConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0);
        panel.add((Component)slider, sliderConstraints);
        panel.add((Component)label, labelConstraints);
        return panel;
    }

    private void initComponents() {
        this.pnlEqualizer = new SplinePanel();
        this.setLayout(new GridBagLayout());
        this.pnlEqualizer.setOpaque(false);
        this.pnlEqualizer.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlEqualizer, gridBagConstraints);
    }

    private final class EqualizerModelL
    implements EqualizerModelListener {
        private EqualizerModelL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void equalizerChanged(EqualizerModelEvent event) {
            if (event.getSource() == EqualizerPanel.this.model) {
                EqualizerPanel.this.updateInProgress = true;
                try {
                    if (event.getIndex() < 0) {
                        for (int i = 0; i < EqualizerPanel.this.model.getEqualizerCategoryCount(); ++i) {
                            ((JSlider)EqualizerPanel.this.sliderMap.get(i)).setValue(EqualizerPanel.this.model.getValueAt(i));
                        }
                    } else {
                        JSlider slider = (JSlider)EqualizerPanel.this.sliderMap.get(event.getIndex());
                        int newValue = event.getNewValue();
                        if (slider.getValue() != newValue) {
                            slider.setValue(newValue);
                        }
                    }
                    EqualizerPanel.this.pnlEqualizer.repaint();
                }
                finally {
                    EqualizerPanel.this.updateInProgress = false;
                }
            }
        }
    }

    private final class SliderChangeL
    implements ChangeListener {
        private SliderChangeL() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!EqualizerPanel.this.updateInProgress) {
                EqualizerPanel.this.pnlEqualizer.repaint();
                JSlider slider = (JSlider)e.getSource();
                if (EqualizerPanel.this.updateModelWhileAdjusting || !slider.getValueIsAdjusting()) {
                    int index = (Integer)slider.getClientProperty(PROP_MODEL_INDEX);
                    EqualizerPanel.this.model.setValueAt(index, slider.getValue());
                }
            }
        }
    }

    private final class RangePanel
    extends JPanel {
        private static final int INSETS_WIDTH = 5;
        private static final int STROKE_WIDTH = 3;
        private static final int MAJOR_TICK_WIDTH = 10;
        private static final int MINOR_TICK_WIDTH = 7;
        private static final int TEXT_GAP_WIDTH = 8;
        private boolean useSliderTrackRectangleFallback;

        public RangePanel() {
            this.setOpaque(false);
            this.useSliderTrackRectangleFallback = false;
            Font font = this.getFont().deriveFont(10.0f);
            FontRenderContext frc = new FontRenderContext(font.getTransform(), true, true);
            Rectangle2D maxBounds = font.getStringBounds(String.valueOf(EqualizerPanel.this.model.getRange().getMax()), frc);
            Rectangle2D minBounds = font.getStringBounds(String.valueOf(EqualizerPanel.this.model.getRange().getMin()), frc);
            int minX1 = 5 + (int)maxBounds.getWidth() + 8 + 10 + 5;
            int minX2 = 5 + (int)minBounds.getWidth() + 8 + 10 + 5;
            int minX = Math.max(minX1, minX2);
            int minY = 5 + (int)maxBounds.getHeight() + 8 + (int)minBounds.getHeight() + 5;
            this.setMinimumSize(new Dimension(minX, minY));
            this.setPreferredSize(new Dimension(minX, minY));
            this.setFont(font);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            JSlider slider = (JSlider)EqualizerPanel.this.sliderMap.values().iterator().next();
            SliderUI sui = slider.getUI();
            Dimension size = this.getSize();
            int upperY = 0;
            int lowerY = 0;
            if (!this.useSliderTrackRectangleFallback && sui instanceof BasicSliderUI) {
                BasicSliderUI bui = (BasicSliderUI)sui;
                Field field = null;
                Boolean accessible = null;
                try {
                    field = BasicSliderUI.class.getDeclaredField("trackRect");
                    accessible = field.isAccessible();
                    field.setAccessible(true);
                    Rectangle r = (Rectangle)field.get(bui);
                    upperY = r.getLocation().y;
                    lowerY = upperY + (int)r.getHeight();
                }
                catch (Exception e) {
                    this.useSliderTrackRectangleFallback = true;
                }
                finally {
                    if (field != null && accessible != null) {
                        field.setAccessible(accessible);
                    }
                }
            } else {
                this.useSliderTrackRectangleFallback = true;
            }
            if (this.useSliderTrackRectangleFallback) {
                upperY = 13;
                lowerY = size.height - 13;
            }
            int midY = (lowerY - upperY) / 2 + upperY;
            int rangeLineX = size.width - 5 - 3;
            int majorTickX = rangeLineX - 10;
            int minorTickX = rangeLineX - 7;
            int upperRangeY = upperY + 3;
            int lowerRangeY = lowerY + 3;
            int midRangeY = midY + 3;
            int rangeMin = EqualizerPanel.this.model.getRange().getMin();
            int rangeMax = EqualizerPanel.this.model.getRange().getMax();
            int rangeMid = (rangeMax + rangeMin) / 2;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setStroke(new BasicStroke(3.0f, 2, 0));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawLine(rangeLineX, upperY, rangeLineX, lowerY);
            g2.drawLine(majorTickX, upperY, rangeLineX, upperY);
            g2.drawLine(majorTickX, lowerY, rangeLineX, lowerY);
            g2.drawLine(minorTickX, midY, rangeLineX, midY);
            g2.drawString(String.valueOf(rangeMax), 5, upperRangeY);
            g2.drawString(String.valueOf(rangeMin), 5, lowerRangeY);
            g2.drawString(String.valueOf(rangeMid), 5, midRangeY);
            g2.dispose();
        }
    }

    private final class SplinePanel
    extends JPanel {
        private boolean useSliderKnobPositionFallback;
        private Point2D.Double[] currentPoints;

        public SplinePanel() {
            this.setOpaque(false);
            this.useSliderKnobPositionFallback = false;
            this.currentPoints = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!EqualizerPanel.this.splinePainted || EqualizerPanel.this.model.getEqualizerCategoryCount() < 2) {
                return;
            }
            Collection sliders = EqualizerPanel.this.sliderMap.values();
            Point2D.Double[] p = new Point2D.Double[sliders.size()];
            int i = 0;
            boolean isAdjusting = false;
            for (JSlider s : EqualizerPanel.this.sliderMap.values()) {
                if (!EqualizerPanel.this.updateSplineWhileAdjusting && s.getValueIsAdjusting()) {
                    isAdjusting = true;
                    break;
                }
                Point handle = new Point();
                SliderUI sui = s.getUI();
                if (!this.useSliderKnobPositionFallback && sui instanceof BasicSliderUI) {
                    BasicSliderUI bui = (BasicSliderUI)sui;
                    Field field = null;
                    Boolean accessible = null;
                    try {
                        field = BasicSliderUI.class.getDeclaredField("thumbRect");
                        accessible = field.isAccessible();
                        field.setAccessible(true);
                        Rectangle r = (Rectangle)field.get(bui);
                        Point loc = r.getLocation();
                        handle.x = loc.x + r.width / 2;
                        handle.y = loc.y + r.height / 2;
                    }
                    catch (Exception e) {
                        this.useSliderKnobPositionFallback = true;
                    }
                    finally {
                        if (field != null && accessible != null) {
                            field.setAccessible(accessible);
                        }
                    }
                } else {
                    this.useSliderKnobPositionFallback = true;
                }
                if (this.useSliderKnobPositionFallback) {
                    int min = s.getMinimum();
                    int max = s.getMaximum();
                    int val = s.getValue();
                    Dimension sliderSize = s.getSize();
                    handle.x = sliderSize.width / 2;
                    double sliderPercentage = 1.0 - (double)val / (double)(max - min);
                    double offset = 13.0 * (1.0 - 2.0 * sliderPercentage);
                    handle.y = (int)((double)sliderSize.height * sliderPercentage + offset);
                }
                Point rel = SwingUtilities.convertPoint(s, handle, this);
                p[i] = new Point2D.Double(rel.x, rel.y);
                ++i;
            }
            if (isAdjusting) {
                p = this.currentPoints;
            }
            Point2D.Double[] p1 = new Point2D.Double[p.length - 1];
            Point2D.Double[] p2 = new Point2D.Double[p.length - 1];
            this.calculateControlPoints(p, p1, p2);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath path = new GeneralPath();
            path.moveTo(p[0].x, p[0].y);
            for (i = 0; i < p1.length; ++i) {
                path.curveTo(p1[i].x, p1[i].y, p2[i].x, p2[i].y, p[i + 1].x, p[i + 1].y);
            }
            g2.setPaint(EqualizerPanel.this.splinePaint);
            g2.setStroke(EqualizerPanel.this.splineStroke);
            g2.draw(path);
            g2.dispose();
            this.currentPoints = p;
        }

        private void calculateControlPoints(Point2D.Double[] p, Point2D.Double[] p1, Point2D.Double[] p2) {
            if (p == null) {
                throw new IllegalArgumentException("points must not be null");
            }
            if (p1 == null) {
                throw new IllegalArgumentException("p1 must not be null");
            }
            if (p2 == null) {
                throw new IllegalArgumentException("p2 must not be null");
            }
            int n = p.length - 1;
            if (n == 0) {
                throw new IllegalStateException("at least two points must be available to calculate control points for");
            }
            if (p1.length != n) {
                throw new IllegalStateException("p1 must have length of " + n + ", but is " + p1.length);
            }
            if (p2.length != n) {
                throw new IllegalStateException("p2 must have length of " + n + ", but is " + p1.length);
            }
            if (n == 1) {
                p1[0].x = (2.0 * p[0].x + p[1].x) / 3.0;
                p1[0].y = (2.0 * p[0].y + p[1].y) / 3.0;
                p2[0].x = 2.0 * p1[0].x - p[0].x;
                p2[0].y = 2.0 * p1[0].y - p[0].y;
            } else {
                double[] rhs = new double[n];
                rhs[0] = p[0].x + 2.0 * p[1].x;
                for (int i = 1; i < n - 1; ++i) {
                    rhs[i] = 4.0 * p[i].x + 2.0 * p[i + 1].x;
                }
                rhs[n - 1] = (8.0 * p[n - 1].x + p[n].x) / 2.0;
                double[] x1 = this.getFirstControlPoints(rhs);
                rhs[0] = p[0].y + 2.0 * p[1].y;
                for (int i = 1; i < n - 1; ++i) {
                    rhs[i] = 4.0 * p[i].y + 2.0 * p[i + 1].y;
                }
                rhs[n - 1] = (8.0 * p[n - 1].y + p[n].y) / 2.0;
                double[] y1 = this.getFirstControlPoints(rhs);
                for (int i = 0; i < n; ++i) {
                    double y2;
                    double x2;
                    p1[i] = new Point2D.Double(x1[i], y1[i]);
                    if (i < n - 1) {
                        x2 = 2.0 * p[i + 1].x - x1[i + 1];
                        y2 = 2.0 * p[i + 1].y - y1[i + 1];
                    } else {
                        x2 = (p[n].x + x1[n - 1]) / 2.0;
                        y2 = (p[n].y + y1[n - 1]) / 2.0;
                    }
                    p2[i] = new Point2D.Double(x2, y2);
                }
            }
        }

        private double[] getFirstControlPoints(double[] rhs) {
            int i;
            int n = rhs.length;
            double[] x = new double[n];
            double[] tmp = new double[n];
            double b = 2.0;
            x[0] = rhs[0] / b;
            for (i = 1; i < n; ++i) {
                tmp[i] = 1.0 / b;
                b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
                x[i] = (rhs[i] - x[i - 1]) / b;
            }
            for (i = 1; i < n; ++i) {
                int n2 = n - i - 1;
                x[n2] = x[n2] - tmp[n - i] * x[n - i];
            }
            return x;
        }
    }
}

