/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.equalizer;

import java.io.Serializable;

public final class Range
implements Serializable {
    private final int min;
    private final int max;

    public Range(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("min is not less than max: [min=" + min + "|max=" + max + "]");
        }
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + this.min;
        hash = 11 * hash + this.max;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return this.min == other.min && this.max == other.max;
    }

    public String toString() {
        return super.toString() + " [min=" + this.min + "|max=" + this.max + "]";
    }
}

