/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.protocol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolStepConfiguration;
import de.cismet.commons.gui.protocol.ProtocolStepMetaInfo;
import de.cismet.commons.gui.protocol.listener.ProtocolStepListener;
import de.cismet.commons.gui.protocol.listener.ProtocolStepListenerEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractProtocolStep
implements ProtocolStep {
    private static final transient Logger LOG = Logger.getLogger(AbstractProtocolStep.class);
    protected static final transient ObjectMapper MAPPER = new ObjectMapper();
    @JsonIgnore
    private transient boolean isInited;
    @JsonProperty(required=true)
    private ProtocolStepMetaInfo metaInfo;
    @JsonProperty(required=true)
    private Date date;
    private final transient ProtocolStepListenerHandler listenerHandler = new ProtocolStepListenerHandler();

    protected AbstractProtocolStep() {
        this.metaInfo = this.createMetaInfo();
        this.date = new Date();
    }

    @Override
    public void init() {
        this.setInited(false);
        this.initParameters();
        this.setInited(true);
        this.fireParametersChanged(new ProtocolStepListenerEvent(this));
    }

    public void initParameters() {
    }

    protected abstract ProtocolStepMetaInfo createMetaInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonString() throws JsonProcessingException {
        ObjectMapper objectMapper = MAPPER;
        synchronized (objectMapper) {
            return MAPPER.writeValueAsString((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtocolStep fromJsonString(String jsonString, Class<? extends AbstractProtocolStep> protocolStep) throws IOException {
        ObjectMapper objectMapper = MAPPER;
        synchronized (objectMapper) {
            return (AbstractProtocolStep)MAPPER.readValue(jsonString, protocolStep);
        }
    }

    @Override
    public ProtocolStepConfiguration getConfiguration() {
        if (this.getMetaInfo() != null && this.getMetaInfo().getKey() != null) {
            return ProtocolHandler.getInstance().getProtocolStepConfiguration(this.getMetaInfo().getKey());
        }
        return null;
    }

    @Override
    public abstract AbstractProtocolStepPanel visualize();

    @Override
    public boolean addProtocolStepListener(ProtocolStepListener listener) {
        return this.listenerHandler.addProtocolStepListener(listener);
    }

    @Override
    public boolean removeProtocolStepListener(ProtocolStepListener listener) {
        return this.listenerHandler.removeProtocolStepListener(listener);
    }

    protected void fireParametersChanged(ProtocolStepListenerEvent event) {
        this.listenerHandler.parametersChanged(event);
    }

    @Override
    public boolean isInited() {
        return this.isInited;
    }

    @Override
    public ProtocolStepMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setMetaInfo(ProtocolStepMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    void setInited(boolean isInited) {
        this.isInited = isInited;
    }

    private ProtocolStepListenerHandler getListenerHandler() {
        return this.listenerHandler;
    }

    class ProtocolStepListenerHandler
    implements ProtocolStepListener {
        private final Collection<ProtocolStepListener> listeners = new ArrayList<ProtocolStepListener>();

        ProtocolStepListenerHandler() {
        }

        public boolean addProtocolStepListener(ProtocolStepListener listener) {
            return this.listeners.add(listener);
        }

        public boolean removeProtocolStepListener(ProtocolStepListener listener) {
            return this.listeners.remove(listener);
        }

        @Override
        public void parametersChanged(ProtocolStepListenerEvent event) {
            for (ProtocolStepListener listener : this.listeners) {
                listener.parametersChanged(event);
            }
        }
    }
}

