/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.protocol;

import com.jgoodies.looks.HeaderStyle;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolStepPanelWrapper;
import de.cismet.commons.gui.protocol.ProtocolStepToolbarItem;
import de.cismet.commons.gui.protocol.listener.ProtocolHandlerAdapter;
import de.cismet.commons.gui.protocol.listener.ProtocolHandlerListenerEvent;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jfree.ui.ExtensionFileFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProtocolPanel
extends JPanel
implements GUIWindow {
    private static final transient Logger LOG = Logger.getLogger(ProtocolPanel.class);
    private static final transient String FILE_SUFFIX = "prot";
    private final ProtocolHandler handler;
    private final FileFilter fileFilter = new ExtensionFileFilter(NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.filefilter.jsonfiledesc"), "prot");
    private final Map<ProtocolStep, ProtocolStepPanelWrapper> protocolStepToWrapperMap = new HashMap<ProtocolStep, ProtocolStepPanelWrapper>();
    private final GridBagConstraints wrapperConstraints = ProtocolPanel.createWrapperConstraints();
    private final GridBagConstraints fillerConstraints = ProtocolPanel.createFillerConstraints();
    private JButton btnClear;
    private JButton btnLoad;
    private JButton btnSave;
    private JFileChooser fchMain;
    private Box.Filler filToolbar;
    private JPanel panMain;
    private JPanel panSteps;
    private JPanel panStepsFiller;
    private JPanel panToolbarFiller;
    private JScrollPane scpSteps;
    private JToolBar.Separator sep1;
    private JToolBar.Separator sep2;
    private JToggleButton tbtRecordOnOff;
    private JToolBar tlbMain;

    public ProtocolPanel() {
        this((ProtocolHandler)null);
    }

    public ProtocolPanel(ProtocolHandler handler) {
        this.handler = handler != null ? handler : ProtocolHandler.getInstance();
        this.initComponents();
        this.getHandler().addProtocolHandlerListener(new ProtocolHandlerListenerImpl());
        this.addSteps(this.getHandler().getAllSteps(), true);
        this.addToolbarItems(this.getHandler().getToolbarItems());
    }

    private static GridBagConstraints createWrapperConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.insets = new Insets(5, 5, 5, 5);
        return constraints;
    }

    private static GridBagConstraints createFillerConstraints() {
        GridBagConstraints constraints = ProtocolPanel.createWrapperConstraints();
        constraints.weighty = 1.0;
        return constraints;
    }

    private void initComponents() {
        this.fchMain = new JFileChooser();
        this.tlbMain = new JToolBar();
        this.tbtRecordOnOff = new JToggleButton();
        this.sep1 = new JToolBar.Separator();
        this.btnLoad = new JButton();
        this.btnSave = new JButton();
        this.sep2 = new JToolBar.Separator();
        this.btnClear = new JButton();
        this.panToolbarFiller = new JPanel();
        this.filToolbar = (Box.Filler)Box.createHorizontalGlue();
        this.panMain = new JPanel();
        this.scpSteps = new JScrollPane();
        this.panSteps = new JPanel();
        this.panStepsFiller = new JPanel();
        this.fchMain.setFileFilter(this.getFileFilter());
        this.setLayout(new BorderLayout());
        this.tlbMain.setFloatable(false);
        this.tlbMain.setRollover(true);
        this.tlbMain.setFocusable(false);
        this.tbtRecordOnOff.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/gui/protocol/record_off.png")));
        this.tbtRecordOnOff.setSelected(this.getHandler().isRecordEnabled());
        Mnemonics.setLocalizedText((AbstractButton)this.tbtRecordOnOff, (String)NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.tbtRecordOnOff.text"));
        this.tbtRecordOnOff.setToolTipText(NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.tbtRecordOnOff.toolTipText"));
        this.tbtRecordOnOff.setBorderPainted(false);
        this.tbtRecordOnOff.setFocusPainted(false);
        this.tbtRecordOnOff.setFocusable(false);
        this.tbtRecordOnOff.setHorizontalTextPosition(0);
        this.tbtRecordOnOff.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/gui/protocol/record_on.png")));
        this.tbtRecordOnOff.setVerticalTextPosition(3);
        this.tbtRecordOnOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProtocolPanel.this.tbtRecordOnOffActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.tbtRecordOnOff);
        this.tlbMain.add(this.sep1);
        this.btnLoad.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/gui/protocol/load.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLoad, (String)NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.btnLoad.text"));
        this.btnLoad.setToolTipText(NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.btnLoad.toolTipText"));
        this.btnLoad.setFocusPainted(false);
        this.btnLoad.setFocusable(false);
        this.btnLoad.setHorizontalTextPosition(0);
        this.btnLoad.setVerticalTextPosition(3);
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProtocolPanel.this.btnLoadActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnLoad);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/gui/protocol/save.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.btnSave.text"));
        this.btnSave.setToolTipText(NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.btnSave.toolTipText"));
        this.btnSave.setFocusPainted(false);
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(0);
        this.btnSave.setVerticalTextPosition(3);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProtocolPanel.this.btnSaveActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnSave);
        this.tlbMain.add(this.sep2);
        this.btnClear.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/gui/protocol/remove_all.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClear, (String)NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.btnClear.text"));
        this.btnClear.setToolTipText(NbBundle.getMessage(ProtocolPanel.class, (String)"ProtocolPanel.btnClear.toolTipText"));
        this.btnClear.setFocusPainted(false);
        this.btnClear.setFocusable(false);
        this.btnClear.setHorizontalTextPosition(0);
        this.btnClear.setVerticalTextPosition(3);
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProtocolPanel.this.btnClearActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.btnClear);
        this.panToolbarFiller.setOpaque(false);
        this.panToolbarFiller.add(this.filToolbar);
        this.tlbMain.add(this.panToolbarFiller);
        this.tlbMain.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.add((Component)this.tlbMain, "North");
        this.panMain.setLayout(new GridBagLayout());
        this.panSteps.setLayout(new GridBagLayout());
        this.panStepsFiller.setPreferredSize(new Dimension(100, 1));
        GroupLayout panStepsFillerLayout = new GroupLayout(this.panStepsFiller);
        this.panStepsFiller.setLayout(panStepsFillerLayout);
        panStepsFillerLayout.setHorizontalGroup(panStepsFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        panStepsFillerLayout.setVerticalGroup(panStepsFillerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panSteps.add((Component)this.panStepsFiller, gridBagConstraints);
        this.scpSteps.setViewportView(this.panSteps);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panMain.add((Component)this.scpSteps, gridBagConstraints);
        this.add((Component)this.panMain, "Center");
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        this.getHandler().clearSteps();
    }

    private void tbtRecordOnOffActionPerformed(ActionEvent evt) {
        this.getHandler().setRecordEnabled(this.tbtRecordOnOff.isSelected());
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        int status = this.fchMain.showSaveDialog(StaticSwingTools.getParentFrame(this));
        if (status == 0) {
            final File selectedFile = this.fchMain.getSelectedFile();
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        File fileToSave = selectedFile.getName().toLowerCase().endsWith(".prot") ? selectedFile : new File(selectedFile.getAbsolutePath() + "." + ProtocolPanel.FILE_SUFFIX);
                        ProtocolPanel.this.getHandler().writeToFile(fileToSave);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    return null;
                }

                @Override
                protected void done() {
                }
            }.execute();
        } else if (status == 1) {
            // empty if block
        }
    }

    private void btnLoadActionPerformed(ActionEvent evt) {
        int status = this.fchMain.showOpenDialog(StaticSwingTools.getParentFrame(this));
        if (status == 0) {
            final File selectedFile = this.fchMain.getSelectedFile();
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        ProtocolPanel.this.getHandler().readFromFile(selectedFile);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    return null;
                }

                @Override
                protected void done() {
                }
            }.execute();
        } else if (status == 1) {
            // empty if block
        }
    }

    private void removeStep(ProtocolStep step) {
        ProtocolStepPanelWrapper wrapper = this.protocolStepToWrapperMap.get(step);
        if (wrapper != null) {
            this.panSteps.remove(wrapper);
            this.panSteps.revalidate();
            this.repaint();
        }
    }

    private void addToolbarItems(List<ProtocolStepToolbarItem> toolbarItems) {
        for (ProtocolStepToolbarItem toolbarItem : toolbarItems) {
            if (toolbarItem instanceof Component) {
                this.tlbMain.add((Component)((Object)toolbarItem));
                continue;
            }
            if (toolbarItem instanceof Action) {
                this.tlbMain.add((Action)((Object)toolbarItem));
                continue;
            }
            LOG.warn((Object)"toolbar item not added. was neither Component nor Action");
        }
    }

    private void addSteps(final List<ProtocolStep> steps, final boolean showImmediate) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (ProtocolStep step : steps) {
                try {
                    this.addStep(step, showImmediate);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"exception while adding step", (Throwable)ex);
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProtocolPanel.this.addSteps(steps, showImmediate);
                }
            });
        }
    }

    private void addStep(final ProtocolStep step, final boolean showImmediate) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("adding GUI for protocol " + step.getMetaInfo().getKey() + "' and rendering it immediately: " + showImmediate));
            }
            ProtocolStepPanelWrapper wrapper = new ProtocolStepPanelWrapper(step, showImmediate);
            this.panSteps.remove(this.panStepsFiller);
            this.panSteps.add((Component)wrapper, this.getWrapperConstraints());
            this.panSteps.add((Component)this.panStepsFiller, this.getFillerConstraints());
            this.panSteps.revalidate();
            this.protocolStepToWrapperMap.put(step, wrapper);
            this.scpSteps.getVerticalScrollBar().setValue(this.scpSteps.getVerticalScrollBar().getMaximum());
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProtocolPanel.this.addStep(step, showImmediate);
                }
            });
        }
    }

    private void clearSteps() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panSteps.removeAll();
            this.panSteps.revalidate();
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProtocolPanel.this.clearSteps();
                }
            });
        }
    }

    @Override
    public JComponent getGuiComponent() {
        return this;
    }

    @Override
    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    @Override
    public String getViewTitle() {
        return "";
    }

    @Override
    public Icon getViewIcon() {
        return null;
    }

    private ProtocolHandler getHandler() {
        return this.handler;
    }

    private FileFilter getFileFilter() {
        return this.fileFilter;
    }

    private Map<ProtocolStep, ProtocolStepPanelWrapper> getProtocolStepToWrapperMap() {
        return this.protocolStepToWrapperMap;
    }

    private GridBagConstraints getWrapperConstraints() {
        return this.wrapperConstraints;
    }

    private GridBagConstraints getFillerConstraints() {
        return this.fillerConstraints;
    }

    private class ProtocolHandlerListenerImpl
    extends ProtocolHandlerAdapter {
        private ProtocolHandlerListenerImpl() {
        }

        @Override
        public void recordStateChanged(final ProtocolHandlerListenerEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProtocolPanel.this.tbtRecordOnOff.setSelected(event.getSourceProtocolHander().isRecordEnabled());
                }
            });
        }

        @Override
        public void stepAdded(ProtocolHandlerListenerEvent event) {
            ProtocolPanel.this.addStep((ProtocolStep)event.getEventObject(), false);
        }

        @Override
        public void stepRemoved(ProtocolHandlerListenerEvent event) {
            ProtocolPanel.this.removeStep((ProtocolStep)event.getEventObject());
        }

        @Override
        public void stepsCleared(ProtocolHandlerListenerEvent event) {
            ProtocolPanel.this.clearSteps();
        }

        @Override
        public void stepsRestored(ProtocolHandlerListenerEvent event) {
            ProtocolPanel.this.clearSteps();
            ProtocolPanel.this.addSteps(event.getSourceProtocolHander().getAllSteps(), true);
        }
    }
}

