/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.protocol;

import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolStepPanel;
import de.cismet.commons.gui.protocol.listener.ProtocolStepListener;
import de.cismet.commons.gui.protocol.listener.ProtocolStepListenerEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProtocolStepPanelWrapper
extends JPanel {
    private static final transient Logger LOG = Logger.getLogger(ProtocolStepPanelWrapper.class);
    private final ProtocolStep protocolStep;
    private final ProtocolStepListener protocolStepListener;
    private JButton btnRemove;
    private JLabel lblIcon;
    private JLabel lblMain;
    private JLabel lblTitle;
    private JPanel panHeader;
    private JPanel panIcon;
    private JPanel panMain;
    private JPanel panRemove;
    private JPanel panTitle;
    private JSeparator sepHeaderMain;

    public ProtocolStepPanelWrapper(final ProtocolStep protocolStep, boolean showImmediate) {
        this.protocolStep = protocolStep;
        this.initComponents();
        if (showImmediate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"showImmediate is true => show step");
            }
            this.protocolStepListener = null;
            this.showStep();
        } else if (protocolStep.isInited()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"protocolStep is already initialized => show step");
            }
            this.protocolStepListener = null;
            this.showStep();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"protocolStep not yet initialized => registering listener");
            }
            this.protocolStepListener = new ProtocolStepListener(){

                @Override
                public void parametersChanged(ProtocolStepListenerEvent event) {
                    ProtocolStep step = event.getProtocolStep();
                    if (step.equals(protocolStep)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"protocolStep initialized => show step");
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProtocolStepPanelWrapper.this.showStep();
                            }
                        });
                    }
                }
            };
            protocolStep.addProtocolStepListener(this.getProtocolStepListener());
        }
    }

    public final void showStep() {
        ProtocolStepPanel protocolStepPanel = null;
        try {
            protocolStepPanel = this.getProtocolStep().visualize();
        }
        catch (Exception ex) {
            LOG.warn((Object)"error while creating step panel", (Throwable)ex);
        }
        if (protocolStepPanel != null) {
            Component iconComponent = protocolStepPanel.getIconComponent();
            Component titleComponent = protocolStepPanel.getTitleComponent();
            Component mainComponent = protocolStepPanel.getMainComponent();
            if (iconComponent != null) {
                this.panIcon.removeAll();
                this.panIcon.add(iconComponent, "Center");
            }
            if (titleComponent != null) {
                this.panTitle.removeAll();
                this.panTitle.add(titleComponent, "Center");
            }
            if (mainComponent != null) {
                this.panMain.removeAll();
                this.panMain.add(mainComponent, "Center");
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void initComponents() {
        this.panHeader = new JPanel();
        this.panRemove = new JPanel();
        this.btnRemove = new JButton();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.panIcon = new JPanel();
        this.lblIcon = new JLabel();
        this.panMain = new JPanel();
        this.lblMain = new JLabel();
        this.sepHeaderMain = new JSeparator();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.panHeader.setLayout(new GridBagLayout());
        this.panRemove.setLayout(new GridBagLayout());
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/gui/protocol/remove_step.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ProtocolStepPanelWrapper.class, (String)"ProtocolStepPanelWrapper.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(ProtocolStepPanelWrapper.class, (String)"ProtocolStepPanelWrapper.btnRemove.toolTipText"));
        this.btnRemove.setBorderPainted(false);
        this.btnRemove.setContentAreaFilled(false);
        this.btnRemove.setFocusPainted(false);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProtocolStepPanelWrapper.this.btnRemoveActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 24;
        this.panRemove.add((Component)this.btnRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panHeader.add((Component)this.panRemove, gridBagConstraints);
        this.panTitle.setMinimumSize(new Dimension(100, 30));
        this.panTitle.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)this.protocolStep.getMetaInfo().getDescription());
        this.panTitle.add((Component)this.lblTitle, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panHeader.add((Component)this.panTitle, gridBagConstraints);
        this.panIcon.setMinimumSize(new Dimension(30, 30));
        this.panIcon.setPreferredSize(new Dimension(30, 30));
        this.panIcon.setLayout(new BorderLayout());
        this.lblIcon.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblIcon, (String)NbBundle.getMessage(ProtocolStepPanelWrapper.class, (String)"ProtocolStepPanelWrapper.lblIcon.text"));
        this.panIcon.add((Component)this.lblIcon, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panHeader.add((Component)this.panIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panHeader, gridBagConstraints);
        this.panMain.setLayout(new BorderLayout());
        this.lblMain.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lblMain, (String)NbBundle.getMessage(ProtocolStepPanelWrapper.class, (String)"ProtocolStepPanelWrapper.lblMain.text"));
        this.panMain.add((Component)this.lblMain, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panMain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.sepHeaderMain, gridBagConstraints);
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        ProtocolHandler.getInstance().removeStep(this.getProtocolStep());
        if (this.getProtocolStepListener() != null) {
            this.getProtocolStep().removeProtocolStepListener(this.getProtocolStepListener());
        }
    }

    protected ProtocolStep getProtocolStep() {
        return this.protocolStep;
    }

    protected ProtocolStepListener getProtocolStepListener() {
        return this.protocolStepListener;
    }
}

