/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.wizard;

import java.awt.Component;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public abstract class AbstractWizardPanel
implements WizardDescriptor.Panel {
    protected final transient ChangeSupport changeSupport = new ChangeSupport((Object)this);
    protected transient WizardDescriptor wizard;
    private volatile transient Component component;
    private final transient ReentrantLock componentLock = new ReentrantLock(false);

    public Component getComponent() {
        this.componentLock.lock();
        try {
            if (this.component == null) {
                this.component = this.createComponent();
            }
            Component component = this.component;
            return component;
        }
        finally {
            this.componentLock.unlock();
        }
    }

    protected abstract Component createComponent();

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void readSettings(Object settings) {
        this.wizard = (WizardDescriptor)settings;
        this.read(this.wizard);
    }

    public void storeSettings(Object settings) {
        this.wizard = (WizardDescriptor)settings;
        this.store(this.wizard);
    }

    protected abstract void read(WizardDescriptor var1);

    protected abstract void store(WizardDescriptor var1);

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isValid() {
        return true;
    }
}

