/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.gui.wizard;

import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;

public final class WizardUtils {
    private WizardUtils() {
    }

    public static void setCustomButtonText(WizardDescriptor wizard, Object option, String text) {
        try {
            Field buttonField;
            if (WizardDescriptor.FINISH_OPTION.equals(option)) {
                buttonField = wizard.getClass().getDeclaredField("finishButton");
            } else if (WizardDescriptor.CANCEL_OPTION.equals(option)) {
                buttonField = wizard.getClass().getDeclaredField("cancelButton");
            } else if (WizardDescriptor.PREVIOUS_OPTION.equals(option)) {
                buttonField = wizard.getClass().getDeclaredField("previousButton");
            } else if (WizardDescriptor.NEXT_OPTION.equals(option)) {
                buttonField = wizard.getClass().getDeclaredField("nextButton");
            } else {
                throw new IllegalArgumentException("unsupported option: " + option);
            }
            boolean accessible = buttonField.isAccessible();
            buttonField.setAccessible(true);
            AbstractButton button = (AbstractButton)buttonField.get(wizard);
            buttonField.setAccessible(accessible);
            Mnemonics.setLocalizedText((AbstractButton)button, (String)text);
        }
        catch (Exception ex) {
            throw new IllegalStateException("cannot set customized text: [wizard=" + wizard + "|optionButton=" + option + "|text=" + text + "]", ex);
        }
    }
}

