/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.layout;

import de.cismet.layout.FadingPanel;
import de.cismet.layout.FadingPanelListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class FadingCardLayout
extends CardLayout {
    private static final String FADEPANEL_NAME = "__fadePanel__";
    private long fadeDuration = 1000L;
    private Hashtable<String, Component> componentHashtable = new Hashtable();
    private Component fadeTo = null;
    private FadingPanel fadePanel = new FadingPanel();

    public FadingCardLayout() {
        this.fadePanel.addFadingPanelListener(new FadingPanelListener(){

            @Override
            public void fadeFinished() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Container parent = FadingCardLayout.this.fadePanel.getParent();
                        FadingCardLayout.this.showWithoutFade(parent, FadingCardLayout.this.getCardnameOf(FadingCardLayout.this.fadeTo));
                        FadingCardLayout.this.fadeTo = null;
                        parent.remove(FadingCardLayout.this.fadePanel);
                    }
                });
            }
        });
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        this.componentHashtable.put(name, component);
        super.addLayoutComponent(name, component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        Enumeration<String> keys = this.componentHashtable.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (this.componentHashtable.get(key) != component) continue;
            this.componentHashtable.remove(key);
        }
        super.removeLayoutComponent(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int currentIndex = this.fadeTo != null ? FadingCardLayout.getIndexOfComponent(parent, this.fadeTo) : FadingCardLayout.getIndexOfCurrentComponent(parent);
            int nextIndex = ++currentIndex % parent.getComponentCount();
            nextIndex = parent.getComponent(nextIndex) == this.fadePanel ? ++nextIndex % parent.getComponentCount() : nextIndex;
            this.fade(parent, parent.getComponent(nextIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previous(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int currentIndex = this.fadeTo != null ? FadingCardLayout.getIndexOfComponent(parent, this.fadeTo) : FadingCardLayout.getIndexOfCurrentComponent(parent);
            int previousIndex = currentIndex == 0 ? parent.getComponentCount() - 1 : --currentIndex;
            previousIndex = parent.getComponent(previousIndex) == this.fadePanel ? --previousIndex % parent.getComponentCount() : previousIndex;
            this.fade(parent, parent.getComponent(previousIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void first(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int firstIndex = 0;
            firstIndex = parent.getComponent(firstIndex) == this.fadePanel ? ++firstIndex : firstIndex;
            this.fade(parent, parent.getComponent(firstIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void last(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int lastIndex = parent.getComponentCount() - 1;
            lastIndex = parent.getComponent(lastIndex) == this.fadePanel ? --lastIndex : lastIndex;
            this.fade(parent, parent.getComponent(lastIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(Container parent, String name) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.fade(parent, this.componentHashtable.get(name));
        }
    }

    private void showWithoutFade(Container parent, String name) {
        super.show(parent, name);
    }

    private void fade(Container parent, Component fadeTo) {
        Component fadeFrom = FadingCardLayout.getCurrentComponent(parent);
        if (fadeFrom == fadeTo) {
            this.showWithoutFade(parent, this.getCardnameOf(fadeTo));
        } else {
            this.fadeTo = fadeTo;
            if (this.getCardnameOf(this.fadePanel) == null) {
                parent.add((Component)this.fadePanel, FADEPANEL_NAME);
            }
            this.showWithoutFade(parent, FADEPANEL_NAME);
            this.fadePanel.startFading(fadeFrom, fadeTo, this.fadeDuration);
        }
    }

    private String getCardnameOf(Component component) {
        Enumeration<String> keys = this.componentHashtable.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (this.componentHashtable.get(key) != component) continue;
            return key;
        }
        return null;
    }

    private static int getIndexOfCurrentComponent(Container parent) {
        for (int index = 0; index < parent.getComponentCount(); ++index) {
            Component component = parent.getComponent(index);
            if (!component.isVisible()) continue;
            return index;
        }
        return -1;
    }

    private static int getIndexOfComponent(Container parent, Component component) {
        for (int index = 0; index < parent.getComponentCount(); ++index) {
            if (parent.getComponent(index) != component) continue;
            return index;
        }
        return -1;
    }

    private static Component getCurrentComponent(Container parent) {
        return parent.getComponent(FadingCardLayout.getIndexOfCurrentComponent(parent));
    }

    public long getFadeDuration() {
        return this.fadeDuration;
    }

    public void setFadeDuration(long fadeDuration) {
        this.fadeDuration = fadeDuration;
    }
}

