/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.layout;

import de.cismet.layout.FadingPanelListener;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;

public class FadingPanel
extends Component {
    private BufferedImage fadeFromImage;
    private BufferedImage fadeToImage;
    private EventListenerList fadeListenerList = new EventListenerList();
    private long fadeDuration;
    private long startTime = 0L;

    public void addFadingPanelListener(FadingPanelListener listener) {
        this.fadeListenerList.add(FadingPanelListener.class, listener);
    }

    private void fireFadeFinished() {
        for (FadingPanelListener listener : (FadingPanelListener[])this.fadeListenerList.getListeners(FadingPanelListener.class)) {
            listener.fadeFinished();
        }
    }

    public boolean isFading() {
        return this.startTime > 0L;
    }

    public void startFading(Component fadeFromComponent, Component fadeToComponent, long fadeDuration) {
        this.startFading(FadingPanel.createImageFromComponent(fadeFromComponent), FadingPanel.createImageFromComponent(fadeToComponent), fadeDuration);
    }

    public void startFading(BufferedImage fadeFromImage, BufferedImage fadeToImage, final long fadeDuration) {
        this.fadeFromImage = fadeFromImage;
        this.fadeToImage = fadeToImage;
        this.fadeDuration = fadeDuration;
        if (this.isFading()) {
            this.resetStartTime();
        } else {
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    FadingPanel.this.resetStartTime();
                    while (FadingPanel.this.ellapsedTime() < fadeDuration) {
                        FadingPanel.this.repaint();
                    }
                    FadingPanel.this.startTime = 0L;
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    FadingPanel.this.fireFadeFinished();
                }
            };
            worker.execute();
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        float alpha;
        if (this.fadeFromImage == null || this.fadeToImage == null) {
            return;
        }
        if (this.fadeDuration == 0L) {
            alpha = 1.0f;
        } else {
            alpha = (float)this.ellapsedTime() / (float)this.fadeDuration;
            alpha = alpha < 0.0f ? 0.0f : alpha;
            alpha = alpha > 1.0f ? 1.0f : alpha;
        }
        Graphics2D graphics2d = (Graphics2D)graphics;
        Composite oldComposite = graphics2d.getComposite();
        graphics2d.setComposite(AlphaComposite.SrcOver.derive(1.0f - alpha));
        graphics2d.drawImage(this.fadeFromImage, null, 0, 0);
        graphics2d.setComposite(AlphaComposite.SrcOver.derive(alpha));
        graphics2d.drawImage(this.fadeToImage, null, 0, 0);
        graphics2d.setComposite(oldComposite);
    }

    public long ellapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void resetStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public static BufferedImage createImageFromComponent(Component component) {
        if (component == null) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int width = component.getSize().width;
        int height = component.getSize().height;
        BufferedImage image = graphicsConfiguration.getColorModel().hasAlpha() ? graphicsConfiguration.createCompatibleImage(width, height) : new BufferedImage(width, height, 2);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            component.paint(graphics);
            graphics.dispose();
            return image;
        }
        return null;
    }
}

