/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lookupoptions.gui;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.connectioncontext.OptionsConnectionContext;
import de.cismet.lookupoptions.OptionsCategory;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.Lookup;

public class OptionsClient
implements Configurable {
    private static final OptionsClient INSTANCE = new OptionsClient();
    private static final String CONFIGURATION = "cismetLookupOptions";
    private final Logger log = Logger.getLogger(this.getClass());
    private final Hashtable<Class<? extends OptionsCategory>, OptionsCategory> categoriesTable = new Hashtable();
    private final ArrayList<OptionsPanelController> controllerList = new ArrayList();

    private OptionsClient() {
        Collection categories = Lookup.getDefault().lookupAll(OptionsCategory.class);
        for (OptionsCategory category : categories) {
            this.categoriesTable.put(category.getClass(), category);
        }
        for (OptionsPanelController controller : Lookup.getDefault().lookupAll(OptionsPanelController.class)) {
            if (controller instanceof ConnectionContextStore) {
                ((ConnectionContextStore)controller).initWithConnectionContext((ConnectionContext)new OptionsConnectionContext(controller.getClass().getSimpleName()));
            }
            if (!controller.isEnabled()) continue;
            this.controllerList.add(controller);
        }
    }

    public static OptionsClient getInstance() {
        return INSTANCE;
    }

    public void applyAll() {
        for (OptionsPanelController controller : this.controllerList) {
            if (!controller.isChanged()) continue;
            controller.applyChanges();
        }
    }

    public void cancelAll() {
        for (OptionsPanelController controller : this.controllerList) {
            if (!controller.isChanged()) continue;
            controller.cancel();
        }
    }

    public void update(Class<? extends OptionsCategory> categoryClass) {
        for (OptionsPanelController controller : this.controllerList) {
            if (!controller.getCategoryClass().equals(categoryClass) || controller.isChanged()) continue;
            controller.update();
        }
    }

    public OptionsCategory[] getCategories() {
        ArrayList<OptionsCategory> sortedCategories = new ArrayList<OptionsCategory>(this.categoriesTable.values());
        Collections.sort(sortedCategories);
        return sortedCategories.toArray(new OptionsCategory[0]);
    }

    public OptionsCategory getCategory(Class<? extends OptionsCategory> categoryClass) {
        return this.categoriesTable.get(categoryClass);
    }

    public OptionsPanelController[] getControllers(Class<? extends OptionsCategory> categoryClass) {
        ArrayList<OptionsPanelController> sortedPanels = new ArrayList<OptionsPanelController>();
        for (OptionsPanelController controller : this.controllerList) {
            if (!controller.getCategoryClass().equals(categoryClass)) continue;
            sortedPanels.add(controller);
        }
        Collections.sort(sortedPanels);
        return sortedPanels.toArray(new OptionsPanelController[0]);
    }

    public void configure(Element parent) {
        Element conf = parent.getChild(CONFIGURATION);
        for (OptionsPanelController controller : this.controllerList) {
            controller.configure(conf);
        }
    }

    public void masterConfigure(Element parent) {
        Element conf = parent.getChild(CONFIGURATION);
        for (OptionsPanelController controller : this.controllerList) {
            controller.masterConfigure(conf);
        }
    }

    public Element getConfiguration() throws NoWriteError {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"OptionsClient.getConfiguration");
        }
        Element root = new Element(CONFIGURATION);
        for (Configurable configurable : this.controllerList) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)" - OptionsClient.getConfiguration");
            }
            try {
                Element element = configurable.getConfiguration();
                if (element == null) continue;
                root.addContent((Content)element);
            }
            catch (Exception t) {
                this.log.warn((Object)"Fehler beim Schreiben der eines Konfigurationsteils.", (Throwable)t);
            }
        }
        return root;
    }
}

