/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lookupoptions.gui;

import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonBarUI;
import de.cismet.lookupoptions.OptionsCategory;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.lookupoptions.gui.HelpDialog;
import de.cismet.lookupoptions.gui.OptionsClient;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class OptionsDialog
extends JDialog
implements WindowListener {
    private static final Dimension CATEGORYBUTTON_DIMENSION = new Dimension(100, 70);
    private final Logger log = Logger.getLogger(this.getClass());
    private OptionsClient optionsClient = OptionsClient.getInstance();
    private Hashtable<OptionsCategory, OptionsPanelController> selectedControllerPerCategory = new Hashtable();
    private OptionsCategory selectedCategory;
    private JButton btnClose;
    private JButton btnHelp;
    private JButton btnOk;
    private JPanel panCategories;
    private JPanel panCategory;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"OptionsDialog constructor");
        }
        this.initComponents();
        this.initOptionsPanels();
        this.getRootPane().setDefaultButton(this.btnOk);
        StaticSwingTools.doClickButtonOnKeyStroke(this.btnOk, KeyStroke.getKeyStroke(10, 0), this.getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke(this.btnClose, KeyStroke.getKeyStroke(27, 0), this.getRootPane());
        this.setLocationRelativeTo(parent);
        this.addWindowListener(this);
    }

    private void initOptionsPanels() {
        OptionsCategory[] categories;
        JButtonBar buttonbar = new JButtonBar(0);
        buttonbar.setUI((ButtonBarUI)new BlueishButtonBarUI());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final OptionsCategory category : categories = this.optionsClient.getCategories()) {
            OptionsPanelController[] controllers;
            final Class<?> categoryClass = category.getClass();
            Icon categoryIcon = category.getIcon();
            String categoryName = category.getName();
            String categoryTooltip = category.getTooltip();
            final String categoryCardName = categoryClass.getCanonicalName();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("OptionsCategory: " + categoryName));
            }
            if ((controllers = this.optionsClient.getControllers(categoryClass)).length <= 0) continue;
            JToggleButton button = new JToggleButton();
            button.setPreferredSize(CATEGORYBUTTON_DIMENSION);
            button.setLayout(new BorderLayout());
            button.add((Component)new JLabel(categoryIcon), "Center");
            button.add((Component)new JLabel(categoryName, 0), "South");
            button.setToolTipText(categoryTooltip);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.optionsClient.update(categoryClass);
                    ((CardLayout)OptionsDialog.this.panCategory.getLayout()).show(OptionsDialog.this.panCategory, categoryCardName);
                    OptionsDialog.this.selectedCategory = category;
                    OptionsDialog.this.selectedPanelChanged();
                }
            });
            buttonGroup.add(button);
            buttonbar.add((Component)button);
            if (this.selectedCategory == null) {
                this.selectedCategory = category;
            }
            if (controllers.length == 1) {
                OptionsPanelController controller = controllers[0];
                JPanel panel = controller.getPanel();
                this.panCategory.add((Component)panel, categoryCardName);
                this.selectedControllerPerCategory.put(category, controller);
                continue;
            }
            if (controllers.length <= 1) continue;
            JTabbedPane tbpPanels = new JTabbedPane();
            for (final OptionsPanelController controller : controllers) {
                if (this.selectedControllerPerCategory.get(category) == null) {
                    this.selectedControllerPerCategory.put(category, controller);
                }
                String controllerName = controller.getName();
                String controllerTooltip = controller.getTooltip();
                final JPanel controllerPanel = controller.getPanel();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("OptionsPanelController: " + controllerName));
                }
                tbpPanels.addTab(controllerName, null, controllerPanel, controllerTooltip);
                tbpPanels.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
                        if (sourceTabbedPane.getSelectedComponent() == controllerPanel) {
                            OptionsDialog.this.selectedControllerPerCategory.put(category, controller);
                            OptionsDialog.this.selectedPanelChanged();
                        }
                    }
                });
            }
            this.panCategory.add((Component)tbpPanels, categoryCardName);
        }
        this.panCategories.add((Component)buttonbar);
        JToggleButton firstButton = (JToggleButton)buttonbar.getComponent(0);
        if (firstButton != null) {
            buttonGroup.setSelected(firstButton.getModel(), true);
        }
        this.selectedPanelChanged();
    }

    private void initComponents() {
        this.panCategory = new JPanel();
        this.btnClose = new JButton();
        this.panCategories = new JPanel();
        this.btnOk = new JButton();
        this.btnHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.title"));
        this.panCategory.setLayout(new CardLayout());
        this.btnClose.setText(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.btnClose.text"));
        this.btnClose.setToolTipText(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.btnClose.tooltip"));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.panCategories.setMaximumSize(new Dimension(Short.MAX_VALUE, 90));
        this.panCategories.setMinimumSize(new Dimension(10, 90));
        this.panCategories.setLayout(new BorderLayout());
        this.btnOk.setText(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.btnOk.text"));
        this.btnOk.setToolTipText(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.btnOk.tooltip"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnHelp.setText(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.btnHelp.text"));
        this.btnHelp.setToolTipText(NbBundle.getMessage(OptionsDialog.class, (String)"OptionsDialog.btnHelp.tooltip"));
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.btnHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(336, Short.MAX_VALUE).addComponent(this.btnOk, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClose, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHelp, -2, 80, -2).addContainerGap()).addComponent(this.panCategories, -1, 600, Short.MAX_VALUE).addComponent(this.panCategory, GroupLayout.Alignment.TRAILING, -1, 600, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.panCategories, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panCategory, -1, 371, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnHelp).addComponent(this.btnClose).addComponent(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void selectedPanelChanged() {
        OptionsPanelController controller = this.selectedControllerPerCategory.get(this.selectedCategory);
        if (controller != null) {
            this.btnHelp.setEnabled(controller.getHelp() != null);
        } else {
            this.btnHelp.setEnabled(false);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        try {
            this.optionsClient.cancelAll();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"btnCloseActionPerformed", t);
            }
        }
        finally {
            this.dispose();
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        try {
            this.optionsClient.applyAll();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"btnOkActionPerformed", t);
            }
        }
        finally {
            this.dispose();
        }
    }

    private void btnHelpActionPerformed(ActionEvent evt) {
        OptionsPanelController controller = this.selectedControllerPerCategory.get(this.selectedCategory);
        String help = controller.getHelp();
        HelpDialog dialog = new HelpDialog((Frame)((JFrame)this.getParent()), true);
        dialog.setContent(help);
        StaticSwingTools.showDialog(dialog);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionsDialog dialog = new OptionsDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.optionsClient.update(this.selectedCategory.getClass());
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

