/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security.handler;

import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.Tunnel;
import de.cismet.commons.security.TunnelStore;
import de.cismet.commons.security.exceptions.BadHttpStatusCodeException;
import de.cismet.commons.security.exceptions.CannotReadFromURLException;
import de.cismet.netutil.Proxy;
import de.cismet.security.handler.HTTPBasedAccessHandler;
import de.cismet.security.handler.JcifsNtlmScheme;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.BindException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;

public class DefaultHTTPAccessHandler
extends HTTPBasedAccessHandler
implements TunnelStore {
    public static AccessHandler.ACCESS_METHODS[] SUPPORTED_ACCESS_METHODS = new AccessHandler.ACCESS_METHODS[]{AccessHandler.ACCESS_METHODS.GET_REQUEST, AccessHandler.ACCESS_METHODS.POST_REQUEST};
    public static final AccessHandler.ACCESS_HANDLER_TYPES ACCESS_HANDLER_TYPE = AccessHandler.ACCESS_HANDLER_TYPES.HTTP;
    private static final String USER_AGENT_HEADER_KEY = "User-Agent";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Tunnel tunnel = null;

    public DefaultHTTPAccessHandler(Proxy proxy) {
        super(proxy);
        AuthPolicy.registerAuthScheme((String)"NTLM", JcifsNtlmScheme.class);
    }

    public InputStream doRequest(URL url, Reader requestParameter, AccessHandler.ACCESS_METHODS method, HashMap<String, String> options) throws Exception {
        PostMethod httpMethod;
        String currentLine;
        HttpClient client = this.getSecurityEnabledHttpClient(url);
        StringBuilder parameter = new StringBuilder();
        BufferedReader reader = new BufferedReader(requestParameter);
        while ((currentLine = reader.readLine()) != null) {
            parameter.append(currentLine);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Access method: '" + method + "'."));
        }
        if (this.tunnel != null && (method == AccessHandler.ACCESS_METHODS.GET_REQUEST || method == AccessHandler.ACCESS_METHODS.POST_REQUEST || method == AccessHandler.ACCESS_METHODS.HEAD_REQUEST) && this.tunnel.isResponsible(method, url.toString())) {
            return this.tunnel.doRequest(url, (Reader)new StringReader(parameter.toString()), method, options);
        }
        switch (method) {
            case POST_REQUEST_NO_TUNNEL: 
            case POST_REQUEST: {
                httpMethod = new PostMethod(url.toString());
                httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity(parameter.toString(), "text/xml", "UTF-8"));
                break;
            }
            case GET_REQUEST_NO_TUNNEL: 
            case GET_REQUEST: {
                if (parameter.length() > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("HTTP GET: '" + url.toString() + "?" + parameter + "'."));
                    }
                    httpMethod = new GetMethod(url.toString() + "?" + parameter);
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("No parameters specified. HTTP GET: '" + url.toString() + "'."));
                }
                httpMethod = new GetMethod(url.toString());
                break;
            }
            case HEAD_REQUEST_NO_TUNNEL: 
            case HEAD_REQUEST: {
                if (parameter.length() > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("HTTP HEAD: '" + url.toString() + "?" + parameter + "'."));
                    }
                    httpMethod = new HeadMethod(url.toString() + "?" + parameter);
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("No parameters specified. HTTP HEAD: '" + url.toString() + "'."));
                }
                httpMethod = new HeadMethod(url.toString());
                break;
            }
            default: {
                if (parameter.length() > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("No method specified, switching to '" + AccessHandler.ACCESS_METHODS.GET_REQUEST + "'. URI used: '" + url.toString() + "?" + parameter + "'."));
                    }
                    httpMethod = new GetMethod(url.toString() + "?" + parameter);
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("No method specified, switching to '" + AccessHandler.ACCESS_METHODS.GET_REQUEST + "'. No parameters specified. URI used: '" + url.toString() + "'."));
                }
                httpMethod = new GetMethod(url.toString());
            }
        }
        if (options != null && !options.isEmpty()) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                httpMethod.addRequestHeader(option.getKey(), option.getValue());
            }
        }
        boolean hasBound = false;
        while (true) {
            try {
                Header location;
                httpMethod.setDoAuthentication(true);
                httpMethod.addRequestHeader(new Header(USER_AGENT_HEADER_KEY, "wunda"));
                int statuscode = client.executeMethod((HttpMethod)httpMethod);
                if (!(statuscode != 301 && statuscode != 308 || (location = httpMethod.getResponseHeader("location")) == null || location.getValue() == null || location.getValue().equals(""))) {
                    String newLocation = location.getValue();
                    httpMethod.setURI(new URI(newLocation, false));
                    statuscode = client.executeMethod((HttpMethod)httpMethod);
                }
                switch (statuscode) {
                    case 401: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"HTTP status code from server: SC_UNAUTHORIZED (401).");
                        }
                        throw new CannotReadFromURLException("You are not authorized to access this URL.");
                    }
                    case 200: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"HTTP status code from server: OK.");
                        }
                        if (method == AccessHandler.ACCESS_METHODS.HEAD_REQUEST || method == AccessHandler.ACCESS_METHODS.HEAD_REQUEST_NO_TUNNEL) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(baos);
                            oos.writeObject(httpMethod.getResponseHeaders());
                            oos.flush();
                            oos.close();
                            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                            baos.close();
                            return is;
                        }
                        return new BufferedInputStream(httpMethod.getResponseBodyAsStream());
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unhandled HTTP status code: " + statuscode + " (" + HttpStatus.getStatusText((int)statuscode) + ")"));
                }
                throw new BadHttpStatusCodeException(httpMethod.getURI().toString(), statuscode, HttpStatus.getStatusText((int)statuscode), httpMethod.getResponseBodyAsString());
            }
            catch (BindException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Catched Bind Exception. Will try again in 50 ms", (Throwable)e);
                }
                Thread.sleep(50L);
                continue;
            }
            break;
        }
    }

    public InputStream doRequest(URL url, InputStream requestParameter, HashMap<String, String> options) throws Exception {
        HttpClient client = this.getSecurityEnabledHttpClient(url);
        PostMethod postMethod = new PostMethod(url.toString());
        boolean hasUserAgent = false;
        postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity(requestParameter));
        if (options != null && !options.isEmpty()) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                if (option.getKey().equalsIgnoreCase(USER_AGENT_HEADER_KEY)) {
                    hasUserAgent = true;
                }
                postMethod.addRequestHeader(option.getKey(), option.getValue());
            }
        }
        boolean hasBound = false;
        while (!hasBound) {
            try {
                postMethod.setDoAuthentication(true);
                if (!hasUserAgent) {
                    postMethod.addRequestHeader(new Header(USER_AGENT_HEADER_KEY, "wunda"));
                }
                int statuscode = client.executeMethod((HttpMethod)postMethod);
                hasBound = true;
                switch (statuscode) {
                    case 401: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"HTTP status code from server: SC_UNAUTHORIZED (401).");
                        }
                        throw new CannotReadFromURLException("You are not authorized to access this URL.");
                    }
                    case 200: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"HTTP status code from server: OK.");
                        }
                        return new BufferedInputStream(postMethod.getResponseBodyAsStream());
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unhandled HTTP status code: " + statuscode + " (" + HttpStatus.getStatusText((int)statuscode) + ")."));
                }
                throw new BadHttpStatusCodeException(postMethod.getURI().toString(), statuscode, HttpStatus.getStatusText((int)statuscode), postMethod.getResponseBodyAsString());
            }
            catch (BindException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Catched Bind Exception. Will try again in 50 ms", (Throwable)e);
                }
                Thread.sleep(50L);
            }
        }
        throw new RuntimeException("Should never happen");
    }

    public boolean isAccessMethodSupported(AccessHandler.ACCESS_METHODS method) {
        for (AccessHandler.ACCESS_METHODS curMethod : SUPPORTED_ACCESS_METHODS) {
            if (curMethod != method) continue;
            return true;
        }
        return false;
    }

    public AccessHandler.ACCESS_HANDLER_TYPES getHandlerType() {
        return ACCESS_HANDLER_TYPE;
    }

    public Tunnel getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(Tunnel tunnel) {
        this.tunnel = tunnel;
    }
}

