/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security.handler;

import java.io.IOException;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;

public class JcifsNtlmScheme
implements AuthScheme {
    private Type2Message ntlmChallenge = null;
    private State state;

    public JcifsNtlmScheme() throws AuthenticationException {
        try {
            Class.forName("jcifs.ntlmssp.NtlmMessage", false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AuthenticationException("JCIFS lib not found");
        }
    }

    private static String toBase64String(NtlmMessage ntlmMessage) {
        return Base64.encode((byte[])ntlmMessage.toByteArray());
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        Type1Message response;
        NTCredentials ntcredentials;
        if (this.state == State.NOT_STARTED) {
            throw new IllegalStateException("NTLM authentication not started");
        }
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException ex) {
            throw new InvalidCredentialsException(String.format("Credentials cannot be used for NTLM authentication: %s", credentials.getClass().getName()), (Throwable)ex);
        }
        if (this.state == State.STARTED || this.state == State.FAILED) {
            response = new Type1Message(Type1Message.getDefaultFlags(), ntcredentials.getDomain(), ntcredentials.getHost());
            this.state = State.CHALLENGE_REQUESTED;
        } else {
            response = new Type3Message(this.ntlmChallenge, ntcredentials.getPassword(), ntcredentials.getDomain(), ntcredentials.getUserName(), ntcredentials.getHost(), 0);
            this.state = State.FINISHED;
        }
        return String.format("NTLM %s", JcifsNtlmScheme.toBase64String((NtlmMessage)response));
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String scheme = AuthChallengeParser.extractScheme((String)challenge);
        if (!scheme.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException(String.format("Invalid NTLM challenge: %s", challenge));
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            try {
                this.ntlmChallenge = new Type2Message(Base64.decode((String)challenge.substring(i, challenge.length()).trim()));
            }
            catch (IOException ex) {
                throw new MalformedChallengeException(String.format("Invalid NTLM challenge: %s", challenge), (Throwable)ex);
            }
            this.state = State.CHALLENGE_RECEIVED;
        } else {
            this.ntlmChallenge = null;
            this.state = this.state == State.NOT_STARTED ? State.STARTED : State.FAILED;
        }
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        throw new RuntimeException("Not implemented as it is deprecated anyway in Httpclient 3.x");
    }

    public String getID() {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public String getRealm() {
        return null;
    }

    public String getSchemeName() {
        return "NTLM";
    }

    public boolean isComplete() {
        return this.state == State.FINISHED || this.state == State.FAILED;
    }

    public boolean isConnectionBased() {
        return true;
    }

    private static enum State {
        NOT_STARTED,
        STARTED,
        CHALLENGE_REQUESTED,
        CHALLENGE_RECEIVED,
        FINISHED,
        FAILED;

    }
}

