/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.security.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;

public class SecondaryJksSSLSocketFactory
implements SecureProtocolSocketFactory {
    private static final transient Logger LOG = Logger.getLogger(SecondaryJksSSLSocketFactory.class);
    private final SSLContext sslContext = SSLContext.getInstance("TLS");
    private X509TrustManager origX509TM;
    private X509TrustManager ownX509TM;

    public SecondaryJksSSLSocketFactory(InputStream inputStream, String jksPassword) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        TrustManagerFactory origTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        origTrustManagerFactory.init((KeyStore)null);
        for (TrustManager origTrustManager : origTrustManagerFactory.getTrustManagers()) {
            if (!(origTrustManager instanceof X509TrustManager)) continue;
            this.origX509TM = (X509TrustManager)origTrustManager;
            break;
        }
        try {
            KeyStore ownKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
            ownKeystore.load(inputStream, jksPassword.toCharArray());
            TrustManagerFactory ownTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ownTrustManagerFactory.init(ownKeystore);
            for (TrustManager ownTrustManager : ownTrustManagerFactory.getTrustManagers()) {
                if (!(ownTrustManager instanceof X509TrustManager)) continue;
                this.ownX509TM = (X509TrustManager)ownTrustManager;
                break;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
        }
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (SecondaryJksSSLSocketFactory.this.ownX509TM != null) {
                    try {
                        SecondaryJksSSLSocketFactory.this.ownX509TM.checkClientTrusted(chain, authType);
                    }
                    catch (CertificateException ex) {
                        SecondaryJksSSLSocketFactory.this.origX509TM.checkClientTrusted(chain, authType);
                    }
                } else {
                    SecondaryJksSSLSocketFactory.this.origX509TM.checkClientTrusted(chain, authType);
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (SecondaryJksSSLSocketFactory.this.ownX509TM != null) {
                    try {
                        SecondaryJksSSLSocketFactory.this.ownX509TM.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException ex) {
                        SecondaryJksSSLSocketFactory.this.origX509TM.checkServerTrusted(chain, authType);
                    }
                } else {
                    SecondaryJksSSLSocketFactory.this.origX509TM.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return SecondaryJksSSLSocketFactory.this.origX509TM.getAcceptedIssuers();
            }
        };
        this.sslContext.init(null, new TrustManager[]{tm}, null);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.sslContext.getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

