/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.EventDispatchThreadHangMonitor;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private static final Logger log = Logger.getLogger(EventDispatchThreadHangMonitor.class);
    private static JButton test;
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;

    public CheckThreadViolationRepaintManager() {
        this(true);
    }

    public CheckThreadViolationRepaintManager(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(component);
        super.addInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(component);
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    protected void violationFound(JComponent c, final StackTraceElement[] stackTrace) {
        Throwable customThrowable = new Throwable(){

            @Override
            public StackTraceElement[] getStackTrace() {
                return stackTrace;
            }
        };
        log.fatal((Object)("EDT violation detected for Component:" + c), customThrowable);
    }

    public static void main(String[] args) throws Exception {
        RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CheckThreadViolationRepaintManager.test();
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)"Valid code passed...");
        }
        CheckThreadViolationRepaintManager.repaintTest();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Repaint test - correct code");
        }
        CheckThreadViolationRepaintManager.test();
    }

    static void test() {
        JFrame frame = new JFrame("Am I on EDT?");
        frame.setDefaultCloseOperation(3);
        frame.add(new JButton("JButton"));
        frame.pack();
        frame.setVisible(true);
        frame.dispose();
    }

    static void imageUpdateTest() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JEditorPane editor = new JEditorPane();
        frame.setContentPane(editor);
        editor.setContentType("text/html");
        editor.setText("<html><img src=\"file:\\lala.png\"></html>");
        frame.setSize(300, 200);
        frame.setVisible(true);
    }

    static void repaintTest() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    test = new JButton();
                    test.setSize(100, 100);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        test.repaint(test.getBounds());
        test.repaint(0, 0, 100, 100);
        test.repaint();
    }
}

