/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.treetable.AbstractCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openide.util.NbBundle;

public class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final String EDIT = "edit";
    private Color color;
    private final JButton button = new JButton();
    private final JColorChooser colorChooser;
    private final JDialog dialog;

    public ColorEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.button.setFocusPainted(false);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, NbBundle.getMessage(ColorEditor.class, (String)"ColorEditor.dialog.title"), true, this.colorChooser, this, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.button.setBackground(this.color);
            this.colorChooser.setColor(this.color);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.color = this.colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.color;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.color = (Color)value;
        return this.button;
    }
}

