/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.ExtensionAwareFileFilter;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.openide.util.NbBundle;

public class ConfirmationJFileChooser
extends JFileChooser {
    public ConfirmationJFileChooser() {
    }

    public ConfirmationJFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public ConfirmationJFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public ConfirmationJFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public ConfirmationJFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public ConfirmationJFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    @Override
    public void approveSelection() {
        File f = this.getSelectedFile();
        FileFilter ff = this.getFileFilter();
        if (!this.accept(f) && ff instanceof ExtensionAwareFileFilter) {
            f = new File(f.getAbsolutePath() + "." + ((ExtensionAwareFileFilter)ff).getExtension());
        }
        if (f.exists() && this.getDialogType() == 1) {
            String message = NbBundle.getMessage(ConfirmationJFileChooser.class, (String)"ConfirmationJFileChooser.approveSelection.message");
            String title = NbBundle.getMessage(ConfirmationJFileChooser.class, (String)"ConfirmationJFileChooser.approveSelection.title");
            int result = JOptionPane.showConfirmDialog(this, message, title, 1);
            switch (result) {
                case 0: {
                    super.approveSelection();
                    return;
                }
                case 1: {
                    return;
                }
                case -1: {
                    return;
                }
                case 2: {
                    this.cancelSelection();
                    return;
                }
            }
        } else {
            super.approveSelection();
        }
    }
}

