/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.BrowserLauncher;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public class FXWebViewPanel
extends JFXPanel {
    private static final Logger LOG = Logger.getLogger(FXWebViewPanel.class);
    protected WebEngine webEng = null;
    protected WebView webView;
    protected Scene scene;
    private String lastUrl = null;
    private String lastContent = null;

    public FXWebViewPanel() {
        Platform.setImplicitExit((boolean)false);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXWebViewPanel.this.scene = FXWebViewPanel.this.createBrowserScene();
                FXWebViewPanel.this.setScene(FXWebViewPanel.this.scene);
            }
        });
    }

    private Scene createBrowserScene() {
        this.webView = new WebView();
        this.webView.setContextMenuEnabled(false);
        this.webEng = this.webView.getEngine();
        this.webEng.setJavaScriptEnabled(true);
        this.webEng.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

            public void changed(ObservableValue<? extends Throwable> ov, Throwable t, Throwable t1) {
                LOG.error((Object)"Error in WebEngine Load Worker", t);
            }
        });
        this.webEng.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    FXWebViewPanel.this.addClickListenerToLinks();
                }
            }
        });
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(5.0));
        pane.setCenter((Node)this.webView);
        Scene s = new Scene((Parent)pane);
        return s;
    }

    private void addClickListenerToLinks() {
        NodeList nodeList = this.webEng.getDocument().getElementsByTagName("a");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node = nodeList.item(i);
            EventTarget eventTarget = (EventTarget)((Object)node);
            eventTarget.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event evt) {
                    EventTarget target = evt.getCurrentTarget();
                    HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                    String href = anchorElement.getHref();
                    String targetWindow = anchorElement.getTarget();
                    if (targetWindow != null && targetWindow.equalsIgnoreCase("_blank") || href != null && !href.endsWith("html") && !href.contains("#")) {
                        FXWebViewPanel.this.openInSystemBrowser(href);
                        evt.preventDefault();
                    }
                }
            }, false);
        }
    }

    private void openInSystemBrowser(final String url) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will Launch 2:" + url));
        }
        try {
            if (url != null) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Will Launch 1:" + url));
                            }
                            BrowserLauncher.openURL((String)url);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                };
                t.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public WebEngine getWebEngine() {
        return this.webEng;
    }

    public WebView getWebView() {
        return this.webView;
    }

    public void loadUrl(final String url) {
        if (this.webEng == null) {
            LOG.warn((Object)("JavaFX WebEnginge is not initialized. can not load url: " + url));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FXWebViewPanel: load url" + String.valueOf(url)));
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("FXWebViewPanel: load url in runLater: " + String.valueOf(url)));
                }
                FXWebViewPanel.this.scene = FXWebViewPanel.this.createBrowserScene();
                FXWebViewPanel.this.setScene(FXWebViewPanel.this.scene);
                FXWebViewPanel.this.lastContent = null;
                FXWebViewPanel.this.lastUrl = url;
                FXWebViewPanel.this.webEng.load(url);
            }
        });
    }

    public void refresh() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"FXWebViewPanel: reload url in runLater");
                }
                FXWebViewPanel.this.scene = FXWebViewPanel.this.createBrowserScene();
                FXWebViewPanel.this.setScene(FXWebViewPanel.this.scene);
                if (FXWebViewPanel.this.lastUrl != null) {
                    FXWebViewPanel.this.webEng.load(FXWebViewPanel.this.lastUrl);
                }
                if (FXWebViewPanel.this.lastContent != null) {
                    FXWebViewPanel.this.webEng.loadContent(FXWebViewPanel.this.lastContent);
                }
            }
        });
    }

    public void loadContent(final String htmlContent) {
        final Runnable loader = new Runnable(){

            @Override
            public void run() {
                try {
                    FXWebViewPanel.this.scene = FXWebViewPanel.this.createBrowserScene();
                    FXWebViewPanel.this.setScene(FXWebViewPanel.this.scene);
                    FXWebViewPanel.this.lastContent = htmlContent;
                    FXWebViewPanel.this.lastUrl = null;
                    FXWebViewPanel.this.webEng.loadContent(htmlContent);
                    FXWebViewPanel.this.webEng.setJavaScriptEnabled(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem during the rendering of the htmlContent", (Throwable)e);
                }
            }
        };
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (FXWebViewPanel.this.webEng == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"JavaFX WebEnginge is not initialized. Will wait for 1 sec and try again");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (FXWebViewPanel.this.webEng == null) {
                        LOG.warn((Object)("JavaFX WebEnginge is not initialized. can not load html content: " + htmlContent));
                    } else {
                        Platform.runLater((Runnable)loader);
                    }
                } else {
                    Platform.runLater((Runnable)loader);
                }
            }
        }).start();
    }
}

