/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JSearchTextField
extends JTextField {
    private static final int MARGIN_INNER_LEFT = 2;
    private static final int MARGIN_INNER_RIGHT = 2;
    private String emptyText = "";
    private Icon searchIcon = null;
    private Icon abortIcon;

    public JSearchTextField() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int mouseX;
                if (JSearchTextField.this.searchIcon != null && (mouseX = e.getX()) < JSearchTextField.this.getMargin().left) {
                    JSearchTextField.this.fireActionPerformed();
                }
                if (JSearchTextField.this.abortIcon != null && (mouseX = e.getX()) > JSearchTextField.this.getWidth() - JSearchTextField.this.getMargin().right) {
                    JSearchTextField.this.setText("");
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int mouseX;
                if (JSearchTextField.this.searchIcon != null && (mouseX = e.getX()) < JSearchTextField.this.getMargin().left) {
                    JSearchTextField.this.setCursor(new Cursor(12));
                    return;
                }
                if (JSearchTextField.this.abortIcon != null && !JSearchTextField.this.getText().isEmpty() && (mouseX = e.getX()) > JSearchTextField.this.getWidth() - JSearchTextField.this.getMargin().right) {
                    JSearchTextField.this.setCursor(new Cursor(12));
                    return;
                }
                JSearchTextField.this.setCursor(new Cursor(2));
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (27 == e.getExtendedKeyCode()) {
                    JSearchTextField.this.setText("");
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        int iconY;
        int iconX;
        int iconHeight;
        int iconWidth;
        super.paintComponent(g);
        Insets margin = new Insets(2, 2, 2, 2);
        if (this.searchIcon != null) {
            iconWidth = this.searchIcon.getIconWidth();
            iconHeight = this.searchIcon.getIconHeight();
            iconX = margin.left;
            iconY = (this.getHeight() - iconHeight) / 2;
            this.searchIcon.paintIcon(this, g, iconX, iconY);
            margin.left += iconWidth + 2;
        }
        if (this.abortIcon != null && !this.getText().isEmpty()) {
            iconWidth = this.abortIcon.getIconWidth();
            iconHeight = this.abortIcon.getIconHeight();
            iconX = this.getWidth() - iconWidth - margin.right - 2;
            iconY = (this.getHeight() - iconHeight) / 2;
            this.abortIcon.paintIcon(this, g, iconX, iconY);
            margin.right += iconWidth + 2;
        }
        this.setMargin(margin);
        if (this.getText() == null || this.getText().isEmpty()) {
            Graphics2D g2d = (Graphics2D)g;
            Font font = g2d.getFont();
            Color color = g2d.getColor();
            int textHeight = g2d.getFontMetrics().getHeight();
            int textBottomX = (this.getHeight() - textHeight) / 2 + textHeight - margin.bottom;
            g2d.setFont(font.deriveFont(2));
            g2d.setColor(UIManager.getColor("textInactiveText"));
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.emptyText, this.getInsets().left, textBottomX);
            g2d.setRenderingHints(g2d.getRenderingHints());
            g2d.setFont(font);
            g2d.setColor(color);
        }
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public Icon getSearchIcon() {
        return this.searchIcon;
    }

    public void setSearchIcon(Icon searchIcon) {
        this.searchIcon = searchIcon;
    }

    public Icon getAbortIcon() {
        return this.abortIcon;
    }

    public void setAbortIcon(Icon abortIcon) {
        this.abortIcon = abortIcon;
    }
}

