/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.RangeSlider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class MetalRangeSliderUI
extends MetalSliderUI {
    private Color rangeColor = Color.GREEN;
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;

    @Override
    public void installUI(JComponent c) {
        this.upperThumbRect = new Rectangle();
        super.installUI(c);
        this.rangeColor = darkShadowColor;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        int upperPosition;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int upperValue;
            int snappedValue = upperValue = this.slider.getValue() + this.slider.getExtent();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((upperValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(upperValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != upperValue) {
                    this.slider.setExtent(snappedValue - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            upperPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = upperPosition - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            upperPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = upperPosition - this.upperThumbRect.height / 2;
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (this.upperThumbSelected) {
            if (clipRect.intersects(this.thumbRect)) {
                this.paintLowerThumb(g);
            }
            if (clipRect.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(g);
            }
        } else {
            if (clipRect.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(g);
            }
            if (clipRect.intersects(this.thumbRect)) {
                this.paintLowerThumb(g);
            }
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        super.paintTrack(g);
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int lowerX = this.thumbRect.x + this.thumbRect.width / 2;
            int upperX = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int cy = trackBounds.height / 2 - 2;
            Color oldColor = g.getColor();
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.setColor(this.rangeColor);
            for (int y = 0; y <= 3; ++y) {
                g.drawLine(lowerX - trackBounds.x, y, upperX - trackBounds.x, y);
            }
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
            g.setColor(oldColor);
        } else {
            int lowerY = this.thumbRect.x + this.thumbRect.width / 2;
            int upperY = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int cx = trackBounds.width / 2 - 2;
            Color oldColor = g.getColor();
            g.translate(trackBounds.x + cx, trackBounds.y);
            g.setColor(this.rangeColor);
            for (int x = 0; x <= 3; ++x) {
                g.drawLine(x, lowerY - trackBounds.y, x, upperY - trackBounds.y);
            }
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
            g.setColor(oldColor);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
    }

    private void paintLowerThumb(Graphics g) {
        super.paintThumb(g);
    }

    private void paintUpperThumb(Graphics g) {
        Rectangle tempRect = this.thumbRect;
        this.thumbRect = this.upperThumbRect;
        super.paintThumb(g);
        this.thumbRect = tempRect;
    }

    private void setUpperThumbLocation(int x, int y) {
        Rectangle upperUnionRect = new Rectangle();
        upperUnionRect.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(x, y);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, upperUnionRect);
        this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(MetalRangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!MetalRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (MetalRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                MetalRangeSliderUI.this.slider.requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (MetalRangeSliderUI.this.upperThumbSelected) {
                if (MetalRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                } else if (MetalRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                }
            } else if (MetalRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            } else if (MetalRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                upperPressed = true;
            }
            if (lowerPressed) {
                switch (MetalRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.x;
                    }
                }
                MetalRangeSliderUI.this.upperThumbSelected = false;
                MetalRangeSliderUI.this.lowerDragging = true;
                return;
            }
            MetalRangeSliderUI.this.lowerDragging = false;
            if (upperPressed) {
                switch (MetalRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((MetalRangeSliderUI)MetalRangeSliderUI.this).upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((MetalRangeSliderUI)MetalRangeSliderUI.this).upperThumbRect.x;
                    }
                }
                MetalRangeSliderUI.this.upperThumbSelected = true;
                MetalRangeSliderUI.this.upperDragging = true;
                return;
            }
            MetalRangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MetalRangeSliderUI.this.lowerDragging = false;
            MetalRangeSliderUI.this.upperDragging = false;
            MetalRangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!MetalRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (MetalRangeSliderUI.this.lowerDragging) {
                MetalRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (MetalRangeSliderUI.this.upperDragging) {
                MetalRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int direction) {
            return false;
        }

        private void moveLowerThumb() {
            switch (MetalRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.y;
                    int trackBottom = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.y + (((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.height - 1);
                    int vMax = MetalRangeSliderUI.this.yPositionForValue(MetalRangeSliderUI.this.slider.getValue() + MetalRangeSliderUI.this.slider.getExtent());
                    if (MetalRangeSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    MetalRangeSliderUI.this.setThumbLocation(((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.x, thumbTop);
                    int thumbMiddle = thumbTop + halfThumbHeight;
                    MetalRangeSliderUI.this.slider.setValue(MetalRangeSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.x;
                    int trackRight = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.x + (((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.width - 1);
                    int hMax = MetalRangeSliderUI.this.xPositionForValue(MetalRangeSliderUI.this.slider.getValue() + MetalRangeSliderUI.this.slider.getExtent());
                    if (MetalRangeSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    MetalRangeSliderUI.this.setThumbLocation(thumbLeft, ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.y);
                    int thumbMiddle = thumbLeft + halfThumbWidth;
                    MetalRangeSliderUI.this.slider.setValue(MetalRangeSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
            }
        }

        private void moveUpperThumb() {
            switch (MetalRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset;
                    int trackTop = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.y;
                    int trackBottom = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.y + (((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.height - 1);
                    int vMin = MetalRangeSliderUI.this.yPositionForValue(MetalRangeSliderUI.this.slider.getValue());
                    if (MetalRangeSliderUI.this.drawInverted()) {
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    MetalRangeSliderUI.this.setUpperThumbLocation(((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.x, thumbTop);
                    int thumbMiddle = thumbTop + halfThumbHeight;
                    MetalRangeSliderUI.this.slider.setExtent(MetalRangeSliderUI.this.valueForYPosition(thumbMiddle) - MetalRangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset;
                    int trackLeft = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.x;
                    int trackRight = ((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.x + (((MetalRangeSliderUI)MetalRangeSliderUI.this).trackRect.width - 1);
                    int hMin = MetalRangeSliderUI.this.xPositionForValue(MetalRangeSliderUI.this.slider.getValue());
                    if (MetalRangeSliderUI.this.drawInverted()) {
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    MetalRangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((MetalRangeSliderUI)MetalRangeSliderUI.this).thumbRect.y);
                    int thumbMiddle = thumbLeft + halfThumbWidth;
                    MetalRangeSliderUI.this.slider.setExtent(MetalRangeSliderUI.this.valueForXPosition(thumbMiddle) - MetalRangeSliderUI.this.slider.getValue());
                    break;
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (!MetalRangeSliderUI.this.lowerDragging && !MetalRangeSliderUI.this.upperDragging) {
                MetalRangeSliderUI.this.calculateThumbLocation();
                MetalRangeSliderUI.this.slider.repaint();
            }
        }
    }
}

