/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PaginationPanel
extends JPanel {
    final ActionListener actionListener;
    private int pageSize = 100;
    private int page = 1;
    private long total = -1L;
    private JButton btnBack;
    private JButton btnFirst;
    private JButton btnForward;
    private JButton btnLast;
    private JButton btnRefresh;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel5;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblPage;
    private JLabel lblPageTotal;
    private JLabel lblRowsTotal;
    private JPanel panPaginationControl;
    private JPanel panPaginationPages;
    private JFormattedTextField tfPageSize;

    public PaginationPanel() {
        this((ActionListener)null);
    }

    public PaginationPanel(ActionListener actionListener) {
        this.initComponents();
        this.actionListener = actionListener;
    }

    private void initComponents() {
        this.panPaginationControl = new JPanel();
        this.btnRefresh = new JButton();
        this.btnFirst = new JButton();
        this.btnBack = new JButton();
        this.btnForward = new JButton();
        this.btnLast = new JButton();
        this.panPaginationPages = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblRowsTotal = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.lblPage = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblPageTotal = new JLabel();
        this.tfPageSize = new JFormattedTextField();
        this.jPanel5 = new JPanel();
        this.jSeparator3 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.panPaginationControl.setMinimumSize(new Dimension(145, 10));
        this.panPaginationControl.setPreferredSize(new Dimension(145, 10));
        this.panPaginationControl.setLayout(new GridBagLayout());
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/arrow-circle-double.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnRefresh.text"));
        this.btnRefresh.setToolTipText(NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnRefresh.toolTipText"));
        this.btnRefresh.setBorderPainted(false);
        this.btnRefresh.setContentAreaFilled(false);
        this.btnRefresh.setEnabled(false);
        this.btnRefresh.setMaximumSize(new Dimension(29, 29));
        this.btnRefresh.setMinimumSize(new Dimension(29, 29));
        this.btnRefresh.setPreferredSize(new Dimension(29, 29));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaginationPanel.this.btnRefreshActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPaginationControl.add((Component)this.btnRefresh, gridBagConstraints);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/control-stop-180.png")));
        this.btnFirst.setToolTipText(NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnFirst.toolTipText"));
        this.btnFirst.setBorderPainted(false);
        this.btnFirst.setContentAreaFilled(false);
        this.btnFirst.setEnabled(false);
        this.btnFirst.setMaximumSize(new Dimension(29, 29));
        this.btnFirst.setMinimumSize(new Dimension(29, 29));
        this.btnFirst.setPreferredSize(new Dimension(29, 29));
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaginationPanel.this.btnFirstActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPaginationControl.add((Component)this.btnFirst, gridBagConstraints);
        this.btnBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/control-180.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBack, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnBack.text"));
        this.btnBack.setToolTipText(NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnBack.toolTipText"));
        this.btnBack.setBorderPainted(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setEnabled(false);
        this.btnBack.setMaximumSize(new Dimension(29, 29));
        this.btnBack.setMinimumSize(new Dimension(29, 29));
        this.btnBack.setPreferredSize(new Dimension(29, 29));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaginationPanel.this.btnBackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPaginationControl.add((Component)this.btnBack, gridBagConstraints);
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/control.png")));
        this.btnForward.setToolTipText(NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnForward.toolTipText"));
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setEnabled(false);
        this.btnForward.setMaximumSize(new Dimension(29, 29));
        this.btnForward.setMinimumSize(new Dimension(29, 29));
        this.btnForward.setPreferredSize(new Dimension(29, 29));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaginationPanel.this.btnForwardActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPaginationControl.add((Component)this.btnForward, gridBagConstraints);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/tools/gui/control-stop.png")));
        this.btnLast.setToolTipText(NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.btnLast.toolTipText"));
        this.btnLast.setBorderPainted(false);
        this.btnLast.setContentAreaFilled(false);
        this.btnLast.setEnabled(false);
        this.btnLast.setMaximumSize(new Dimension(29, 29));
        this.btnLast.setMinimumSize(new Dimension(29, 29));
        this.btnLast.setPreferredSize(new Dimension(29, 29));
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaginationPanel.this.btnLastActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPaginationControl.add((Component)this.btnLast, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.panPaginationControl, gridBagConstraints);
        this.panPaginationPages.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panPaginationPages.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panPaginationPages.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblRowsTotal, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.lblRowsTotal.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panPaginationPages.add((Component)this.lblRowsTotal, gridBagConstraints);
        this.jSeparator2.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panPaginationPages.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 5);
        this.panPaginationPages.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblPage, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.lblPage.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panPaginationPages.add((Component)this.lblPage, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panPaginationPages.add((Component)this.jLabel6, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblPageTotal, (String)NbBundle.getMessage(PaginationPanel.class, (String)"PaginationPanel.lblPageTotal.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panPaginationPages.add((Component)this.lblPageTotal, gridBagConstraints);
        this.tfPageSize.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.tfPageSize.setMinimumSize(new Dimension(50, 27));
        this.tfPageSize.setPreferredSize(new Dimension(50, 27));
        this.tfPageSize.setValue(50L);
        this.tfPageSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PaginationPanel.this.tfPageSizeKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panPaginationPages.add((Component)this.tfPageSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.panPaginationPages, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel5, gridBagConstraints);
        this.jSeparator3.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jSeparator3, gridBagConstraints);
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        this.doPagination(this.getPage() + 1);
    }

    private void btnLastActionPerformed(ActionEvent evt) {
        this.doPagination(this.getLastPage());
    }

    private void btnFirstActionPerformed(ActionEvent evt) {
        this.doPagination(this.getFirstPage());
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.doPagination(this.getPage() - 1);
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.btnBack.setEnabled(enabled);
        this.btnFirst.setEnabled(enabled);
        this.btnForward.setEnabled(enabled);
        this.btnLast.setEnabled(enabled);
        this.btnRefresh.setEnabled(enabled);
        this.tfPageSize.setEditable(enabled);
    }

    private void tfPageSizeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                this.tfPageSize.commitEdit();
                this.refresh();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void refresh() {
        this.doPagination(this.getPage());
    }

    private void setPage(int page) {
        this.setPageSize(((Long)this.tfPageSize.getValue()).intValue());
        if (page > this.getLastPage()) {
            page = this.getLastPage();
        }
        if (page < this.getFirstPage()) {
            page = 1;
        }
        this.page = page;
        this.updateGuiElements();
    }

    private void doPagination(int page) {
        this.setPage(page);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, -1, null));
        }
    }

    private void updateGuiElements() {
        this.lblPage.setText(Integer.toString(this.page));
        this.lblRowsTotal.setText(Long.toString(this.total));
        this.lblPageTotal.setText(Integer.toString(this.getLastPage()));
        this.tfPageSize.setText(Integer.toString(this.pageSize));
        this.btnFirst.setEnabled(this.isEnabled() && this.getTotal() > 0L && this.page != this.getFirstPage());
        this.btnLast.setEnabled(this.isEnabled() && this.getTotal() > 0L && this.page != this.getLastPage());
        this.btnBack.setEnabled(this.isEnabled() && this.getTotal() > 0L && this.page > this.getFirstPage());
        this.btnForward.setEnabled(this.isEnabled() && this.getTotal() > 0L && this.page < this.getLastPage());
        this.btnRefresh.setEnabled(this.isEnabled() && this.getTotal() > 0L);
    }

    public void reset() {
        this.setPage(0);
    }

    private void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
        this.setPage(this.getPage());
    }

    private int getFirstPage() {
        return 1;
    }

    private int getLastPage() {
        if (this.pageSize > 0) {
            return (int)Math.ceil((double)this.total / (double)this.pageSize);
        }
        return 0;
    }
}

