/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import de.cismet.tools.gui.MetalRangeSliderUI;
import de.cismet.tools.gui.RangeSliderUI;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class RangeSlider
extends JSlider {
    public RangeSlider() {
        this.initSlider();
    }

    public RangeSlider(int min, int max) {
        super(min, max);
        this.initSlider();
    }

    private void initSlider() {
        this.setOrientation(0);
    }

    @Override
    public void updateUI() {
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.setUI(new MetalRangeSliderUI());
        } else {
            this.setUI(new RangeSliderUI(this));
        }
        this.updateLabelUIs();
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.getValue();
        if (oldValue == value) {
            return;
        }
        int oldExtent = this.getExtent();
        int newValue = Math.min(Math.max(this.getMinimum(), value), oldValue + oldExtent);
        int newExtent = oldExtent + oldValue - newValue;
        this.getModel().setRangeProperties(newValue, newExtent, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int value) {
        int lowerValue = this.getValue();
        int newExtent = Math.min(Math.max(0, value - lowerValue), this.getMaximum() - lowerValue);
        this.setExtent(newExtent);
    }
}

