/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.tools.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class RoundedPanel
extends JPanel {
    protected int curve = 20;
    protected int alpha = 60;
    private Color alphaColor;

    public RoundedPanel() {
        this.setOpaque(false);
        this.initComponents();
        this.setBackground(new Color(255, 255, 255));
    }

    public RoundedPanel(LayoutManager layout) {
        this.setOpaque(false);
        this.initComponents();
        this.setLayout(layout);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Color old = g2d.getColor();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.alphaColor);
        g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.curve, this.curve);
        g2d.setColor(old);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setBackground(Color bg) {
        this.alphaColor = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), this.alpha);
        super.setBackground(this.alphaColor);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.alphaColor = new Color(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue(), alpha);
    }

    public int getCurve() {
        return this.curve;
    }

    public void setCurve(int curve) {
        this.curve = curve;
    }
}

